/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.balanceplatform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** EntryModesRestriction */
@JsonPropertyOrder({
  EntryModesRestriction.JSON_PROPERTY_OPERATION,
  EntryModesRestriction.JSON_PROPERTY_VALUE
})
public class EntryModesRestriction {
  public static final String JSON_PROPERTY_OPERATION = "operation";
  private String operation;

  /** Gets or Sets value */
  public enum ValueEnum {
    BARCODE(String.valueOf("barcode")),

    CHIP(String.valueOf("chip")),

    COF(String.valueOf("cof")),

    CONTACTLESS(String.valueOf("contactless")),

    MAGSTRIPE(String.valueOf("magstripe")),

    MANUAL(String.valueOf("manual")),

    OCR(String.valueOf("ocr")),

    SERVER(String.valueOf("server")),

    UNKNOWN(String.valueOf("unknown"));

    private static final Logger LOG = Logger.getLogger(ValueEnum.class.getName());

    private String value;

    ValueEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ValueEnum fromValue(String value) {
      for (ValueEnum b : ValueEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ValueEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ValueEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_VALUE = "value";
  private List<ValueEnum> value;

  public EntryModesRestriction() {}

  /**
   * Defines how the condition must be evaluated.
   *
   * @param operation Defines how the condition must be evaluated.
   * @return the current {@code EntryModesRestriction} instance, allowing for method chaining
   */
  public EntryModesRestriction operation(String operation) {
    this.operation = operation;
    return this;
  }

  /**
   * Defines how the condition must be evaluated.
   *
   * @return operation Defines how the condition must be evaluated.
   */
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOperation() {
    return operation;
  }

  /**
   * Defines how the condition must be evaluated.
   *
   * @param operation Defines how the condition must be evaluated.
   */
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperation(String operation) {
    this.operation = operation;
  }

  /**
   * List of point-of-sale entry modes. Possible values: **barcode**, **chip**, **cof**,
   * **contactless**, **magstripe**, **manual**, **ocr**, **server**.
   *
   * @param value List of point-of-sale entry modes. Possible values: **barcode**, **chip**,
   *     **cof**, **contactless**, **magstripe**, **manual**, **ocr**, **server**.
   * @return the current {@code EntryModesRestriction} instance, allowing for method chaining
   */
  public EntryModesRestriction value(List<ValueEnum> value) {
    this.value = value;
    return this;
  }

  public EntryModesRestriction addValueItem(ValueEnum valueItem) {
    if (this.value == null) {
      this.value = new ArrayList<>();
    }
    this.value.add(valueItem);
    return this;
  }

  /**
   * List of point-of-sale entry modes. Possible values: **barcode**, **chip**, **cof**,
   * **contactless**, **magstripe**, **manual**, **ocr**, **server**.
   *
   * @return value List of point-of-sale entry modes. Possible values: **barcode**, **chip**,
   *     **cof**, **contactless**, **magstripe**, **manual**, **ocr**, **server**.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ValueEnum> getValue() {
    return value;
  }

  /**
   * List of point-of-sale entry modes. Possible values: **barcode**, **chip**, **cof**,
   * **contactless**, **magstripe**, **manual**, **ocr**, **server**.
   *
   * @param value List of point-of-sale entry modes. Possible values: **barcode**, **chip**,
   *     **cof**, **contactless**, **magstripe**, **manual**, **ocr**, **server**.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(List<ValueEnum> value) {
    this.value = value;
  }

  /** Return true if this EntryModesRestriction object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EntryModesRestriction entryModesRestriction = (EntryModesRestriction) o;
    return Objects.equals(this.operation, entryModesRestriction.operation)
        && Objects.equals(this.value, entryModesRestriction.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operation, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EntryModesRestriction {\n");
    sb.append("    operation: ").append(toIndentedString(operation)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of EntryModesRestriction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of EntryModesRestriction
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     EntryModesRestriction
   */
  public static EntryModesRestriction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, EntryModesRestriction.class);
  }

  /**
   * Convert an instance of EntryModesRestriction to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
