/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** CardDetailsRequest */
@JsonPropertyOrder({
  CardDetailsRequest.JSON_PROPERTY_CARD_NUMBER,
  CardDetailsRequest.JSON_PROPERTY_COUNTRY_CODE,
  CardDetailsRequest.JSON_PROPERTY_ENCRYPTED_CARD_NUMBER,
  CardDetailsRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  CardDetailsRequest.JSON_PROPERTY_SUPPORTED_BRANDS
})
public class CardDetailsRequest {
  public static final String JSON_PROPERTY_CARD_NUMBER = "cardNumber";
  private String cardNumber;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
  private String encryptedCardNumber;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_SUPPORTED_BRANDS = "supportedBrands";
  private List<String> supportedBrands;

  public CardDetailsRequest() {}

  /**
   * A minimum of the first eight digits of the card number. The full card number gives the best
   * result. You must be [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide) to collect
   * raw card data. Alternatively, you can use the &#x60;encryptedCardNumber&#x60; field.
   *
   * @param cardNumber A minimum of the first eight digits of the card number. The full card number
   *     gives the best result. You must be [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide) to
   *     collect raw card data. Alternatively, you can use the &#x60;encryptedCardNumber&#x60;
   *     field.
   * @return the current {@code CardDetailsRequest} instance, allowing for method chaining
   */
  public CardDetailsRequest cardNumber(String cardNumber) {
    this.cardNumber = cardNumber;
    return this;
  }

  /**
   * A minimum of the first eight digits of the card number. The full card number gives the best
   * result. You must be [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide) to collect
   * raw card data. Alternatively, you can use the &#x60;encryptedCardNumber&#x60; field.
   *
   * @return cardNumber A minimum of the first eight digits of the card number. The full card number
   *     gives the best result. You must be [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide) to
   *     collect raw card data. Alternatively, you can use the &#x60;encryptedCardNumber&#x60;
   *     field.
   */
  @JsonProperty(JSON_PROPERTY_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCardNumber() {
    return cardNumber;
  }

  /**
   * A minimum of the first eight digits of the card number. The full card number gives the best
   * result. You must be [fully PCI
   * compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide) to collect
   * raw card data. Alternatively, you can use the &#x60;encryptedCardNumber&#x60; field.
   *
   * @param cardNumber A minimum of the first eight digits of the card number. The full card number
   *     gives the best result. You must be [fully PCI
   *     compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide) to
   *     collect raw card data. Alternatively, you can use the &#x60;encryptedCardNumber&#x60;
   *     field.
   */
  @JsonProperty(JSON_PROPERTY_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardNumber(String cardNumber) {
    this.cardNumber = cardNumber;
  }

  /**
   * The shopper country. Format: [ISO 3166-1
   * alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   *
   * @param countryCode The shopper country. Format: [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   * @return the current {@code CardDetailsRequest} instance, allowing for method chaining
   */
  public CardDetailsRequest countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * The shopper country. Format: [ISO 3166-1
   * alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   *
   * @return countryCode The shopper country. Format: [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCountryCode() {
    return countryCode;
  }

  /**
   * The shopper country. Format: [ISO 3166-1
   * alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   *
   * @param countryCode The shopper country. Format: [ISO 3166-1
   *     alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  /**
   * The encrypted card number.
   *
   * @param encryptedCardNumber The encrypted card number.
   * @return the current {@code CardDetailsRequest} instance, allowing for method chaining
   */
  public CardDetailsRequest encryptedCardNumber(String encryptedCardNumber) {
    this.encryptedCardNumber = encryptedCardNumber;
    return this;
  }

  /**
   * The encrypted card number.
   *
   * @return encryptedCardNumber The encrypted card number.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEncryptedCardNumber() {
    return encryptedCardNumber;
  }

  /**
   * The encrypted card number.
   *
   * @param encryptedCardNumber The encrypted card number.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED_CARD_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncryptedCardNumber(String encryptedCardNumber) {
    this.encryptedCardNumber = encryptedCardNumber;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount The merchant account identifier, with which you want to process the
   *     transaction.
   * @return the current {@code CardDetailsRequest} instance, allowing for method chaining
   */
  public CardDetailsRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @return merchantAccount The merchant account identifier, with which you want to process the
   *     transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount The merchant account identifier, with which you want to process the
   *     transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * The card brands you support. This is the
   * [&#x60;brands&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods__resParam_paymentMethods-brands)
   * array from your
   * [&#x60;/paymentMethods&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods)
   * response. If not included, our API uses the ones configured for your merchant account and, if
   * provided, the country code.
   *
   * @param supportedBrands The card brands you support. This is the
   *     [&#x60;brands&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods__resParam_paymentMethods-brands)
   *     array from your
   *     [&#x60;/paymentMethods&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods)
   *     response. If not included, our API uses the ones configured for your merchant account and,
   *     if provided, the country code.
   * @return the current {@code CardDetailsRequest} instance, allowing for method chaining
   */
  public CardDetailsRequest supportedBrands(List<String> supportedBrands) {
    this.supportedBrands = supportedBrands;
    return this;
  }

  public CardDetailsRequest addSupportedBrandsItem(String supportedBrandsItem) {
    if (this.supportedBrands == null) {
      this.supportedBrands = new ArrayList<>();
    }
    this.supportedBrands.add(supportedBrandsItem);
    return this;
  }

  /**
   * The card brands you support. This is the
   * [&#x60;brands&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods__resParam_paymentMethods-brands)
   * array from your
   * [&#x60;/paymentMethods&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods)
   * response. If not included, our API uses the ones configured for your merchant account and, if
   * provided, the country code.
   *
   * @return supportedBrands The card brands you support. This is the
   *     [&#x60;brands&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods__resParam_paymentMethods-brands)
   *     array from your
   *     [&#x60;/paymentMethods&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods)
   *     response. If not included, our API uses the ones configured for your merchant account and,
   *     if provided, the country code.
   */
  @JsonProperty(JSON_PROPERTY_SUPPORTED_BRANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getSupportedBrands() {
    return supportedBrands;
  }

  /**
   * The card brands you support. This is the
   * [&#x60;brands&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods__resParam_paymentMethods-brands)
   * array from your
   * [&#x60;/paymentMethods&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods)
   * response. If not included, our API uses the ones configured for your merchant account and, if
   * provided, the country code.
   *
   * @param supportedBrands The card brands you support. This is the
   *     [&#x60;brands&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods__resParam_paymentMethods-brands)
   *     array from your
   *     [&#x60;/paymentMethods&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods)
   *     response. If not included, our API uses the ones configured for your merchant account and,
   *     if provided, the country code.
   */
  @JsonProperty(JSON_PROPERTY_SUPPORTED_BRANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupportedBrands(List<String> supportedBrands) {
    this.supportedBrands = supportedBrands;
  }

  /** Return true if this CardDetailsRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardDetailsRequest cardDetailsRequest = (CardDetailsRequest) o;
    return Objects.equals(this.cardNumber, cardDetailsRequest.cardNumber)
        && Objects.equals(this.countryCode, cardDetailsRequest.countryCode)
        && Objects.equals(this.encryptedCardNumber, cardDetailsRequest.encryptedCardNumber)
        && Objects.equals(this.merchantAccount, cardDetailsRequest.merchantAccount)
        && Objects.equals(this.supportedBrands, cardDetailsRequest.supportedBrands);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        cardNumber, countryCode, encryptedCardNumber, merchantAccount, supportedBrands);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardDetailsRequest {\n");
    sb.append("    cardNumber: ").append(toIndentedString(cardNumber)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    encryptedCardNumber: ")
        .append(toIndentedString(encryptedCardNumber))
        .append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    supportedBrands: ").append(toIndentedString(supportedBrands)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CardDetailsRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CardDetailsRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CardDetailsRequest
   */
  public static CardDetailsRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CardDetailsRequest.class);
  }

  /**
   * Convert an instance of CardDetailsRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
