/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/** CheckoutSDKAction */
@JsonPropertyOrder({
  CheckoutSDKAction.JSON_PROPERTY_PAYMENT_DATA,
  CheckoutSDKAction.JSON_PROPERTY_PAYMENT_METHOD_TYPE,
  CheckoutSDKAction.JSON_PROPERTY_SDK_DATA,
  CheckoutSDKAction.JSON_PROPERTY_TYPE,
  CheckoutSDKAction.JSON_PROPERTY_URL
})
public class CheckoutSDKAction {
  public static final String JSON_PROPERTY_PAYMENT_DATA = "paymentData";
  private String paymentData;

  public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
  private String paymentMethodType;

  public static final String JSON_PROPERTY_SDK_DATA = "sdkData";
  private Map<String, String> sdkData;

  /** The type of the action. */
  public enum TypeEnum {
    SDK(String.valueOf("sdk")),

    WECHATPAYSDK(String.valueOf("wechatpaySDK"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public CheckoutSDKAction() {}

  /**
   * Encoded payment data.
   *
   * @param paymentData Encoded payment data.
   * @return the current {@code CheckoutSDKAction} instance, allowing for method chaining
   */
  public CheckoutSDKAction paymentData(String paymentData) {
    this.paymentData = paymentData;
    return this;
  }

  /**
   * Encoded payment data.
   *
   * @return paymentData Encoded payment data.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentData() {
    return paymentData;
  }

  /**
   * Encoded payment data.
   *
   * @param paymentData Encoded payment data.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentData(String paymentData) {
    this.paymentData = paymentData;
  }

  /**
   * Specifies the payment method.
   *
   * @param paymentMethodType Specifies the payment method.
   * @return the current {@code CheckoutSDKAction} instance, allowing for method chaining
   */
  public CheckoutSDKAction paymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
    return this;
  }

  /**
   * Specifies the payment method.
   *
   * @return paymentMethodType Specifies the payment method.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentMethodType() {
    return paymentMethodType;
  }

  /**
   * Specifies the payment method.
   *
   * @param paymentMethodType Specifies the payment method.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
  }

  /**
   * The data to pass to the SDK.
   *
   * @param sdkData The data to pass to the SDK.
   * @return the current {@code CheckoutSDKAction} instance, allowing for method chaining
   */
  public CheckoutSDKAction sdkData(Map<String, String> sdkData) {
    this.sdkData = sdkData;
    return this;
  }

  public CheckoutSDKAction putSdkDataItem(String key, String sdkDataItem) {
    if (this.sdkData == null) {
      this.sdkData = new HashMap<>();
    }
    this.sdkData.put(key, sdkDataItem);
    return this;
  }

  /**
   * The data to pass to the SDK.
   *
   * @return sdkData The data to pass to the SDK.
   */
  @JsonProperty(JSON_PROPERTY_SDK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getSdkData() {
    return sdkData;
  }

  /**
   * The data to pass to the SDK.
   *
   * @param sdkData The data to pass to the SDK.
   */
  @JsonProperty(JSON_PROPERTY_SDK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkData(Map<String, String> sdkData) {
    this.sdkData = sdkData;
  }

  /**
   * The type of the action.
   *
   * @param type The type of the action.
   * @return the current {@code CheckoutSDKAction} instance, allowing for method chaining
   */
  public CheckoutSDKAction type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the action.
   *
   * @return type The type of the action.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the action.
   *
   * @param type The type of the action.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Specifies the URL to redirect to.
   *
   * @param url Specifies the URL to redirect to.
   * @return the current {@code CheckoutSDKAction} instance, allowing for method chaining
   */
  public CheckoutSDKAction url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Specifies the URL to redirect to.
   *
   * @return url Specifies the URL to redirect to.
   */
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUrl() {
    return url;
  }

  /**
   * Specifies the URL to redirect to.
   *
   * @param url Specifies the URL to redirect to.
   */
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }

  /** Return true if this CheckoutSDKAction object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckoutSDKAction checkoutSDKAction = (CheckoutSDKAction) o;
    return Objects.equals(this.paymentData, checkoutSDKAction.paymentData)
        && Objects.equals(this.paymentMethodType, checkoutSDKAction.paymentMethodType)
        && Objects.equals(this.sdkData, checkoutSDKAction.sdkData)
        && Objects.equals(this.type, checkoutSDKAction.type)
        && Objects.equals(this.url, checkoutSDKAction.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentData, paymentMethodType, sdkData, type, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckoutSDKAction {\n");
    sb.append("    paymentData: ").append(toIndentedString(paymentData)).append("\n");
    sb.append("    paymentMethodType: ").append(toIndentedString(paymentMethodType)).append("\n");
    sb.append("    sdkData: ").append(toIndentedString(sdkData)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CheckoutSDKAction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CheckoutSDKAction
   * @throws JsonProcessingException if the JSON string is invalid with respect to CheckoutSDKAction
   */
  public static CheckoutSDKAction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CheckoutSDKAction.class);
  }

  /**
   * Convert an instance of CheckoutSDKAction to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
