/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/** CreateCheckoutSessionRequest */
@JsonPropertyOrder({
  CreateCheckoutSessionRequest.JSON_PROPERTY_ACCOUNT_INFO,
  CreateCheckoutSessionRequest.JSON_PROPERTY_ADDITIONAL_AMOUNT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_ADDITIONAL_DATA,
  CreateCheckoutSessionRequest.JSON_PROPERTY_ALLOWED_PAYMENT_METHODS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_AMOUNT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_APPLICATION_INFO,
  CreateCheckoutSessionRequest.JSON_PROPERTY_AUTHENTICATION_DATA,
  CreateCheckoutSessionRequest.JSON_PROPERTY_BILLING_ADDRESS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_BLOCKED_PAYMENT_METHODS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_CAPTURE_DELAY_HOURS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_CHANNEL,
  CreateCheckoutSessionRequest.JSON_PROPERTY_COMPANY,
  CreateCheckoutSessionRequest.JSON_PROPERTY_COUNTRY_CODE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_DATE_OF_BIRTH,
  CreateCheckoutSessionRequest.JSON_PROPERTY_DELIVER_AT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_DELIVERY_ADDRESS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_ENABLE_ONE_CLICK,
  CreateCheckoutSessionRequest.JSON_PROPERTY_ENABLE_PAY_OUT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_ENABLE_RECURRING,
  CreateCheckoutSessionRequest.JSON_PROPERTY_EXPIRES_AT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_FUND_ORIGIN,
  CreateCheckoutSessionRequest.JSON_PROPERTY_FUND_RECIPIENT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_INSTALLMENT_OPTIONS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_LINE_ITEMS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_MANDATE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_MCC,
  CreateCheckoutSessionRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_MERCHANT_ORDER_REFERENCE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_METADATA,
  CreateCheckoutSessionRequest.JSON_PROPERTY_MODE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_MPI_DATA,
  CreateCheckoutSessionRequest.JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC,
  CreateCheckoutSessionRequest.JSON_PROPERTY_RECURRING_EXPIRY,
  CreateCheckoutSessionRequest.JSON_PROPERTY_RECURRING_FREQUENCY,
  CreateCheckoutSessionRequest.JSON_PROPERTY_RECURRING_PROCESSING_MODEL,
  CreateCheckoutSessionRequest.JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD,
  CreateCheckoutSessionRequest.JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD,
  CreateCheckoutSessionRequest.JSON_PROPERTY_REFERENCE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_RETURN_URL,
  CreateCheckoutSessionRequest.JSON_PROPERTY_RISK_DATA,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_EMAIL,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_I_P,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_INTERACTION,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_LOCALE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_NAME,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_REFERENCE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOPPER_STATEMENT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SOCIAL_SECURITY_NUMBER,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES,
  CreateCheckoutSessionRequest.JSON_PROPERTY_SPLITS,
  CreateCheckoutSessionRequest.JSON_PROPERTY_STORE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_STORE_FILTRATION_MODE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_STORE_PAYMENT_METHOD,
  CreateCheckoutSessionRequest.JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE,
  CreateCheckoutSessionRequest.JSON_PROPERTY_TELEPHONE_NUMBER,
  CreateCheckoutSessionRequest.JSON_PROPERTY_THEME_ID,
  CreateCheckoutSessionRequest.JSON_PROPERTY_THREE_D_S2_REQUEST_DATA,
  CreateCheckoutSessionRequest.JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY,
  CreateCheckoutSessionRequest.JSON_PROPERTY_TRUSTED_SHOPPER
})
public class CreateCheckoutSessionRequest {
  public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
  private AccountInfo accountInfo;

  public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
  private Amount additionalAmount;

  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData;

  public static final String JSON_PROPERTY_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
  private List<String> allowedPaymentMethods;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_AUTHENTICATION_DATA = "authenticationData";
  private AuthenticationData authenticationData;

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private BillingAddress billingAddress;

  public static final String JSON_PROPERTY_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
  private List<String> blockedPaymentMethods;

  public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
  private Integer captureDelayHours;

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out
   * payment methods that are only available on specific platforms. If this value is not set, then
   * we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;. Possible values:
   * * **iOS** * **Android** * **Web**
   */
  public enum ChannelEnum {
    IOS(String.valueOf("iOS")),

    ANDROID(String.valueOf("Android")),

    WEB(String.valueOf("Web"));

    private static final Logger LOG = Logger.getLogger(ChannelEnum.class.getName());

    private String value;

    ChannelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelEnum fromValue(String value) {
      for (ChannelEnum b : ChannelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ChannelEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ChannelEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_CHANNEL = "channel";
  private ChannelEnum channel;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private Company company;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private LocalDate dateOfBirth;

  public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
  private OffsetDateTime deliverAt;

  public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
  private DeliveryAddress deliveryAddress;

  public static final String JSON_PROPERTY_ENABLE_ONE_CLICK = "enableOneClick";
  private Boolean enableOneClick;

  public static final String JSON_PROPERTY_ENABLE_PAY_OUT = "enablePayOut";
  private Boolean enablePayOut;

  public static final String JSON_PROPERTY_ENABLE_RECURRING = "enableRecurring";
  private Boolean enableRecurring;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_FUND_ORIGIN = "fundOrigin";
  private FundOrigin fundOrigin;

  public static final String JSON_PROPERTY_FUND_RECIPIENT = "fundRecipient";
  private FundRecipient fundRecipient;

  public static final String JSON_PROPERTY_INSTALLMENT_OPTIONS = "installmentOptions";
  private Map<String, CheckoutSessionInstallmentOption> installmentOptions;

  public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
  private List<LineItem> lineItems;

  public static final String JSON_PROPERTY_MANDATE = "mandate";
  private Mandate mandate;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  private String merchantOrderReference;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata;

  /**
   * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in
   * or Components integration * **hosted**: Hosted Checkout integration
   */
  public enum ModeEnum {
    EMBEDDED(String.valueOf("embedded")),

    HOSTED(String.valueOf("hosted"));

    private static final Logger LOG = Logger.getLogger(ModeEnum.class.getName());

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ModeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ModeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode;

  public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
  private ThreeDSecureData mpiData;

  public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
  private PlatformChargebackLogic platformChargebackLogic;

  public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
  private String recurringExpiry;

  public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
  private String recurringFrequency;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details.
   * Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount,
   * which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF)
   * transaction, card details are stored to enable one-click or omnichannel journeys, or simply to
   * streamline the checkout process. Any subscription not following a fixed schedule is also
   * considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled
   * card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or
   * have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   * below a certain amount.
   */
  public enum RecurringProcessingModelEnum {
    CARDONFILE(String.valueOf("CardOnFile")),

    SUBSCRIPTION(String.valueOf("Subscription")),

    UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

    private static final Logger LOG =
        Logger.getLogger(RecurringProcessingModelEnum.class.getName());

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "RecurringProcessingModelEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(RecurringProcessingModelEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
  private String redirectFromIssuerMethod;

  public static final String JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
  private String redirectToIssuerMethod;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
  private String returnUrl;

  public static final String JSON_PROPERTY_RISK_DATA = "riskData";
  private RiskData riskData;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
  private String shopperIP;

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether
   * the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper
   * interaction by default. This field has the following possible values: * &#x60;Ecommerce&#x60; -
   * Online transactions where the cardholder is present (online). For better authorisation rates,
   * we recommend sending the card security code (CSC) along with the request. *
   * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is
   * known to the merchant (returning customer). If the shopper is present (online), you can supply
   * also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and
   * telephone-order transactions where the shopper is in contact with the merchant via email or
   * telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically
   * present to make a payment using a secure payment terminal.
   */
  public enum ShopperInteractionEnum {
    ECOMMERCE(String.valueOf("Ecommerce")),

    CONTAUTH(String.valueOf("ContAuth")),

    MOTO(String.valueOf("Moto")),

    POS(String.valueOf("POS"));

    private static final Logger LOG = Logger.getLogger(ShopperInteractionEnum.class.getName());

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ShopperInteractionEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ShopperInteractionEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private ShopperInteractionEnum shopperInteraction;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
  private Name shopperName;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
  private String shopperStatement;

  public static final String JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT = "showInstallmentAmount";
  private Boolean showInstallmentAmount;

  public static final String JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON =
      "showRemovePaymentMethodButton";
  private Boolean showRemovePaymentMethodButton;

  public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  private String socialSecurityNumber;

  public static final String JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
  private Boolean splitCardFundingSources;

  public static final String JSON_PROPERTY_SPLITS = "splits";
  private List<Split> splits;

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  /**
   * Specifies how payment methods should be filtered based on the &#39;store&#39; parameter: -
   * &#39;exclusive&#39;: Only payment methods belonging to the specified &#39;store&#39; are
   * returned. - &#39;inclusive&#39;: Payment methods from the &#39;store&#39; and those not
   * associated with any other store are returned.
   */
  public enum StoreFiltrationModeEnum {
    EXCLUSIVE(String.valueOf("exclusive")),

    INCLUSIVE(String.valueOf("inclusive")),

    SKIPFILTER(String.valueOf("skipFilter"));

    private static final Logger LOG = Logger.getLogger(StoreFiltrationModeEnum.class.getName());

    private String value;

    StoreFiltrationModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StoreFiltrationModeEnum fromValue(String value) {
      for (StoreFiltrationModeEnum b : StoreFiltrationModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StoreFiltrationModeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StoreFiltrationModeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STORE_FILTRATION_MODE = "storeFiltrationMode";
  private StoreFiltrationModeEnum storeFiltrationMode;

  public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD = "storePaymentMethod";
  private Boolean storePaymentMethod;

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values:
   * * **disabled** – No details will be stored (default). * **askForConsent** – If the
   * &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their
   * payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided,
   * the details will be stored without asking the shopper for consent.
   */
  public enum StorePaymentMethodModeEnum {
    ASKFORCONSENT(String.valueOf("askForConsent")),

    DISABLED(String.valueOf("disabled")),

    ENABLED(String.valueOf("enabled"));

    private static final Logger LOG = Logger.getLogger(StorePaymentMethodModeEnum.class.getName());

    private String value;

    StorePaymentMethodModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StorePaymentMethodModeEnum fromValue(String value) {
      for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StorePaymentMethodModeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StorePaymentMethodModeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
  private StorePaymentMethodModeEnum storePaymentMethodMode;

  public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
  private String telephoneNumber;

  public static final String JSON_PROPERTY_THEME_ID = "themeId";
  private String themeId;

  public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
  private CheckoutSessionThreeDS2RequestData threeDS2RequestData;

  public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY =
      "threeDSAuthenticationOnly";
  @Deprecated // deprecated since Adyen Checkout API v69: Use
  // `authenticationData.authenticationOnly` instead.
  private Boolean threeDSAuthenticationOnly;

  public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
  private Boolean trustedShopper;

  public CreateCheckoutSessionRequest() {}

  /**
   * accountInfo
   *
   * @param accountInfo
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest accountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
    return this;
  }

  /**
   * Get accountInfo
   *
   * @return accountInfo
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccountInfo getAccountInfo() {
    return accountInfo;
  }

  /**
   * accountInfo
   *
   * @param accountInfo
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
  }

  /**
   * additionalAmount
   *
   * @param additionalAmount
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest additionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
    return this;
  }

  /**
   * Get additionalAmount
   *
   * @return additionalAmount
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAdditionalAmount() {
    return additionalAmount;
  }

  /**
   * additionalAmount
   *
   * @param additionalAmount
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
  }

  /**
   * This field contains additional data, which may be required for a particular payment request.
   * The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and
   * value.
   *
   * @param additionalData This field contains additional data, which may be required for a
   *     particular payment request. The &#x60;additionalData&#x60; object consists of entries, each
   *     of which includes the key and value.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public CreateCheckoutSessionRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * This field contains additional data, which may be required for a particular payment request.
   * The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and
   * value.
   *
   * @return additionalData This field contains additional data, which may be required for a
   *     particular payment request. The &#x60;additionalData&#x60; object consists of entries, each
   *     of which includes the key and value.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * This field contains additional data, which may be required for a particular payment request.
   * The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and
   * value.
   *
   * @param additionalData This field contains additional data, which may be required for a
   *     particular payment request. The &#x60;additionalData&#x60; object consists of entries, each
   *     of which includes the key and value.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * List of payment methods to be presented to the shopper. To refer to payment methods, use their
   * [payment method type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   * &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   *
   * @param allowedPaymentMethods List of payment methods to be presented to the shopper. To refer
   *     to payment methods, use their [payment method
   *     type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   *     &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest allowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
    return this;
  }

  public CreateCheckoutSessionRequest addAllowedPaymentMethodsItem(
      String allowedPaymentMethodsItem) {
    if (this.allowedPaymentMethods == null) {
      this.allowedPaymentMethods = new ArrayList<>();
    }
    this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
    return this;
  }

  /**
   * List of payment methods to be presented to the shopper. To refer to payment methods, use their
   * [payment method type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   * &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   *
   * @return allowedPaymentMethods List of payment methods to be presented to the shopper. To refer
   *     to payment methods, use their [payment method
   *     type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   *     &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAllowedPaymentMethods() {
    return allowedPaymentMethods;
  }

  /**
   * List of payment methods to be presented to the shopper. To refer to payment methods, use their
   * [payment method type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   * &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   *
   * @param allowedPaymentMethods List of payment methods to be presented to the shopper. To refer
   *     to payment methods, use their [payment method
   *     type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   *     &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
  }

  /**
   * amount
   *
   * @param amount
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * applicationInfo
   *
   * @param applicationInfo
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

  /**
   * Get applicationInfo
   *
   * @return applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }

  /**
   * applicationInfo
   *
   * @param applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }

  /**
   * authenticationData
   *
   * @param authenticationData
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest authenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
    return this;
  }

  /**
   * Get authenticationData
   *
   * @return authenticationData
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AuthenticationData getAuthenticationData() {
    return authenticationData;
  }

  /**
   * authenticationData
   *
   * @param authenticationData
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
  }

  /**
   * billingAddress
   *
   * @param billingAddress
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest billingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

  /**
   * Get billingAddress
   *
   * @return billingAddress
   */
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BillingAddress getBillingAddress() {
    return billingAddress;
  }

  /**
   * billingAddress
   *
   * @param billingAddress
   */
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
  }

  /**
   * List of payment methods to be hidden from the shopper. To refer to payment methods, use their
   * [payment method type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   * &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   *
   * @param blockedPaymentMethods List of payment methods to be hidden from the shopper. To refer to
   *     payment methods, use their [payment method
   *     type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   *     &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest blockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
    return this;
  }

  public CreateCheckoutSessionRequest addBlockedPaymentMethodsItem(
      String blockedPaymentMethodsItem) {
    if (this.blockedPaymentMethods == null) {
      this.blockedPaymentMethods = new ArrayList<>();
    }
    this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
    return this;
  }

  /**
   * List of payment methods to be hidden from the shopper. To refer to payment methods, use their
   * [payment method type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   * &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   *
   * @return blockedPaymentMethods List of payment methods to be hidden from the shopper. To refer
   *     to payment methods, use their [payment method
   *     type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   *     &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   */
  @JsonProperty(JSON_PROPERTY_BLOCKED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getBlockedPaymentMethods() {
    return blockedPaymentMethods;
  }

  /**
   * List of payment methods to be hidden from the shopper. To refer to payment methods, use their
   * [payment method type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   * &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   *
   * @param blockedPaymentMethods List of payment methods to be hidden from the shopper. To refer to
   *     payment methods, use their [payment method
   *     type](https://docs.adyen.com/payment-methods/payment-method-types). Example:
   *     &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;applepay\&quot;]&#x60;
   */
  @JsonProperty(JSON_PROPERTY_BLOCKED_PAYMENT_METHODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
  }

  /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   *
   * @param captureDelayHours The delay between the authorisation and scheduled auto-capture,
   *     specified in hours.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest captureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
    return this;
  }

  /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   *
   * @return captureDelayHours The delay between the authorisation and scheduled auto-capture,
   *     specified in hours.
   */
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }

  /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   *
   * @param captureDelayHours The delay between the authorisation and scheduled auto-capture,
   *     specified in hours.
   */
  @JsonProperty(JSON_PROPERTY_CAPTURE_DELAY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out
   * payment methods that are only available on specific platforms. If this value is not set, then
   * we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;. Possible values:
   * * **iOS** * **Android** * **Web**
   *
   * @param channel The platform where a payment transaction takes place. This field is optional for
   *     filtering out payment methods that are only available on specific platforms. If this value
   *     is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or
   *     &#x60;token&#x60;. Possible values: * **iOS** * **Android** * **Web**
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest channel(ChannelEnum channel) {
    this.channel = channel;
    return this;
  }

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out
   * payment methods that are only available on specific platforms. If this value is not set, then
   * we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;. Possible values:
   * * **iOS** * **Android** * **Web**
   *
   * @return channel The platform where a payment transaction takes place. This field is optional
   *     for filtering out payment methods that are only available on specific platforms. If this
   *     value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or
   *     &#x60;token&#x60;. Possible values: * **iOS** * **Android** * **Web**
   */
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ChannelEnum getChannel() {
    return channel;
  }

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out
   * payment methods that are only available on specific platforms. If this value is not set, then
   * we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;. Possible values:
   * * **iOS** * **Android** * **Web**
   *
   * @param channel The platform where a payment transaction takes place. This field is optional for
   *     filtering out payment methods that are only available on specific platforms. If this value
   *     is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or
   *     &#x60;token&#x60;. Possible values: * **iOS** * **Android** * **Web**
   */
  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannel(ChannelEnum channel) {
    this.channel = channel;
  }

  /**
   * company
   *
   * @param company
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest company(Company company) {
    this.company = company;
    return this;
  }

  /**
   * Get company
   *
   * @return company
   */
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Company getCompany() {
    return company;
  }

  /**
   * company
   *
   * @param company
   */
  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompany(Company company) {
    this.company = company;
  }

  /**
   * The shopper&#39;s two-letter country code.
   *
   * @param countryCode The shopper&#39;s two-letter country code.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * The shopper&#39;s two-letter country code.
   *
   * @return countryCode The shopper&#39;s two-letter country code.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCountryCode() {
    return countryCode;
  }

  /**
   * The shopper&#39;s two-letter country code.
   *
   * @param countryCode The shopper&#39;s two-letter country code.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  /**
   * The shopper&#39;s date of birth. Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime):
   * YYYY-MM-DD
   *
   * @param dateOfBirth The shopper&#39;s date of birth. Format
   *     [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * The shopper&#39;s date of birth. Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime):
   * YYYY-MM-DD
   *
   * @return dateOfBirth The shopper&#39;s date of birth. Format
   *     [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  /**
   * The shopper&#39;s date of birth. Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime):
   * YYYY-MM-DD
   *
   * @param dateOfBirth The shopper&#39;s date of birth. Format
   *     [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   */
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  /**
   * The date and time when the purchased goods should be delivered. [ISO
   * 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @param deliverAt The date and time when the purchased goods should be delivered. [ISO
   *     8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example,
   *     **2020-12-18T10:15:30+01:00**.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest deliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
    return this;
  }

  /**
   * The date and time when the purchased goods should be delivered. [ISO
   * 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @return deliverAt The date and time when the purchased goods should be delivered. [ISO
   *     8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example,
   *     **2020-12-18T10:15:30+01:00**.
   */
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDeliverAt() {
    return deliverAt;
  }

  /**
   * The date and time when the purchased goods should be delivered. [ISO
   * 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example,
   * **2020-12-18T10:15:30+01:00**.
   *
   * @param deliverAt The date and time when the purchased goods should be delivered. [ISO
   *     8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example,
   *     **2020-12-18T10:15:30+01:00**.
   */
  @JsonProperty(JSON_PROPERTY_DELIVER_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
  }

  /**
   * deliveryAddress
   *
   * @param deliveryAddress
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest deliveryAddress(DeliveryAddress deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

  /**
   * Get deliveryAddress
   *
   * @return deliveryAddress
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DeliveryAddress getDeliveryAddress() {
    return deliveryAddress;
  }

  /**
   * deliveryAddress
   *
   * @param deliveryAddress
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the
   * payment details should be stored for future [one-click
   * payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   *
   * @param enableOneClick When true and &#x60;shopperReference&#x60; is provided, the shopper will
   *     be asked if the payment details should be stored for future [one-click
   *     payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest enableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
    return this;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the
   * payment details should be stored for future [one-click
   * payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   *
   * @return enableOneClick When true and &#x60;shopperReference&#x60; is provided, the shopper will
   *     be asked if the payment details should be stored for future [one-click
   *     payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_ONE_CLICK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnableOneClick() {
    return enableOneClick;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the
   * payment details should be stored for future [one-click
   * payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   *
   * @param enableOneClick When true and &#x60;shopperReference&#x60; is provided, the shopper will
   *     be asked if the payment details should be stored for future [one-click
   *     payments](https://docs.adyen.com/get-started-with-adyen/payment-glossary/#one-click-payments-definition).
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_ONE_CLICK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized
   * for payouts.
   *
   * @param enablePayOut When true and &#x60;shopperReference&#x60; is provided, the payment details
   *     will be tokenized for payouts.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest enablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
    return this;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized
   * for payouts.
   *
   * @return enablePayOut When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be tokenized for payouts.
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnablePayOut() {
    return enablePayOut;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized
   * for payouts.
   *
   * @param enablePayOut When true and &#x60;shopperReference&#x60; is provided, the payment details
   *     will be tokenized for payouts.
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for
   * [recurring
   * payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where
   * the shopper is not present, such as subscription or automatic top-up payments.
   *
   * @param enableRecurring When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be stored for [recurring
   *     payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types)
   *     where the shopper is not present, such as subscription or automatic top-up payments.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest enableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
    return this;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for
   * [recurring
   * payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where
   * the shopper is not present, such as subscription or automatic top-up payments.
   *
   * @return enableRecurring When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be stored for [recurring
   *     payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types)
   *     where the shopper is not present, such as subscription or automatic top-up payments.
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnableRecurring() {
    return enableRecurring;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for
   * [recurring
   * payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types) where
   * the shopper is not present, such as subscription or automatic top-up payments.
   *
   * @param enableRecurring When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be stored for [recurring
   *     payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types)
   *     where the shopper is not present, such as subscription or automatic top-up payments.
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
  }

  /**
   * The date the session expires in
   * [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified,
   * the expiry date is set to 1 hour after session creation. You cannot set the session expiry to
   * more than 24 hours after session creation.
   *
   * @param expiresAt The date the session expires in
   *     [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not
   *     specified, the expiry date is set to 1 hour after session creation. You cannot set the
   *     session expiry to more than 24 hours after session creation.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest expiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * The date the session expires in
   * [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified,
   * the expiry date is set to 1 hour after session creation. You cannot set the session expiry to
   * more than 24 hours after session creation.
   *
   * @return expiresAt The date the session expires in
   *     [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not
   *     specified, the expiry date is set to 1 hour after session creation. You cannot set the
   *     session expiry to more than 24 hours after session creation.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }

  /**
   * The date the session expires in
   * [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified,
   * the expiry date is set to 1 hour after session creation. You cannot set the session expiry to
   * more than 24 hours after session creation.
   *
   * @param expiresAt The date the session expires in
   *     [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not
   *     specified, the expiry date is set to 1 hour after session creation. You cannot set the
   *     session expiry to more than 24 hours after session creation.
   */
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }

  /**
   * fundOrigin
   *
   * @param fundOrigin
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest fundOrigin(FundOrigin fundOrigin) {
    this.fundOrigin = fundOrigin;
    return this;
  }

  /**
   * Get fundOrigin
   *
   * @return fundOrigin
   */
  @JsonProperty(JSON_PROPERTY_FUND_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FundOrigin getFundOrigin() {
    return fundOrigin;
  }

  /**
   * fundOrigin
   *
   * @param fundOrigin
   */
  @JsonProperty(JSON_PROPERTY_FUND_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundOrigin(FundOrigin fundOrigin) {
    this.fundOrigin = fundOrigin;
  }

  /**
   * fundRecipient
   *
   * @param fundRecipient
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest fundRecipient(FundRecipient fundRecipient) {
    this.fundRecipient = fundRecipient;
    return this;
  }

  /**
   * Get fundRecipient
   *
   * @return fundRecipient
   */
  @JsonProperty(JSON_PROPERTY_FUND_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FundRecipient getFundRecipient() {
    return fundRecipient;
  }

  /**
   * fundRecipient
   *
   * @param fundRecipient
   */
  @JsonProperty(JSON_PROPERTY_FUND_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundRecipient(FundRecipient fundRecipient) {
    this.fundRecipient = fundRecipient;
  }

  /**
   * A set of key-value pairs that specifies the installment options available per payment method.
   * The key must be a payment method name in lowercase. For example, **card** to specify
   * installment options for all cards, or **visa** or **mc**. The value must be an object
   * containing the installment options.
   *
   * @param installmentOptions A set of key-value pairs that specifies the installment options
   *     available per payment method. The key must be a payment method name in lowercase. For
   *     example, **card** to specify installment options for all cards, or **visa** or **mc**. The
   *     value must be an object containing the installment options.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest installmentOptions(
      Map<String, CheckoutSessionInstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
    return this;
  }

  public CreateCheckoutSessionRequest putInstallmentOptionsItem(
      String key, CheckoutSessionInstallmentOption installmentOptionsItem) {
    if (this.installmentOptions == null) {
      this.installmentOptions = new HashMap<>();
    }
    this.installmentOptions.put(key, installmentOptionsItem);
    return this;
  }

  /**
   * A set of key-value pairs that specifies the installment options available per payment method.
   * The key must be a payment method name in lowercase. For example, **card** to specify
   * installment options for all cards, or **visa** or **mc**. The value must be an object
   * containing the installment options.
   *
   * @return installmentOptions A set of key-value pairs that specifies the installment options
   *     available per payment method. The key must be a payment method name in lowercase. For
   *     example, **card** to specify installment options for all cards, or **visa** or **mc**. The
   *     value must be an object containing the installment options.
   */
  @JsonProperty(JSON_PROPERTY_INSTALLMENT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, CheckoutSessionInstallmentOption> getInstallmentOptions() {
    return installmentOptions;
  }

  /**
   * A set of key-value pairs that specifies the installment options available per payment method.
   * The key must be a payment method name in lowercase. For example, **card** to specify
   * installment options for all cards, or **visa** or **mc**. The value must be an object
   * containing the installment options.
   *
   * @param installmentOptions A set of key-value pairs that specifies the installment options
   *     available per payment method. The key must be a payment method name in lowercase. For
   *     example, **card** to specify installment options for all cards, or **visa** or **mc**. The
   *     value must be an object containing the installment options.
   */
  @JsonProperty(JSON_PROPERTY_INSTALLMENT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallmentOptions(
      Map<String, CheckoutSessionInstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
  }

  /**
   * Price and product information about the purchased items, to be included on the invoice sent to
   * the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna,
   * Ratepay, Riverty, and Zip.
   *
   * @param lineItems Price and product information about the purchased items, to be included on the
   *     invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay,
   *     Clearpay, Klarna, Ratepay, Riverty, and Zip.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  public CreateCheckoutSessionRequest addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

  /**
   * Price and product information about the purchased items, to be included on the invoice sent to
   * the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna,
   * Ratepay, Riverty, and Zip.
   *
   * @return lineItems Price and product information about the purchased items, to be included on
   *     the invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm,
   *     Afterpay, Clearpay, Klarna, Ratepay, Riverty, and Zip.
   */
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<LineItem> getLineItems() {
    return lineItems;
  }

  /**
   * Price and product information about the purchased items, to be included on the invoice sent to
   * the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna,
   * Ratepay, Riverty, and Zip.
   *
   * @param lineItems Price and product information about the purchased items, to be included on the
   *     invoice sent to the shopper. &gt; This field is required for 3x 4x Oney, Affirm, Afterpay,
   *     Clearpay, Klarna, Ratepay, Riverty, and Zip.
   */
  @JsonProperty(JSON_PROPERTY_LINE_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * mandate
   *
   * @param mandate
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest mandate(Mandate mandate) {
    this.mandate = mandate;
    return this;
  }

  /**
   * Get mandate
   *
   * @return mandate
   */
  @JsonProperty(JSON_PROPERTY_MANDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Mandate getMandate() {
    return mandate;
  }

  /**
   * mandate
   *
   * @param mandate
   */
  @JsonProperty(JSON_PROPERTY_MANDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMandate(Mandate mandate) {
    this.mandate = mandate;
  }

  /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a
   * four-digit number, which relates to a particular market segment. This code reflects the
   * predominant activity that is conducted by the merchant.
   *
   * @param mcc The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code)
   *     (MCC) is a four-digit number, which relates to a particular market segment. This code
   *     reflects the predominant activity that is conducted by the merchant.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

  /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a
   * four-digit number, which relates to a particular market segment. This code reflects the
   * predominant activity that is conducted by the merchant.
   *
   * @return mcc The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code)
   *     (MCC) is a four-digit number, which relates to a particular market segment. This code
   *     reflects the predominant activity that is conducted by the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMcc() {
    return mcc;
  }

  /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a
   * four-digit number, which relates to a particular market segment. This code reflects the
   * predominant activity that is conducted by the merchant.
   *
   * @param mcc The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code)
   *     (MCC) is a four-digit number, which relates to a particular market segment. This code
   *     reflects the predominant activity that is conducted by the merchant.
   */
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount The merchant account identifier, with which you want to process the
   *     transaction.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @return merchantAccount The merchant account identifier, with which you want to process the
   *     transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account identifier, with which you want to process the transaction.
   *
   * @param merchantAccount The merchant account identifier, with which you want to process the
   *     transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e.
   * order auth-rate). The reference should be unique per billing cycle. The same merchant order
   * reference should never be reused after the first authorised attempt. If used, this field should
   * be supplied for all incoming authorisations. &gt; We strongly recommend you send the
   * &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when
   * authorisation retries take place. In addition, we recommend you provide
   * &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and
   * &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   *
   * @param merchantOrderReference This reference allows linking multiple transactions to each other
   *     for reporting purposes (i.e. order auth-rate). The reference should be unique per billing
   *     cycle. The same merchant order reference should never be reused after the first authorised
   *     attempt. If used, this field should be supplied for all incoming authorisations. &gt; We
   *     strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from
   *     linking payment requests when authorisation retries take place. In addition, we recommend
   *     you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and
   *     &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest merchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

  /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e.
   * order auth-rate). The reference should be unique per billing cycle. The same merchant order
   * reference should never be reused after the first authorised attempt. If used, this field should
   * be supplied for all incoming authorisations. &gt; We strongly recommend you send the
   * &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when
   * authorisation retries take place. In addition, we recommend you provide
   * &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and
   * &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   *
   * @return merchantOrderReference This reference allows linking multiple transactions to each
   *     other for reporting purposes (i.e. order auth-rate). The reference should be unique per
   *     billing cycle. The same merchant order reference should never be reused after the first
   *     authorised attempt. If used, this field should be supplied for all incoming authorisations.
   *     &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit
   *     from linking payment requests when authorisation retries take place. In addition, we
   *     recommend you provide &#x60;retry.orderAttemptNumber&#x60;,
   *     &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in
   *     &#x60;PaymentRequest.additionalData&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }

  /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e.
   * order auth-rate). The reference should be unique per billing cycle. The same merchant order
   * reference should never be reused after the first authorised attempt. If used, this field should
   * be supplied for all incoming authorisations. &gt; We strongly recommend you send the
   * &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when
   * authorisation retries take place. In addition, we recommend you provide
   * &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and
   * &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   *
   * @param merchantOrderReference This reference allows linking multiple transactions to each other
   *     for reporting purposes (i.e. order auth-rate). The reference should be unique per billing
   *     cycle. The same merchant order reference should never be reused after the first authorised
   *     attempt. If used, this field should be supplied for all incoming authorisations. &gt; We
   *     strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from
   *     linking payment requests when authorisation retries take place. In addition, we recommend
   *     you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and
   *     &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ORDER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }

  /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20
   * key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per
   * value.
   *
   * @param metadata Metadata consists of entries, each of which includes a key and a value. Limits:
   *     * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. * Maximum 80
   *     characters per value.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public CreateCheckoutSessionRequest putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20
   * key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per
   * value.
   *
   * @return metadata Metadata consists of entries, each of which includes a key and a value.
   *     Limits: * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. *
   *     Maximum 80 characters per value.
   */
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getMetadata() {
    return metadata;
  }

  /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20
   * key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per
   * value.
   *
   * @param metadata Metadata consists of entries, each of which includes a key and a value. Limits:
   *     * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. * Maximum 80
   *     characters per value.
   */
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in
   * or Components integration * **hosted**: Hosted Checkout integration
   *
   * @param mode Indicates the type of front end integration. Possible values: * **embedded**
   *     (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest mode(ModeEnum mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in
   * or Components integration * **hosted**: Hosted Checkout integration
   *
   * @return mode Indicates the type of front end integration. Possible values: * **embedded**
   *     (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration
   */
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ModeEnum getMode() {
    return mode;
  }

  /**
   * Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in
   * or Components integration * **hosted**: Hosted Checkout integration
   *
   * @param mode Indicates the type of front end integration. Possible values: * **embedded**
   *     (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration
   */
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }

  /**
   * mpiData
   *
   * @param mpiData
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest mpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
    return this;
  }

  /**
   * Get mpiData
   *
   * @return mpiData
   */
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ThreeDSecureData getMpiData() {
    return mpiData;
  }

  /**
   * mpiData
   *
   * @param mpiData
   */
  @JsonProperty(JSON_PROPERTY_MPI_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
  }

  /**
   * platformChargebackLogic
   *
   * @param platformChargebackLogic
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest platformChargebackLogic(
      PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
    return this;
  }

  /**
   * Get platformChargebackLogic
   *
   * @return platformChargebackLogic
   */
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PlatformChargebackLogic getPlatformChargebackLogic() {
    return platformChargebackLogic;
  }

  /**
   * platformChargebackLogic
   *
   * @param platformChargebackLogic
   */
  @JsonProperty(JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
  }

  /**
   * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
   *
   * @param recurringExpiry Date after which no further authorisations shall be performed. Only for
   *     3D Secure 2.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest recurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
    return this;
  }

  /**
   * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
   *
   * @return recurringExpiry Date after which no further authorisations shall be performed. Only for
   *     3D Secure 2.
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringExpiry() {
    return recurringExpiry;
  }

  /**
   * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
   *
   * @param recurringExpiry Date after which no further authorisations shall be performed. Only for
   *     3D Secure 2.
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
  }

  /**
   * Minimum number of days between authorisations. Only for 3D Secure 2.
   *
   * @param recurringFrequency Minimum number of days between authorisations. Only for 3D Secure 2.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest recurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
    return this;
  }

  /**
   * Minimum number of days between authorisations. Only for 3D Secure 2.
   *
   * @return recurringFrequency Minimum number of days between authorisations. Only for 3D Secure 2.
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringFrequency() {
    return recurringFrequency;
  }

  /**
   * Minimum number of days between authorisations. Only for 3D Secure 2.
   *
   * @param recurringFrequency Minimum number of days between authorisations. Only for 3D Secure 2.
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details.
   * Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount,
   * which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF)
   * transaction, card details are stored to enable one-click or omnichannel journeys, or simply to
   * streamline the checkout process. Any subscription not following a fixed schedule is also
   * considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled
   * card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or
   * have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   * below a certain amount.
   *
   * @param recurringProcessingModel Defines a recurring payment type. Required when creating a
   *     token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction
   *     for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; –
   *     With a card-on-file (CoF) transaction, card details are stored to enable one-click or
   *     omnichannel journeys, or simply to streamline the checkout process. Any subscription not
   *     following a fixed schedule is also considered a card-on-file transaction. *
   *     &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a
   *     transaction that occurs on a non-fixed schedule and/or have variable amounts. For example,
   *     automatic top-ups when a cardholder&#39;s balance drops below a certain amount.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest recurringProcessingModel(
      RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details.
   * Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount,
   * which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF)
   * transaction, card details are stored to enable one-click or omnichannel journeys, or simply to
   * streamline the checkout process. Any subscription not following a fixed schedule is also
   * considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled
   * card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or
   * have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   * below a certain amount.
   *
   * @return recurringProcessingModel Defines a recurring payment type. Required when creating a
   *     token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction
   *     for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; –
   *     With a card-on-file (CoF) transaction, card details are stored to enable one-click or
   *     omnichannel journeys, or simply to streamline the checkout process. Any subscription not
   *     following a fixed schedule is also considered a card-on-file transaction. *
   *     &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a
   *     transaction that occurs on a non-fixed schedule and/or have variable amounts. For example,
   *     automatic top-ups when a cardholder&#39;s balance drops below a certain amount.
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details.
   * Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount,
   * which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF)
   * transaction, card details are stored to enable one-click or omnichannel journeys, or simply to
   * streamline the checkout process. Any subscription not following a fixed schedule is also
   * considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled
   * card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or
   * have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops
   * below a certain amount.
   *
   * @param recurringProcessingModel Defines a recurring payment type. Required when creating a
   *     token to store payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction
   *     for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; –
   *     With a card-on-file (CoF) transaction, card details are stored to enable one-click or
   *     omnichannel journeys, or simply to streamline the checkout process. Any subscription not
   *     following a fixed schedule is also considered a card-on-file transaction. *
   *     &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a
   *     transaction that occurs on a non-fixed schedule and/or have variable amounts. For example,
   *     automatic top-ups when a cardholder&#39;s balance drops below a certain amount.
   */
  @JsonProperty(JSON_PROPERTY_RECURRING_PROCESSING_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }

  /**
   * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
   *
   * @param redirectFromIssuerMethod Specifies the redirect method (GET or POST) when redirecting
   *     back from the issuer.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    return this;
  }

  /**
   * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
   *
   * @return redirectFromIssuerMethod Specifies the redirect method (GET or POST) when redirecting
   *     back from the issuer.
   */
  @JsonProperty(JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRedirectFromIssuerMethod() {
    return redirectFromIssuerMethod;
  }

  /**
   * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
   *
   * @param redirectFromIssuerMethod Specifies the redirect method (GET or POST) when redirecting
   *     back from the issuer.
   */
  @JsonProperty(JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
  }

  /**
   * Specifies the redirect method (GET or POST) when redirecting to the issuer.
   *
   * @param redirectToIssuerMethod Specifies the redirect method (GET or POST) when redirecting to
   *     the issuer.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
    return this;
  }

  /**
   * Specifies the redirect method (GET or POST) when redirecting to the issuer.
   *
   * @return redirectToIssuerMethod Specifies the redirect method (GET or POST) when redirecting to
   *     the issuer.
   */
  @JsonProperty(JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRedirectToIssuerMethod() {
    return redirectToIssuerMethod;
  }

  /**
   * Specifies the redirect method (GET or POST) when redirecting to the issuer.
   *
   * @param redirectToIssuerMethod Specifies the redirect method (GET or POST) when redirecting to
   *     the issuer.
   */
  @JsonProperty(JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
  }

  /**
   * The reference to uniquely identify a payment.
   *
   * @param reference The reference to uniquely identify a payment.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * The reference to uniquely identify a payment.
   *
   * @return reference The reference to uniquely identify a payment.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * The reference to uniquely identify a payment.
   *
   * @param reference The reference to uniquely identify a payment.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The URL to return to in case of a redirection. The format depends on the channel. * For web,
   * include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You can also include your own
   * additional query parameters, for example, shopper ID or order reference number. Example:
   * &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the custom
   * URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer
   * documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app).
   * Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on your
   * app. You can configure it with an [intent
   * filter](https://developer.android.com/guide/components/intents-filters). Example:
   * &#x60;my-app://your.package.name&#x60; If the URL to return to includes non-ASCII characters,
   * like spaces or special letters, URL encode the value. We strongly recommend that you use a
   * maximum of 1024 characters. &gt; The URL must not include personally identifiable information
   * (PII), for example name or email address.
   *
   * @param returnUrl The URL to return to in case of a redirection. The format depends on the
   *     channel. * For web, include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You
   *     can also include your own additional query parameters, for example, shopper ID or order
   *     reference number. Example:
   *     &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the
   *     custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple
   *     Developer
   *     documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app).
   *     Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on
   *     your app. You can configure it with an [intent
   *     filter](https://developer.android.com/guide/components/intents-filters). Example:
   *     &#x60;my-app://your.package.name&#x60; If the URL to return to includes non-ASCII
   *     characters, like spaces or special letters, URL encode the value. We strongly recommend
   *     that you use a maximum of 1024 characters. &gt; The URL must not include personally
   *     identifiable information (PII), for example name or email address.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest returnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
    return this;
  }

  /**
   * The URL to return to in case of a redirection. The format depends on the channel. * For web,
   * include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You can also include your own
   * additional query parameters, for example, shopper ID or order reference number. Example:
   * &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the custom
   * URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer
   * documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app).
   * Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on your
   * app. You can configure it with an [intent
   * filter](https://developer.android.com/guide/components/intents-filters). Example:
   * &#x60;my-app://your.package.name&#x60; If the URL to return to includes non-ASCII characters,
   * like spaces or special letters, URL encode the value. We strongly recommend that you use a
   * maximum of 1024 characters. &gt; The URL must not include personally identifiable information
   * (PII), for example name or email address.
   *
   * @return returnUrl The URL to return to in case of a redirection. The format depends on the
   *     channel. * For web, include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You
   *     can also include your own additional query parameters, for example, shopper ID or order
   *     reference number. Example:
   *     &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the
   *     custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple
   *     Developer
   *     documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app).
   *     Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on
   *     your app. You can configure it with an [intent
   *     filter](https://developer.android.com/guide/components/intents-filters). Example:
   *     &#x60;my-app://your.package.name&#x60; If the URL to return to includes non-ASCII
   *     characters, like spaces or special letters, URL encode the value. We strongly recommend
   *     that you use a maximum of 1024 characters. &gt; The URL must not include personally
   *     identifiable information (PII), for example name or email address.
   */
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReturnUrl() {
    return returnUrl;
  }

  /**
   * The URL to return to in case of a redirection. The format depends on the channel. * For web,
   * include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You can also include your own
   * additional query parameters, for example, shopper ID or order reference number. Example:
   * &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the custom
   * URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer
   * documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app).
   * Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on your
   * app. You can configure it with an [intent
   * filter](https://developer.android.com/guide/components/intents-filters). Example:
   * &#x60;my-app://your.package.name&#x60; If the URL to return to includes non-ASCII characters,
   * like spaces or special letters, URL encode the value. We strongly recommend that you use a
   * maximum of 1024 characters. &gt; The URL must not include personally identifiable information
   * (PII), for example name or email address.
   *
   * @param returnUrl The URL to return to in case of a redirection. The format depends on the
   *     channel. * For web, include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You
   *     can also include your own additional query parameters, for example, shopper ID or order
   *     reference number. Example:
   *     &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the
   *     custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple
   *     Developer
   *     documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app).
   *     Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on
   *     your app. You can configure it with an [intent
   *     filter](https://developer.android.com/guide/components/intents-filters). Example:
   *     &#x60;my-app://your.package.name&#x60; If the URL to return to includes non-ASCII
   *     characters, like spaces or special letters, URL encode the value. We strongly recommend
   *     that you use a maximum of 1024 characters. &gt; The URL must not include personally
   *     identifiable information (PII), for example name or email address.
   */
  @JsonProperty(JSON_PROPERTY_RETURN_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }

  /**
   * riskData
   *
   * @param riskData
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest riskData(RiskData riskData) {
    this.riskData = riskData;
    return this;
  }

  /**
   * Get riskData
   *
   * @return riskData
   */
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RiskData getRiskData() {
    return riskData;
  }

  /**
   * riskData
   *
   * @param riskData
   */
  @JsonProperty(JSON_PROPERTY_RISK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskData(RiskData riskData) {
    this.riskData = riskData;
  }

  /**
   * The shopper&#39;s email address.
   *
   * @param shopperEmail The shopper&#39;s email address.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

  /**
   * The shopper&#39;s email address.
   *
   * @return shopperEmail The shopper&#39;s email address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperEmail() {
    return shopperEmail;
  }

  /**
   * The shopper&#39;s email address.
   *
   * @param shopperEmail The shopper&#39;s email address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }

  /**
   * The shopper&#39;s IP address. We recommend that you provide this data, as it is used in a
   * number of risk checks (for instance, number of payment attempts or location-based checks).&gt;
   * Required for Visa and JCB transactions that require 3D Secure 2 authentication for all web and
   * mobile integrations, if you did not include the &#x60;shopperEmail&#x60;. For native mobile
   * integrations, the field is required to support cases where authentication is routed to the
   * redirect flow. This field is also mandatory for some merchants depending on your business
   * model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param shopperIP The shopper&#39;s IP address. We recommend that you provide this data, as it
   *     is used in a number of risk checks (for instance, number of payment attempts or
   *     location-based checks).&gt; Required for Visa and JCB transactions that require 3D Secure 2
   *     authentication for all web and mobile integrations, if you did not include the
   *     &#x60;shopperEmail&#x60;. For native mobile integrations, the field is required to support
   *     cases where authentication is routed to the redirect flow. This field is also mandatory for
   *     some merchants depending on your business model. For more information, [contact
   *     Support](https://www.adyen.help/hc/en-us/requests/new).
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
    return this;
  }

  /**
   * The shopper&#39;s IP address. We recommend that you provide this data, as it is used in a
   * number of risk checks (for instance, number of payment attempts or location-based checks).&gt;
   * Required for Visa and JCB transactions that require 3D Secure 2 authentication for all web and
   * mobile integrations, if you did not include the &#x60;shopperEmail&#x60;. For native mobile
   * integrations, the field is required to support cases where authentication is routed to the
   * redirect flow. This field is also mandatory for some merchants depending on your business
   * model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @return shopperIP The shopper&#39;s IP address. We recommend that you provide this data, as it
   *     is used in a number of risk checks (for instance, number of payment attempts or
   *     location-based checks).&gt; Required for Visa and JCB transactions that require 3D Secure 2
   *     authentication for all web and mobile integrations, if you did not include the
   *     &#x60;shopperEmail&#x60;. For native mobile integrations, the field is required to support
   *     cases where authentication is routed to the redirect flow. This field is also mandatory for
   *     some merchants depending on your business model. For more information, [contact
   *     Support](https://www.adyen.help/hc/en-us/requests/new).
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperIP() {
    return shopperIP;
  }

  /**
   * The shopper&#39;s IP address. We recommend that you provide this data, as it is used in a
   * number of risk checks (for instance, number of payment attempts or location-based checks).&gt;
   * Required for Visa and JCB transactions that require 3D Secure 2 authentication for all web and
   * mobile integrations, if you did not include the &#x60;shopperEmail&#x60;. For native mobile
   * integrations, the field is required to support cases where authentication is routed to the
   * redirect flow. This field is also mandatory for some merchants depending on your business
   * model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   *
   * @param shopperIP The shopper&#39;s IP address. We recommend that you provide this data, as it
   *     is used in a number of risk checks (for instance, number of payment attempts or
   *     location-based checks).&gt; Required for Visa and JCB transactions that require 3D Secure 2
   *     authentication for all web and mobile integrations, if you did not include the
   *     &#x60;shopperEmail&#x60;. For native mobile integrations, the field is required to support
   *     cases where authentication is routed to the redirect flow. This field is also mandatory for
   *     some merchants depending on your business model. For more information, [contact
   *     Support](https://www.adyen.help/hc/en-us/requests/new).
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
  }

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether
   * the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper
   * interaction by default. This field has the following possible values: * &#x60;Ecommerce&#x60; -
   * Online transactions where the cardholder is present (online). For better authorisation rates,
   * we recommend sending the card security code (CSC) along with the request. *
   * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is
   * known to the merchant (returning customer). If the shopper is present (online), you can supply
   * also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and
   * telephone-order transactions where the shopper is in contact with the merchant via email or
   * telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically
   * present to make a payment using a secure payment terminal.
   *
   * @param shopperInteraction Specifies the sales channel, through which the shopper gives their
   *     card details, and whether the shopper is a returning customer. For the web service API,
   *     Adyen assumes Ecommerce shopper interaction by default. This field has the following
   *     possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is
   *     present (online). For better authorisation rates, we recommend sending the card security
   *     code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or
   *     subscription transactions, where the cardholder is known to the merchant (returning
   *     customer). If the shopper is present (online), you can supply also the CSC to improve
   *     authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order
   *     transactions where the shopper is in contact with the merchant via email or telephone. *
   *     &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to
   *     make a payment using a secure payment terminal.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperInteraction(
      ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether
   * the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper
   * interaction by default. This field has the following possible values: * &#x60;Ecommerce&#x60; -
   * Online transactions where the cardholder is present (online). For better authorisation rates,
   * we recommend sending the card security code (CSC) along with the request. *
   * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is
   * known to the merchant (returning customer). If the shopper is present (online), you can supply
   * also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and
   * telephone-order transactions where the shopper is in contact with the merchant via email or
   * telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically
   * present to make a payment using a secure payment terminal.
   *
   * @return shopperInteraction Specifies the sales channel, through which the shopper gives their
   *     card details, and whether the shopper is a returning customer. For the web service API,
   *     Adyen assumes Ecommerce shopper interaction by default. This field has the following
   *     possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is
   *     present (online). For better authorisation rates, we recommend sending the card security
   *     code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or
   *     subscription transactions, where the cardholder is known to the merchant (returning
   *     customer). If the shopper is present (online), you can supply also the CSC to improve
   *     authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order
   *     transactions where the shopper is in contact with the merchant via email or telephone. *
   *     &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to
   *     make a payment using a secure payment terminal.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether
   * the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper
   * interaction by default. This field has the following possible values: * &#x60;Ecommerce&#x60; -
   * Online transactions where the cardholder is present (online). For better authorisation rates,
   * we recommend sending the card security code (CSC) along with the request. *
   * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is
   * known to the merchant (returning customer). If the shopper is present (online), you can supply
   * also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and
   * telephone-order transactions where the shopper is in contact with the merchant via email or
   * telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically
   * present to make a payment using a secure payment terminal.
   *
   * @param shopperInteraction Specifies the sales channel, through which the shopper gives their
   *     card details, and whether the shopper is a returning customer. For the web service API,
   *     Adyen assumes Ecommerce shopper interaction by default. This field has the following
   *     possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is
   *     present (online). For better authorisation rates, we recommend sending the card security
   *     code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or
   *     subscription transactions, where the cardholder is known to the merchant (returning
   *     customer). If the shopper is present (online), you can supply also the CSC to improve
   *     authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order
   *     transactions where the shopper is in contact with the merchant via email or telephone. *
   *     &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to
   *     make a payment using a secure payment terminal.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }

  /**
   * The combination of a language code and a country code to specify the language to be used in the
   * payment.
   *
   * @param shopperLocale The combination of a language code and a country code to specify the
   *     language to be used in the payment.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

  /**
   * The combination of a language code and a country code to specify the language to be used in the
   * payment.
   *
   * @return shopperLocale The combination of a language code and a country code to specify the
   *     language to be used in the payment.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperLocale() {
    return shopperLocale;
  }

  /**
   * The combination of a language code and a country code to specify the language to be used in the
   * payment.
   *
   * @param shopperLocale The combination of a language code and a country code to specify the
   *     language to be used in the payment.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }

  /**
   * shopperName
   *
   * @param shopperName
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperName(Name shopperName) {
    this.shopperName = shopperName;
    return this;
  }

  /**
   * Get shopperName
   *
   * @return shopperName
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Name getShopperName() {
    return shopperName;
  }

  /**
   * shopperName
   *
   * @param shopperName
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. The value
   * is case-sensitive and must be at least three characters. &gt; Your reference must not include
   * personally identifiable information (PII) such as name or email address.
   *
   * @param shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. The value is case-sensitive and must be at least three characters. &gt; Your
   *     reference must not include personally identifiable information (PII) such as name or email
   *     address.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. The value
   * is case-sensitive and must be at least three characters. &gt; Your reference must not include
   * personally identifiable information (PII) such as name or email address.
   *
   * @return shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. The value is case-sensitive and must be at least three characters. &gt; Your
   *     reference must not include personally identifiable information (PII) such as name or email
   *     address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. The value
   * is case-sensitive and must be at least three characters. &gt; Your reference must not include
   * personally identifiable information (PII) such as name or email address.
   *
   * @param shopperReference Your reference to uniquely identify this shopper, for example user ID
   *     or account ID. The value is case-sensitive and must be at least three characters. &gt; Your
   *     reference must not include personally identifiable information (PII) such as name or email
   *     address.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * The text to be shown on the shopper&#39;s bank statement. We recommend sending a maximum of 22
   * characters, otherwise banks might truncate the string. Allowed characters: **a-z**, **A-Z**,
   * **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   *
   * @param shopperStatement The text to be shown on the shopper&#39;s bank statement. We recommend
   *     sending a maximum of 22 characters, otherwise banks might truncate the string. Allowed
   *     characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + *
   *     /_**.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest shopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
    return this;
  }

  /**
   * The text to be shown on the shopper&#39;s bank statement. We recommend sending a maximum of 22
   * characters, otherwise banks might truncate the string. Allowed characters: **a-z**, **A-Z**,
   * **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   *
   * @return shopperStatement The text to be shown on the shopper&#39;s bank statement. We recommend
   *     sending a maximum of 22 characters, otherwise banks might truncate the string. Allowed
   *     characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + *
   *     /_**.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperStatement() {
    return shopperStatement;
  }

  /**
   * The text to be shown on the shopper&#39;s bank statement. We recommend sending a maximum of 22
   * characters, otherwise banks might truncate the string. Allowed characters: **a-z**, **A-Z**,
   * **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   *
   * @param shopperStatement The text to be shown on the shopper&#39;s bank statement. We recommend
   *     sending a maximum of 22 characters, otherwise banks might truncate the string. Allowed
   *     characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + *
   *     /_**.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_STATEMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }

  /**
   * Set to true to show the payment amount per installment.
   *
   * @param showInstallmentAmount Set to true to show the payment amount per installment.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest showInstallmentAmount(Boolean showInstallmentAmount) {
    this.showInstallmentAmount = showInstallmentAmount;
    return this;
  }

  /**
   * Set to true to show the payment amount per installment.
   *
   * @return showInstallmentAmount Set to true to show the payment amount per installment.
   */
  @JsonProperty(JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getShowInstallmentAmount() {
    return showInstallmentAmount;
  }

  /**
   * Set to true to show the payment amount per installment.
   *
   * @param showInstallmentAmount Set to true to show the payment amount per installment.
   */
  @JsonProperty(JSON_PROPERTY_SHOW_INSTALLMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowInstallmentAmount(Boolean showInstallmentAmount) {
    this.showInstallmentAmount = showInstallmentAmount;
  }

  /**
   * Set to **true** to show a button that lets the shopper remove a stored payment method.
   *
   * @param showRemovePaymentMethodButton Set to **true** to show a button that lets the shopper
   *     remove a stored payment method.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest showRemovePaymentMethodButton(
      Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
    return this;
  }

  /**
   * Set to **true** to show a button that lets the shopper remove a stored payment method.
   *
   * @return showRemovePaymentMethodButton Set to **true** to show a button that lets the shopper
   *     remove a stored payment method.
   */
  @JsonProperty(JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getShowRemovePaymentMethodButton() {
    return showRemovePaymentMethodButton;
  }

  /**
   * Set to **true** to show a button that lets the shopper remove a stored payment method.
   *
   * @param showRemovePaymentMethodButton Set to **true** to show a button that lets the shopper
   *     remove a stored payment method.
   */
  @JsonProperty(JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
  }

  /**
   * The shopper&#39;s social security number.
   *
   * @param socialSecurityNumber The shopper&#39;s social security number.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest socialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

  /**
   * The shopper&#39;s social security number.
   *
   * @return socialSecurityNumber The shopper&#39;s social security number.
   */
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }

  /**
   * The shopper&#39;s social security number.
   *
   * @param socialSecurityNumber The shopper&#39;s social security number.
   */
  @JsonProperty(JSON_PROPERTY_SOCIAL_SECURITY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }

  /**
   * Boolean value indicating whether the card payment method should be split into separate debit
   * and credit options.
   *
   * @param splitCardFundingSources Boolean value indicating whether the card payment method should
   *     be split into separate debit and credit options.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest splitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
    return this;
  }

  /**
   * Boolean value indicating whether the card payment method should be split into separate debit
   * and credit options.
   *
   * @return splitCardFundingSources Boolean value indicating whether the card payment method should
   *     be split into separate debit and credit options.
   */
  @JsonProperty(JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getSplitCardFundingSources() {
    return splitCardFundingSources;
  }

  /**
   * Boolean value indicating whether the card payment method should be split into separate debit
   * and credit options.
   *
   * @param splitCardFundingSources Boolean value indicating whether the card payment method should
   *     be split into separate debit and credit options.
   */
  @JsonProperty(JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
  }

  /**
   * An array of objects specifying how to split a payment when using [Adyen for
   * Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information),
   * [Classic Platforms
   * integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information),
   * or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   *
   * @param splits An array of objects specifying how to split a payment when using [Adyen for
   *     Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information),
   *     [Classic Platforms
   *     integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information),
   *     or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest splits(List<Split> splits) {
    this.splits = splits;
    return this;
  }

  public CreateCheckoutSessionRequest addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

  /**
   * An array of objects specifying how to split a payment when using [Adyen for
   * Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information),
   * [Classic Platforms
   * integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information),
   * or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   *
   * @return splits An array of objects specifying how to split a payment when using [Adyen for
   *     Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information),
   *     [Classic Platforms
   *     integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information),
   *     or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   */
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Split> getSplits() {
    return splits;
  }

  /**
   * An array of objects specifying how to split a payment when using [Adyen for
   * Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information),
   * [Classic Platforms
   * integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information),
   * or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   *
   * @param splits An array of objects specifying how to split a payment when using [Adyen for
   *     Platforms](https://docs.adyen.com/platforms/process-payments#providing-split-information),
   *     [Classic Platforms
   *     integration](https://docs.adyen.com/classic-platforms/processing-payments#providing-split-information),
   *     or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   */
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }

  /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your
   * [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference)
   * (on [balance platform](https://docs.adyen.com/platforms)) or the
   * [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference)
   * (in the [classic
   * integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store))
   * for the ecommerce or point-of-sale store that is processing the payment.
   *
   * @param store Required for Adyen for Platforms integrations if you are a platform model. This is
   *     your
   *     [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference)
   *     (on [balance platform](https://docs.adyen.com/platforms)) or the
   *     [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference)
   *     (in the [classic
   *     integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store))
   *     for the ecommerce or point-of-sale store that is processing the payment.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest store(String store) {
    this.store = store;
    return this;
  }

  /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your
   * [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference)
   * (on [balance platform](https://docs.adyen.com/platforms)) or the
   * [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference)
   * (in the [classic
   * integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store))
   * for the ecommerce or point-of-sale store that is processing the payment.
   *
   * @return store Required for Adyen for Platforms integrations if you are a platform model. This
   *     is your
   *     [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference)
   *     (on [balance platform](https://docs.adyen.com/platforms)) or the
   *     [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference)
   *     (in the [classic
   *     integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store))
   *     for the ecommerce or point-of-sale store that is processing the payment.
   */
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStore() {
    return store;
  }

  /**
   * Required for Adyen for Platforms integrations if you are a platform model. This is your
   * [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference)
   * (on [balance platform](https://docs.adyen.com/platforms)) or the
   * [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference)
   * (in the [classic
   * integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store))
   * for the ecommerce or point-of-sale store that is processing the payment.
   *
   * @param store Required for Adyen for Platforms integrations if you are a platform model. This is
   *     your
   *     [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference)
   *     (on [balance platform](https://docs.adyen.com/platforms)) or the
   *     [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference)
   *     (in the [classic
   *     integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store))
   *     for the ecommerce or point-of-sale store that is processing the payment.
   */
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }

  /**
   * Specifies how payment methods should be filtered based on the &#39;store&#39; parameter: -
   * &#39;exclusive&#39;: Only payment methods belonging to the specified &#39;store&#39; are
   * returned. - &#39;inclusive&#39;: Payment methods from the &#39;store&#39; and those not
   * associated with any other store are returned.
   *
   * @param storeFiltrationMode Specifies how payment methods should be filtered based on the
   *     &#39;store&#39; parameter: - &#39;exclusive&#39;: Only payment methods belonging to the
   *     specified &#39;store&#39; are returned. - &#39;inclusive&#39;: Payment methods from the
   *     &#39;store&#39; and those not associated with any other store are returned.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest storeFiltrationMode(
      StoreFiltrationModeEnum storeFiltrationMode) {
    this.storeFiltrationMode = storeFiltrationMode;
    return this;
  }

  /**
   * Specifies how payment methods should be filtered based on the &#39;store&#39; parameter: -
   * &#39;exclusive&#39;: Only payment methods belonging to the specified &#39;store&#39; are
   * returned. - &#39;inclusive&#39;: Payment methods from the &#39;store&#39; and those not
   * associated with any other store are returned.
   *
   * @return storeFiltrationMode Specifies how payment methods should be filtered based on the
   *     &#39;store&#39; parameter: - &#39;exclusive&#39;: Only payment methods belonging to the
   *     specified &#39;store&#39; are returned. - &#39;inclusive&#39;: Payment methods from the
   *     &#39;store&#39; and those not associated with any other store are returned.
   */
  @JsonProperty(JSON_PROPERTY_STORE_FILTRATION_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StoreFiltrationModeEnum getStoreFiltrationMode() {
    return storeFiltrationMode;
  }

  /**
   * Specifies how payment methods should be filtered based on the &#39;store&#39; parameter: -
   * &#39;exclusive&#39;: Only payment methods belonging to the specified &#39;store&#39; are
   * returned. - &#39;inclusive&#39;: Payment methods from the &#39;store&#39; and those not
   * associated with any other store are returned.
   *
   * @param storeFiltrationMode Specifies how payment methods should be filtered based on the
   *     &#39;store&#39; parameter: - &#39;exclusive&#39;: Only payment methods belonging to the
   *     specified &#39;store&#39; are returned. - &#39;inclusive&#39;: Payment methods from the
   *     &#39;store&#39; and those not associated with any other store are returned.
   */
  @JsonProperty(JSON_PROPERTY_STORE_FILTRATION_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreFiltrationMode(StoreFiltrationModeEnum storeFiltrationMode) {
    this.storeFiltrationMode = storeFiltrationMode;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for
   * future [recurring
   * payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   *
   * @param storePaymentMethod When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be stored for future [recurring
   *     payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest storePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
    return this;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for
   * future [recurring
   * payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   *
   * @return storePaymentMethod When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be stored for future [recurring
   *     payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   */
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getStorePaymentMethod() {
    return storePaymentMethod;
  }

  /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored for
   * future [recurring
   * payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   *
   * @param storePaymentMethod When true and &#x60;shopperReference&#x60; is provided, the payment
   *     details will be stored for future [recurring
   *     payments](https://docs.adyen.com/online-payments/tokenization/#recurring-payment-types).
   */
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStorePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
  }

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values:
   * * **disabled** – No details will be stored (default). * **askForConsent** – If the
   * &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their
   * payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided,
   * the details will be stored without asking the shopper for consent.
   *
   * @param storePaymentMethodMode Indicates if the details of the payment method will be stored for
   *     the shopper. Possible values: * **disabled** – No details will be stored (default). *
   *     **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the
   *     shopper choose if they want their payment details to be stored. * **enabled** – If the
   *     &#x60;shopperReference&#x60; is provided, the details will be stored without asking the
   *     shopper for consent.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest storePaymentMethodMode(
      StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
    return this;
  }

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values:
   * * **disabled** – No details will be stored (default). * **askForConsent** – If the
   * &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their
   * payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided,
   * the details will be stored without asking the shopper for consent.
   *
   * @return storePaymentMethodMode Indicates if the details of the payment method will be stored
   *     for the shopper. Possible values: * **disabled** – No details will be stored (default). *
   *     **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the
   *     shopper choose if they want their payment details to be stored. * **enabled** – If the
   *     &#x60;shopperReference&#x60; is provided, the details will be stored without asking the
   *     shopper for consent.
   */
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
    return storePaymentMethodMode;
  }

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values:
   * * **disabled** – No details will be stored (default). * **askForConsent** – If the
   * &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their
   * payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided,
   * the details will be stored without asking the shopper for consent.
   *
   * @param storePaymentMethodMode Indicates if the details of the payment method will be stored for
   *     the shopper. Possible values: * **disabled** – No details will be stored (default). *
   *     **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the
   *     shopper choose if they want their payment details to be stored. * **enabled** – If the
   *     &#x60;shopperReference&#x60; is provided, the details will be stored without asking the
   *     shopper for consent.
   */
  @JsonProperty(JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
  }

  /**
   * The shopper&#39;s telephone number. &gt; Required for Visa and JCB transactions that require 3D
   * Secure 2 authentication, if you did not include the &#x60;shopperEmail&#x60;. The phone number
   * must include a plus sign (+) and a country code (1-3 digits), followed by the number (4-15
   * digits). If the value you provide does not follow the guidelines, we drop the value and do not
   * submit it for authentication.
   *
   * @param telephoneNumber The shopper&#39;s telephone number. &gt; Required for Visa and JCB
   *     transactions that require 3D Secure 2 authentication, if you did not include the
   *     &#x60;shopperEmail&#x60;. The phone number must include a plus sign (+) and a country code
   *     (1-3 digits), followed by the number (4-15 digits). If the value you provide does not
   *     follow the guidelines, we drop the value and do not submit it for authentication.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest telephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
    return this;
  }

  /**
   * The shopper&#39;s telephone number. &gt; Required for Visa and JCB transactions that require 3D
   * Secure 2 authentication, if you did not include the &#x60;shopperEmail&#x60;. The phone number
   * must include a plus sign (+) and a country code (1-3 digits), followed by the number (4-15
   * digits). If the value you provide does not follow the guidelines, we drop the value and do not
   * submit it for authentication.
   *
   * @return telephoneNumber The shopper&#39;s telephone number. &gt; Required for Visa and JCB
   *     transactions that require 3D Secure 2 authentication, if you did not include the
   *     &#x60;shopperEmail&#x60;. The phone number must include a plus sign (+) and a country code
   *     (1-3 digits), followed by the number (4-15 digits). If the value you provide does not
   *     follow the guidelines, we drop the value and do not submit it for authentication.
   */
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTelephoneNumber() {
    return telephoneNumber;
  }

  /**
   * The shopper&#39;s telephone number. &gt; Required for Visa and JCB transactions that require 3D
   * Secure 2 authentication, if you did not include the &#x60;shopperEmail&#x60;. The phone number
   * must include a plus sign (+) and a country code (1-3 digits), followed by the number (4-15
   * digits). If the value you provide does not follow the guidelines, we drop the value and do not
   * submit it for authentication.
   *
   * @param telephoneNumber The shopper&#39;s telephone number. &gt; Required for Visa and JCB
   *     transactions that require 3D Secure 2 authentication, if you did not include the
   *     &#x60;shopperEmail&#x60;. The phone number must include a plus sign (+) and a country code
   *     (1-3 digits), followed by the number (4-15 digits). If the value you provide does not
   *     follow the guidelines, we drop the value and do not submit it for authentication.
   */
  @JsonProperty(JSON_PROPERTY_TELEPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }

  /**
   * Sets a custom theme for [Hosted
   * Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout).
   * The value can be any of the **Theme ID** values from your Customer Area.
   *
   * @param themeId Sets a custom theme for [Hosted
   *     Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout).
   *     The value can be any of the **Theme ID** values from your Customer Area.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest themeId(String themeId) {
    this.themeId = themeId;
    return this;
  }

  /**
   * Sets a custom theme for [Hosted
   * Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout).
   * The value can be any of the **Theme ID** values from your Customer Area.
   *
   * @return themeId Sets a custom theme for [Hosted
   *     Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout).
   *     The value can be any of the **Theme ID** values from your Customer Area.
   */
  @JsonProperty(JSON_PROPERTY_THEME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThemeId() {
    return themeId;
  }

  /**
   * Sets a custom theme for [Hosted
   * Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout).
   * The value can be any of the **Theme ID** values from your Customer Area.
   *
   * @param themeId Sets a custom theme for [Hosted
   *     Checkout](https://docs.adyen.com/online-payments/build-your-integration/?platform&#x3D;Web&amp;integration&#x3D;Hosted+Checkout).
   *     The value can be any of the **Theme ID** values from your Customer Area.
   */
  @JsonProperty(JSON_PROPERTY_THEME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeId(String themeId) {
    this.themeId = themeId;
  }

  /**
   * threeDS2RequestData
   *
   * @param threeDS2RequestData
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest threeDS2RequestData(
      CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
    return this;
  }

  /**
   * Get threeDS2RequestData
   *
   * @return threeDS2RequestData
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CheckoutSessionThreeDS2RequestData getThreeDS2RequestData() {
    return threeDS2RequestData;
  }

  /**
   * threeDS2RequestData
   *
   * @param threeDS2RequestData
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_REQUEST_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
  }

  /**
   * Required to trigger the [authentication-only
   * flow](https://docs.adyen.com/online-payments/3d-secure/authentication-only/). If set to
   * **true**, you will only perform the 3D Secure 2 authentication, and will not proceed to the
   * payment authorization.Default: **false**.
   *
   * @param threeDSAuthenticationOnly Required to trigger the [authentication-only
   *     flow](https://docs.adyen.com/online-payments/3d-secure/authentication-only/). If set to
   *     **true**, you will only perform the 3D Secure 2 authentication, and will not proceed to the
   *     payment authorization.Default: **false**.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   * @deprecated since Adyen Checkout API v69 Use &#x60;authenticationData.authenticationOnly&#x60;
   *     instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v69: Use
  // `authenticationData.authenticationOnly` instead.
  public CreateCheckoutSessionRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    return this;
  }

  /**
   * Required to trigger the [authentication-only
   * flow](https://docs.adyen.com/online-payments/3d-secure/authentication-only/). If set to
   * **true**, you will only perform the 3D Secure 2 authentication, and will not proceed to the
   * payment authorization.Default: **false**.
   *
   * @return threeDSAuthenticationOnly Required to trigger the [authentication-only
   *     flow](https://docs.adyen.com/online-payments/3d-secure/authentication-only/). If set to
   *     **true**, you will only perform the 3D Secure 2 authentication, and will not proceed to the
   *     payment authorization.Default: **false**.
   * @deprecated // deprecated since Adyen Checkout API v69: Use
   *     `authenticationData.authenticationOnly` instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v69: Use
  // `authenticationData.authenticationOnly` instead.
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getThreeDSAuthenticationOnly() {
    return threeDSAuthenticationOnly;
  }

  /**
   * Required to trigger the [authentication-only
   * flow](https://docs.adyen.com/online-payments/3d-secure/authentication-only/). If set to
   * **true**, you will only perform the 3D Secure 2 authentication, and will not proceed to the
   * payment authorization.Default: **false**.
   *
   * @param threeDSAuthenticationOnly Required to trigger the [authentication-only
   *     flow](https://docs.adyen.com/online-payments/3d-secure/authentication-only/). If set to
   *     **true**, you will only perform the 3D Secure 2 authentication, and will not proceed to the
   *     payment authorization.Default: **false**.
   * @deprecated since Adyen Checkout API v69 Use &#x60;authenticationData.authenticationOnly&#x60;
   *     instead.
   */
  @Deprecated // deprecated since Adyen Checkout API v69: Use
  // `authenticationData.authenticationOnly` instead.
  @JsonProperty(JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
  }

  /**
   * Set to true if the payment should be routed to a trusted MID.
   *
   * @param trustedShopper Set to true if the payment should be routed to a trusted MID.
   * @return the current {@code CreateCheckoutSessionRequest} instance, allowing for method chaining
   */
  public CreateCheckoutSessionRequest trustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
    return this;
  }

  /**
   * Set to true if the payment should be routed to a trusted MID.
   *
   * @return trustedShopper Set to true if the payment should be routed to a trusted MID.
   */
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getTrustedShopper() {
    return trustedShopper;
  }

  /**
   * Set to true if the payment should be routed to a trusted MID.
   *
   * @param trustedShopper Set to true if the payment should be routed to a trusted MID.
   */
  @JsonProperty(JSON_PROPERTY_TRUSTED_SHOPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
  }

  /** Return true if this CreateCheckoutSessionRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCheckoutSessionRequest createCheckoutSessionRequest = (CreateCheckoutSessionRequest) o;
    return Objects.equals(this.accountInfo, createCheckoutSessionRequest.accountInfo)
        && Objects.equals(this.additionalAmount, createCheckoutSessionRequest.additionalAmount)
        && Objects.equals(this.additionalData, createCheckoutSessionRequest.additionalData)
        && Objects.equals(
            this.allowedPaymentMethods, createCheckoutSessionRequest.allowedPaymentMethods)
        && Objects.equals(this.amount, createCheckoutSessionRequest.amount)
        && Objects.equals(this.applicationInfo, createCheckoutSessionRequest.applicationInfo)
        && Objects.equals(this.authenticationData, createCheckoutSessionRequest.authenticationData)
        && Objects.equals(this.billingAddress, createCheckoutSessionRequest.billingAddress)
        && Objects.equals(
            this.blockedPaymentMethods, createCheckoutSessionRequest.blockedPaymentMethods)
        && Objects.equals(this.captureDelayHours, createCheckoutSessionRequest.captureDelayHours)
        && Objects.equals(this.channel, createCheckoutSessionRequest.channel)
        && Objects.equals(this.company, createCheckoutSessionRequest.company)
        && Objects.equals(this.countryCode, createCheckoutSessionRequest.countryCode)
        && Objects.equals(this.dateOfBirth, createCheckoutSessionRequest.dateOfBirth)
        && Objects.equals(this.deliverAt, createCheckoutSessionRequest.deliverAt)
        && Objects.equals(this.deliveryAddress, createCheckoutSessionRequest.deliveryAddress)
        && Objects.equals(this.enableOneClick, createCheckoutSessionRequest.enableOneClick)
        && Objects.equals(this.enablePayOut, createCheckoutSessionRequest.enablePayOut)
        && Objects.equals(this.enableRecurring, createCheckoutSessionRequest.enableRecurring)
        && Objects.equals(this.expiresAt, createCheckoutSessionRequest.expiresAt)
        && Objects.equals(this.fundOrigin, createCheckoutSessionRequest.fundOrigin)
        && Objects.equals(this.fundRecipient, createCheckoutSessionRequest.fundRecipient)
        && Objects.equals(this.installmentOptions, createCheckoutSessionRequest.installmentOptions)
        && Objects.equals(this.lineItems, createCheckoutSessionRequest.lineItems)
        && Objects.equals(this.mandate, createCheckoutSessionRequest.mandate)
        && Objects.equals(this.mcc, createCheckoutSessionRequest.mcc)
        && Objects.equals(this.merchantAccount, createCheckoutSessionRequest.merchantAccount)
        && Objects.equals(
            this.merchantOrderReference, createCheckoutSessionRequest.merchantOrderReference)
        && Objects.equals(this.metadata, createCheckoutSessionRequest.metadata)
        && Objects.equals(this.mode, createCheckoutSessionRequest.mode)
        && Objects.equals(this.mpiData, createCheckoutSessionRequest.mpiData)
        && Objects.equals(
            this.platformChargebackLogic, createCheckoutSessionRequest.platformChargebackLogic)
        && Objects.equals(this.recurringExpiry, createCheckoutSessionRequest.recurringExpiry)
        && Objects.equals(this.recurringFrequency, createCheckoutSessionRequest.recurringFrequency)
        && Objects.equals(
            this.recurringProcessingModel, createCheckoutSessionRequest.recurringProcessingModel)
        && Objects.equals(
            this.redirectFromIssuerMethod, createCheckoutSessionRequest.redirectFromIssuerMethod)
        && Objects.equals(
            this.redirectToIssuerMethod, createCheckoutSessionRequest.redirectToIssuerMethod)
        && Objects.equals(this.reference, createCheckoutSessionRequest.reference)
        && Objects.equals(this.returnUrl, createCheckoutSessionRequest.returnUrl)
        && Objects.equals(this.riskData, createCheckoutSessionRequest.riskData)
        && Objects.equals(this.shopperEmail, createCheckoutSessionRequest.shopperEmail)
        && Objects.equals(this.shopperIP, createCheckoutSessionRequest.shopperIP)
        && Objects.equals(this.shopperInteraction, createCheckoutSessionRequest.shopperInteraction)
        && Objects.equals(this.shopperLocale, createCheckoutSessionRequest.shopperLocale)
        && Objects.equals(this.shopperName, createCheckoutSessionRequest.shopperName)
        && Objects.equals(this.shopperReference, createCheckoutSessionRequest.shopperReference)
        && Objects.equals(this.shopperStatement, createCheckoutSessionRequest.shopperStatement)
        && Objects.equals(
            this.showInstallmentAmount, createCheckoutSessionRequest.showInstallmentAmount)
        && Objects.equals(
            this.showRemovePaymentMethodButton,
            createCheckoutSessionRequest.showRemovePaymentMethodButton)
        && Objects.equals(
            this.socialSecurityNumber, createCheckoutSessionRequest.socialSecurityNumber)
        && Objects.equals(
            this.splitCardFundingSources, createCheckoutSessionRequest.splitCardFundingSources)
        && Objects.equals(this.splits, createCheckoutSessionRequest.splits)
        && Objects.equals(this.store, createCheckoutSessionRequest.store)
        && Objects.equals(
            this.storeFiltrationMode, createCheckoutSessionRequest.storeFiltrationMode)
        && Objects.equals(this.storePaymentMethod, createCheckoutSessionRequest.storePaymentMethod)
        && Objects.equals(
            this.storePaymentMethodMode, createCheckoutSessionRequest.storePaymentMethodMode)
        && Objects.equals(this.telephoneNumber, createCheckoutSessionRequest.telephoneNumber)
        && Objects.equals(this.themeId, createCheckoutSessionRequest.themeId)
        && Objects.equals(
            this.threeDS2RequestData, createCheckoutSessionRequest.threeDS2RequestData)
        && Objects.equals(
            this.threeDSAuthenticationOnly, createCheckoutSessionRequest.threeDSAuthenticationOnly)
        && Objects.equals(this.trustedShopper, createCheckoutSessionRequest.trustedShopper);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountInfo,
        additionalAmount,
        additionalData,
        allowedPaymentMethods,
        amount,
        applicationInfo,
        authenticationData,
        billingAddress,
        blockedPaymentMethods,
        captureDelayHours,
        channel,
        company,
        countryCode,
        dateOfBirth,
        deliverAt,
        deliveryAddress,
        enableOneClick,
        enablePayOut,
        enableRecurring,
        expiresAt,
        fundOrigin,
        fundRecipient,
        installmentOptions,
        lineItems,
        mandate,
        mcc,
        merchantAccount,
        merchantOrderReference,
        metadata,
        mode,
        mpiData,
        platformChargebackLogic,
        recurringExpiry,
        recurringFrequency,
        recurringProcessingModel,
        redirectFromIssuerMethod,
        redirectToIssuerMethod,
        reference,
        returnUrl,
        riskData,
        shopperEmail,
        shopperIP,
        shopperInteraction,
        shopperLocale,
        shopperName,
        shopperReference,
        shopperStatement,
        showInstallmentAmount,
        showRemovePaymentMethodButton,
        socialSecurityNumber,
        splitCardFundingSources,
        splits,
        store,
        storeFiltrationMode,
        storePaymentMethod,
        storePaymentMethodMode,
        telephoneNumber,
        themeId,
        threeDS2RequestData,
        threeDSAuthenticationOnly,
        trustedShopper);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCheckoutSessionRequest {\n");
    sb.append("    accountInfo: ").append(toIndentedString(accountInfo)).append("\n");
    sb.append("    additionalAmount: ").append(toIndentedString(additionalAmount)).append("\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    allowedPaymentMethods: ")
        .append(toIndentedString(allowedPaymentMethods))
        .append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    authenticationData: ").append(toIndentedString(authenticationData)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    blockedPaymentMethods: ")
        .append(toIndentedString(blockedPaymentMethods))
        .append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    deliverAt: ").append(toIndentedString(deliverAt)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    enableOneClick: ").append(toIndentedString(enableOneClick)).append("\n");
    sb.append("    enablePayOut: ").append(toIndentedString(enablePayOut)).append("\n");
    sb.append("    enableRecurring: ").append(toIndentedString(enableRecurring)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    fundOrigin: ").append(toIndentedString(fundOrigin)).append("\n");
    sb.append("    fundRecipient: ").append(toIndentedString(fundRecipient)).append("\n");
    sb.append("    installmentOptions: ").append(toIndentedString(installmentOptions)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    mandate: ").append(toIndentedString(mandate)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ")
        .append(toIndentedString(merchantOrderReference))
        .append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    mpiData: ").append(toIndentedString(mpiData)).append("\n");
    sb.append("    platformChargebackLogic: ")
        .append(toIndentedString(platformChargebackLogic))
        .append("\n");
    sb.append("    recurringExpiry: ").append(toIndentedString(recurringExpiry)).append("\n");
    sb.append("    recurringFrequency: ").append(toIndentedString(recurringFrequency)).append("\n");
    sb.append("    recurringProcessingModel: ")
        .append(toIndentedString(recurringProcessingModel))
        .append("\n");
    sb.append("    redirectFromIssuerMethod: ")
        .append(toIndentedString(redirectFromIssuerMethod))
        .append("\n");
    sb.append("    redirectToIssuerMethod: ")
        .append(toIndentedString(redirectToIssuerMethod))
        .append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    riskData: ").append(toIndentedString(riskData)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperIP: ").append(toIndentedString(shopperIP)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    showInstallmentAmount: ")
        .append(toIndentedString(showInstallmentAmount))
        .append("\n");
    sb.append("    showRemovePaymentMethodButton: ")
        .append(toIndentedString(showRemovePaymentMethodButton))
        .append("\n");
    sb.append("    socialSecurityNumber: ")
        .append(toIndentedString(socialSecurityNumber))
        .append("\n");
    sb.append("    splitCardFundingSources: ")
        .append(toIndentedString(splitCardFundingSources))
        .append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storeFiltrationMode: ")
        .append(toIndentedString(storeFiltrationMode))
        .append("\n");
    sb.append("    storePaymentMethod: ").append(toIndentedString(storePaymentMethod)).append("\n");
    sb.append("    storePaymentMethodMode: ")
        .append(toIndentedString(storePaymentMethodMode))
        .append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    themeId: ").append(toIndentedString(themeId)).append("\n");
    sb.append("    threeDS2RequestData: ")
        .append(toIndentedString(threeDS2RequestData))
        .append("\n");
    sb.append("    threeDSAuthenticationOnly: ")
        .append(toIndentedString(threeDSAuthenticationOnly))
        .append("\n");
    sb.append("    trustedShopper: ").append(toIndentedString(trustedShopper)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of CreateCheckoutSessionRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CreateCheckoutSessionRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     CreateCheckoutSessionRequest
   */
  public static CreateCheckoutSessionRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CreateCheckoutSessionRequest.class);
  }

  /**
   * Convert an instance of CreateCheckoutSessionRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
