/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/** PaymentDetailsResponse */
@JsonPropertyOrder({
  PaymentDetailsResponse.JSON_PROPERTY_ADDITIONAL_DATA,
  PaymentDetailsResponse.JSON_PROPERTY_AMOUNT,
  PaymentDetailsResponse.JSON_PROPERTY_DONATION_TOKEN,
  PaymentDetailsResponse.JSON_PROPERTY_FRAUD_RESULT,
  PaymentDetailsResponse.JSON_PROPERTY_MERCHANT_REFERENCE,
  PaymentDetailsResponse.JSON_PROPERTY_ORDER,
  PaymentDetailsResponse.JSON_PROPERTY_PAYMENT_METHOD,
  PaymentDetailsResponse.JSON_PROPERTY_PSP_REFERENCE,
  PaymentDetailsResponse.JSON_PROPERTY_REFUSAL_REASON,
  PaymentDetailsResponse.JSON_PROPERTY_REFUSAL_REASON_CODE,
  PaymentDetailsResponse.JSON_PROPERTY_RESULT_CODE,
  PaymentDetailsResponse.JSON_PROPERTY_SHOPPER_LOCALE,
  PaymentDetailsResponse.JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA,
  PaymentDetailsResponse.JSON_PROPERTY_THREE_D_S2_RESULT,
  PaymentDetailsResponse.JSON_PROPERTY_THREE_D_S_PAYMENT_DATA
})
public class PaymentDetailsResponse {
  public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
  private Map<String, String> additionalData;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_DONATION_TOKEN = "donationToken";
  private String donationToken;

  public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
  private FraudResult fraudResult;

  public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
  private String merchantReference;

  public static final String JSON_PROPERTY_ORDER = "order";
  private CheckoutOrderResponse order;

  public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
  private ResponsePaymentMethod paymentMethod;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
  private String refusalReason;

  public static final String JSON_PROPERTY_REFUSAL_REASON_CODE = "refusalReasonCode";
  private String refusalReasonCode;

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   */
  public enum ResultCodeEnum {
    AUTHENTICATIONFINISHED(String.valueOf("AuthenticationFinished")),

    AUTHENTICATIONNOTREQUIRED(String.valueOf("AuthenticationNotRequired")),

    AUTHORISED(String.valueOf("Authorised")),

    CANCELLED(String.valueOf("Cancelled")),

    CHALLENGESHOPPER(String.valueOf("ChallengeShopper")),

    ERROR(String.valueOf("Error")),

    IDENTIFYSHOPPER(String.valueOf("IdentifyShopper")),

    PARTIALLYAUTHORISED(String.valueOf("PartiallyAuthorised")),

    PENDING(String.valueOf("Pending")),

    PRESENTTOSHOPPER(String.valueOf("PresentToShopper")),

    RECEIVED(String.valueOf("Received")),

    REDIRECTSHOPPER(String.valueOf("RedirectShopper")),

    REFUSED(String.valueOf("Refused")),

    SUCCESS(String.valueOf("Success"));

    private static final Logger LOG = Logger.getLogger(ResultCodeEnum.class.getName());

    private String value;

    ResultCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultCodeEnum fromValue(String value) {
      for (ResultCodeEnum b : ResultCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ResultCodeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ResultCodeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private ResultCodeEnum resultCode;

  public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
  private String shopperLocale;

  public static final String JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA = "threeDS2ResponseData";
  private ThreeDS2ResponseData threeDS2ResponseData;

  public static final String JSON_PROPERTY_THREE_D_S2_RESULT = "threeDS2Result";
  private ThreeDS2Result threeDS2Result;

  public static final String JSON_PROPERTY_THREE_D_S_PAYMENT_DATA = "threeDSPaymentData";
  private String threeDSPaymentData;

  public PaymentDetailsResponse() {}

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse additionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  public PaymentDetailsResponse putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @return additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getAdditionalData() {
    return additionalData;
  }

  /**
   * Contains additional information about the payment. Some data fields are included only if you
   * select them first: Go to **Customer Area** &gt; **Developers** &gt; **Additional data**.
   *
   * @param additionalData Contains additional information about the payment. Some data fields are
   *     included only if you select them first: Go to **Customer Area** &gt; **Developers** &gt;
   *     **Additional data**.
   */
  @JsonProperty(JSON_PROPERTY_ADDITIONAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }

  /**
   * amount
   *
   * @param amount
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  /**
   * amount
   *
   * @param amount
   */
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  /**
   * Donation Token containing payment details for Adyen Giving.
   *
   * @param donationToken Donation Token containing payment details for Adyen Giving.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse donationToken(String donationToken) {
    this.donationToken = donationToken;
    return this;
  }

  /**
   * Donation Token containing payment details for Adyen Giving.
   *
   * @return donationToken Donation Token containing payment details for Adyen Giving.
   */
  @JsonProperty(JSON_PROPERTY_DONATION_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDonationToken() {
    return donationToken;
  }

  /**
   * Donation Token containing payment details for Adyen Giving.
   *
   * @param donationToken Donation Token containing payment details for Adyen Giving.
   */
  @JsonProperty(JSON_PROPERTY_DONATION_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDonationToken(String donationToken) {
    this.donationToken = donationToken;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse fraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
    return this;
  }

  /**
   * Get fraudResult
   *
   * @return fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FraudResult getFraudResult() {
    return fraudResult;
  }

  /**
   * fraudResult
   *
   * @param fraudResult
   */
  @JsonProperty(JSON_PROPERTY_FRAUD_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudResult(FraudResult fraudResult) {
    this.fraudResult = fraudResult;
  }

  /**
   * The reference used during the /payments request.
   *
   * @param merchantReference The reference used during the /payments request.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse merchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
    return this;
  }

  /**
   * The reference used during the /payments request.
   *
   * @return merchantReference The reference used during the /payments request.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantReference() {
    return merchantReference;
  }

  /**
   * The reference used during the /payments request.
   *
   * @param merchantReference The reference used during the /payments request.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }

  /**
   * order
   *
   * @param order
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse order(CheckoutOrderResponse order) {
    this.order = order;
    return this;
  }

  /**
   * Get order
   *
   * @return order
   */
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CheckoutOrderResponse getOrder() {
    return order;
  }

  /**
   * order
   *
   * @param order
   */
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(CheckoutOrderResponse order) {
    this.order = order;
  }

  /**
   * paymentMethod
   *
   * @param paymentMethod
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse paymentMethod(ResponsePaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * Get paymentMethod
   *
   * @return paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResponsePaymentMethod getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * paymentMethod
   *
   * @param paymentMethod
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * Adyen&#39;s 16-character string reference associated with the transaction/request. This value
   * is globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character string reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * Adyen&#39;s 16-character string reference associated with the transaction/request. This value
   * is globally unique; quote it when communicating with us about this request.
   *
   * @return pspReference Adyen&#39;s 16-character string reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  /**
   * Adyen&#39;s 16-character string reference associated with the transaction/request. This value
   * is globally unique; quote it when communicating with us about this request.
   *
   * @param pspReference Adyen&#39;s 16-character string reference associated with the
   *     transaction/request. This value is globally unique; quote it when communicating with us
   *     about this request.
   */
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse refusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
    return this;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @return refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefusalReason() {
    return refusalReason;
  }

  /**
   * If the payment&#39;s authorisation is refused or an error occurs during authorisation, this
   * field holds Adyen&#39;s mapped reason for the refusal or a description of the error. When a
   * transaction fails, the authorisation response includes &#x60;resultCode&#x60; and
   * &#x60;refusalReason&#x60; values. For more information, see [Refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReason If the payment&#39;s authorisation is refused or an error occurs during
   *     authorisation, this field holds Adyen&#39;s mapped reason for the refusal or a description
   *     of the error. When a transaction fails, the authorisation response includes
   *     &#x60;resultCode&#x60; and &#x60;refusalReason&#x60; values. For more information, see
   *     [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefusalReason(String refusalReason) {
    this.refusalReason = refusalReason;
  }

  /**
   * Code that specifies the refusal reason. For more information, see [Authorisation refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReasonCode Code that specifies the refusal reason. For more information, see
   *     [Authorisation refusal
   *     reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse refusalReasonCode(String refusalReasonCode) {
    this.refusalReasonCode = refusalReasonCode;
    return this;
  }

  /**
   * Code that specifies the refusal reason. For more information, see [Authorisation refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @return refusalReasonCode Code that specifies the refusal reason. For more information, see
   *     [Authorisation refusal
   *     reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRefusalReasonCode() {
    return refusalReasonCode;
  }

  /**
   * Code that specifies the refusal reason. For more information, see [Authorisation refusal
   * reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   *
   * @param refusalReasonCode Code that specifies the refusal reason. For more information, see
   *     [Authorisation refusal
   *     reasons](https://docs.adyen.com/development-resources/refusal-reasons).
   */
  @JsonProperty(JSON_PROPERTY_REFUSAL_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefusalReasonCode(String refusalReasonCode) {
    this.refusalReasonCode = refusalReasonCode;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   *
   * @param resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure
   *     2. Returned for 3D Secure 2 authentication-only transactions. *
   *     **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication.
   *     Returned for [standalone authentication-only
   *     integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   *     * **Authorised** – The payment was successfully authorised. This state serves as an
   *     indicator to proceed with the delivery of goods and services. This is a final state. *
   *     **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the
   *     merchant) before processing was completed. This is a final state. * **ChallengeShopper** –
   *     The issuer requires further shopper interaction before the payment can be authenticated.
   *     Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment
   *     was being processed. The reason is given in the &#x60;refusalReason&#x60; field. This is a
   *     final state. * **IdentifyShopper** – The issuer requires the shopper&#39;s device
   *     fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions.
   *     * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This
   *     happens for card payments when the merchant supports Partial Authorisations and the
   *     cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to
   *     obtain the final status of the payment. This can happen if the systems providing final
   *     status information for the payment are unavailable, or if the shopper needs to take further
   *     action to complete the payment. * **PresentToShopper** – Indicates that the response
   *     contains additional information that you need to present to a shopper, so that they can use
   *     it to complete a payment. * **Received** – Indicates the payment has successfully been
   *     received by Adyen, and will be processed. This is the initial state for all payments. *
   *     **RedirectShopper** – Indicates the shopper should be redirected to an external web page or
   *     app to complete the authorisation. * **Refused** – Indicates the payment was refused. The
   *     reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse resultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   *
   * @return resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure
   *     2. Returned for 3D Secure 2 authentication-only transactions. *
   *     **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication.
   *     Returned for [standalone authentication-only
   *     integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   *     * **Authorised** – The payment was successfully authorised. This state serves as an
   *     indicator to proceed with the delivery of goods and services. This is a final state. *
   *     **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the
   *     merchant) before processing was completed. This is a final state. * **ChallengeShopper** –
   *     The issuer requires further shopper interaction before the payment can be authenticated.
   *     Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment
   *     was being processed. The reason is given in the &#x60;refusalReason&#x60; field. This is a
   *     final state. * **IdentifyShopper** – The issuer requires the shopper&#39;s device
   *     fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions.
   *     * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This
   *     happens for card payments when the merchant supports Partial Authorisations and the
   *     cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to
   *     obtain the final status of the payment. This can happen if the systems providing final
   *     status information for the payment are unavailable, or if the shopper needs to take further
   *     action to complete the payment. * **PresentToShopper** – Indicates that the response
   *     contains additional information that you need to present to a shopper, so that they can use
   *     it to complete a payment. * **Received** – Indicates the payment has successfully been
   *     received by Adyen, and will be processed. This is the initial state for all payments. *
   *     **RedirectShopper** – Indicates the shopper should be redirected to an external web page or
   *     app to complete the authorisation. * **Refused** – Indicates the payment was refused. The
   *     reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResultCodeEnum getResultCode() {
    return resultCode;
  }

  /**
   * The result of the payment. For more information, see [Result
   * codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2.
   * Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** –
   * The transaction does not require 3D Secure authentication. Returned for [standalone
   * authentication-only
   * integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   * * **Authorised** – The payment was successfully authorised. This state serves as an indicator
   * to proceed with the delivery of goods and services. This is a final state. * **Cancelled** –
   * Indicates the payment has been cancelled (either by the shopper or the merchant) before
   * processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires
   * further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2
   * transactions. * **Error** – There was an error when the payment was being processed. The reason
   * is given in the &#x60;refusalReason&#x60; field. This is a final state. * **IdentifyShopper** –
   * The issuer requires the shopper&#39;s device fingerprint before the payment can be
   * authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment
   * has been authorised for a partial amount. This happens for card payments when the merchant
   * supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** –
   * Indicates that it is not possible to obtain the final status of the payment. This can happen if
   * the systems providing final status information for the payment are unavailable, or if the
   * shopper needs to take further action to complete the payment. * **PresentToShopper** –
   * Indicates that the response contains additional information that you need to present to a
   * shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment
   * has successfully been received by Adyen, and will be processed. This is the initial state for
   * all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external
   * web page or app to complete the authorisation. * **Refused** – Indicates the payment was
   * refused. The reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   *
   * @param resultCode The result of the payment. For more information, see [Result
   *     codes](https://docs.adyen.com/online-payments/payment-result-codes). Possible values: *
   *     **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure
   *     2. Returned for 3D Secure 2 authentication-only transactions. *
   *     **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication.
   *     Returned for [standalone authentication-only
   *     integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only).
   *     * **Authorised** – The payment was successfully authorised. This state serves as an
   *     indicator to proceed with the delivery of goods and services. This is a final state. *
   *     **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the
   *     merchant) before processing was completed. This is a final state. * **ChallengeShopper** –
   *     The issuer requires further shopper interaction before the payment can be authenticated.
   *     Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment
   *     was being processed. The reason is given in the &#x60;refusalReason&#x60; field. This is a
   *     final state. * **IdentifyShopper** – The issuer requires the shopper&#39;s device
   *     fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions.
   *     * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This
   *     happens for card payments when the merchant supports Partial Authorisations and the
   *     cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to
   *     obtain the final status of the payment. This can happen if the systems providing final
   *     status information for the payment are unavailable, or if the shopper needs to take further
   *     action to complete the payment. * **PresentToShopper** – Indicates that the response
   *     contains additional information that you need to present to a shopper, so that they can use
   *     it to complete a payment. * **Received** – Indicates the payment has successfully been
   *     received by Adyen, and will be processed. This is the initial state for all payments. *
   *     **RedirectShopper** – Indicates the shopper should be redirected to an external web page or
   *     app to complete the authorisation. * **Refused** – Indicates the payment was refused. The
   *     reason is given in the &#x60;refusalReason&#x60; field. This is a final state.
   */
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(ResultCodeEnum resultCode) {
    this.resultCode = resultCode;
  }

  /**
   * The shopperLocale.
   *
   * @param shopperLocale The shopperLocale.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse shopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
    return this;
  }

  /**
   * The shopperLocale.
   *
   * @return shopperLocale The shopperLocale.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperLocale() {
    return shopperLocale;
  }

  /**
   * The shopperLocale.
   *
   * @param shopperLocale The shopperLocale.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }

  /**
   * threeDS2ResponseData
   *
   * @param threeDS2ResponseData
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse threeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
    this.threeDS2ResponseData = threeDS2ResponseData;
    return this;
  }

  /**
   * Get threeDS2ResponseData
   *
   * @return threeDS2ResponseData
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ThreeDS2ResponseData getThreeDS2ResponseData() {
    return threeDS2ResponseData;
  }

  /**
   * threeDS2ResponseData
   *
   * @param threeDS2ResponseData
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_RESPONSE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
    this.threeDS2ResponseData = threeDS2ResponseData;
  }

  /**
   * threeDS2Result
   *
   * @param threeDS2Result
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse threeDS2Result(ThreeDS2Result threeDS2Result) {
    this.threeDS2Result = threeDS2Result;
    return this;
  }

  /**
   * Get threeDS2Result
   *
   * @return threeDS2Result
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ThreeDS2Result getThreeDS2Result() {
    return threeDS2Result;
  }

  /**
   * threeDS2Result
   *
   * @param threeDS2Result
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
    this.threeDS2Result = threeDS2Result;
  }

  /**
   * When non-empty, contains a value that you must submit to the &#x60;/payments/details&#x60;
   * endpoint as &#x60;paymentData&#x60;.
   *
   * @param threeDSPaymentData When non-empty, contains a value that you must submit to the
   *     &#x60;/payments/details&#x60; endpoint as &#x60;paymentData&#x60;.
   * @return the current {@code PaymentDetailsResponse} instance, allowing for method chaining
   */
  public PaymentDetailsResponse threeDSPaymentData(String threeDSPaymentData) {
    this.threeDSPaymentData = threeDSPaymentData;
    return this;
  }

  /**
   * When non-empty, contains a value that you must submit to the &#x60;/payments/details&#x60;
   * endpoint as &#x60;paymentData&#x60;.
   *
   * @return threeDSPaymentData When non-empty, contains a value that you must submit to the
   *     &#x60;/payments/details&#x60; endpoint as &#x60;paymentData&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDSPaymentData() {
    return threeDSPaymentData;
  }

  /**
   * When non-empty, contains a value that you must submit to the &#x60;/payments/details&#x60;
   * endpoint as &#x60;paymentData&#x60;.
   *
   * @param threeDSPaymentData When non-empty, contains a value that you must submit to the
   *     &#x60;/payments/details&#x60; endpoint as &#x60;paymentData&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_THREE_D_S_PAYMENT_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSPaymentData(String threeDSPaymentData) {
    this.threeDSPaymentData = threeDSPaymentData;
  }

  /** Return true if this PaymentDetailsResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentDetailsResponse paymentDetailsResponse = (PaymentDetailsResponse) o;
    return Objects.equals(this.additionalData, paymentDetailsResponse.additionalData)
        && Objects.equals(this.amount, paymentDetailsResponse.amount)
        && Objects.equals(this.donationToken, paymentDetailsResponse.donationToken)
        && Objects.equals(this.fraudResult, paymentDetailsResponse.fraudResult)
        && Objects.equals(this.merchantReference, paymentDetailsResponse.merchantReference)
        && Objects.equals(this.order, paymentDetailsResponse.order)
        && Objects.equals(this.paymentMethod, paymentDetailsResponse.paymentMethod)
        && Objects.equals(this.pspReference, paymentDetailsResponse.pspReference)
        && Objects.equals(this.refusalReason, paymentDetailsResponse.refusalReason)
        && Objects.equals(this.refusalReasonCode, paymentDetailsResponse.refusalReasonCode)
        && Objects.equals(this.resultCode, paymentDetailsResponse.resultCode)
        && Objects.equals(this.shopperLocale, paymentDetailsResponse.shopperLocale)
        && Objects.equals(this.threeDS2ResponseData, paymentDetailsResponse.threeDS2ResponseData)
        && Objects.equals(this.threeDS2Result, paymentDetailsResponse.threeDS2Result)
        && Objects.equals(this.threeDSPaymentData, paymentDetailsResponse.threeDSPaymentData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        additionalData,
        amount,
        donationToken,
        fraudResult,
        merchantReference,
        order,
        paymentMethod,
        pspReference,
        refusalReason,
        refusalReasonCode,
        resultCode,
        shopperLocale,
        threeDS2ResponseData,
        threeDS2Result,
        threeDSPaymentData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentDetailsResponse {\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    donationToken: ").append(toIndentedString(donationToken)).append("\n");
    sb.append("    fraudResult: ").append(toIndentedString(fraudResult)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    refusalReason: ").append(toIndentedString(refusalReason)).append("\n");
    sb.append("    refusalReasonCode: ").append(toIndentedString(refusalReasonCode)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    threeDS2ResponseData: ")
        .append(toIndentedString(threeDS2ResponseData))
        .append("\n");
    sb.append("    threeDS2Result: ").append(toIndentedString(threeDS2Result)).append("\n");
    sb.append("    threeDSPaymentData: ").append(toIndentedString(threeDSPaymentData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentDetailsResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentDetailsResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaymentDetailsResponse
   */
  public static PaymentDetailsResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentDetailsResponse.class);
  }

  /**
   * Convert an instance of PaymentDetailsResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
