/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** StandalonePaymentCancelRequest */
@JsonPropertyOrder({
  StandalonePaymentCancelRequest.JSON_PROPERTY_APPLICATION_INFO,
  StandalonePaymentCancelRequest.JSON_PROPERTY_ENHANCED_SCHEME_DATA,
  StandalonePaymentCancelRequest.JSON_PROPERTY_MERCHANT_ACCOUNT,
  StandalonePaymentCancelRequest.JSON_PROPERTY_PAYMENT_REFERENCE,
  StandalonePaymentCancelRequest.JSON_PROPERTY_REFERENCE
})
public class StandalonePaymentCancelRequest {
  public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
  private ApplicationInfo applicationInfo;

  public static final String JSON_PROPERTY_ENHANCED_SCHEME_DATA = "enhancedSchemeData";
  private EnhancedSchemeData enhancedSchemeData;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_PAYMENT_REFERENCE = "paymentReference";
  private String paymentReference;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public StandalonePaymentCancelRequest() {}

  /**
   * applicationInfo
   *
   * @param applicationInfo
   * @return the current {@code StandalonePaymentCancelRequest} instance, allowing for method
   *     chaining
   */
  public StandalonePaymentCancelRequest applicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
    return this;
  }

  /**
   * Get applicationInfo
   *
   * @return applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }

  /**
   * applicationInfo
   *
   * @param applicationInfo
   */
  @JsonProperty(JSON_PROPERTY_APPLICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }

  /**
   * enhancedSchemeData
   *
   * @param enhancedSchemeData
   * @return the current {@code StandalonePaymentCancelRequest} instance, allowing for method
   *     chaining
   */
  public StandalonePaymentCancelRequest enhancedSchemeData(EnhancedSchemeData enhancedSchemeData) {
    this.enhancedSchemeData = enhancedSchemeData;
    return this;
  }

  /**
   * Get enhancedSchemeData
   *
   * @return enhancedSchemeData
   */
  @JsonProperty(JSON_PROPERTY_ENHANCED_SCHEME_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EnhancedSchemeData getEnhancedSchemeData() {
    return enhancedSchemeData;
  }

  /**
   * enhancedSchemeData
   *
   * @param enhancedSchemeData
   */
  @JsonProperty(JSON_PROPERTY_ENHANCED_SCHEME_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnhancedSchemeData(EnhancedSchemeData enhancedSchemeData) {
    this.enhancedSchemeData = enhancedSchemeData;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @param merchantAccount The merchant account that is used to process the payment.
   * @return the current {@code StandalonePaymentCancelRequest} instance, allowing for method
   *     chaining
   */
  public StandalonePaymentCancelRequest merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @return merchantAccount The merchant account that is used to process the payment.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The merchant account that is used to process the payment.
   *
   * @param merchantAccount The merchant account that is used to process the payment.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * The
   * [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference)
   * of the payment that you want to cancel.
   *
   * @param paymentReference The
   *     [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference)
   *     of the payment that you want to cancel.
   * @return the current {@code StandalonePaymentCancelRequest} instance, allowing for method
   *     chaining
   */
  public StandalonePaymentCancelRequest paymentReference(String paymentReference) {
    this.paymentReference = paymentReference;
    return this;
  }

  /**
   * The
   * [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference)
   * of the payment that you want to cancel.
   *
   * @return paymentReference The
   *     [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference)
   *     of the payment that you want to cancel.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentReference() {
    return paymentReference;
  }

  /**
   * The
   * [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference)
   * of the payment that you want to cancel.
   *
   * @param paymentReference The
   *     [&#x60;reference&#x60;](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__reqParam_reference)
   *     of the payment that you want to cancel.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentReference(String paymentReference) {
    this.paymentReference = paymentReference;
  }

  /**
   * Your reference for the cancel request. Maximum length: 80 characters.
   *
   * @param reference Your reference for the cancel request. Maximum length: 80 characters.
   * @return the current {@code StandalonePaymentCancelRequest} instance, allowing for method
   *     chaining
   */
  public StandalonePaymentCancelRequest reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the cancel request. Maximum length: 80 characters.
   *
   * @return reference Your reference for the cancel request. Maximum length: 80 characters.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the cancel request. Maximum length: 80 characters.
   *
   * @param reference Your reference for the cancel request. Maximum length: 80 characters.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /** Return true if this StandalonePaymentCancelRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StandalonePaymentCancelRequest standalonePaymentCancelRequest =
        (StandalonePaymentCancelRequest) o;
    return Objects.equals(this.applicationInfo, standalonePaymentCancelRequest.applicationInfo)
        && Objects.equals(
            this.enhancedSchemeData, standalonePaymentCancelRequest.enhancedSchemeData)
        && Objects.equals(this.merchantAccount, standalonePaymentCancelRequest.merchantAccount)
        && Objects.equals(this.paymentReference, standalonePaymentCancelRequest.paymentReference)
        && Objects.equals(this.reference, standalonePaymentCancelRequest.reference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        applicationInfo, enhancedSchemeData, merchantAccount, paymentReference, reference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StandalonePaymentCancelRequest {\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    enhancedSchemeData: ").append(toIndentedString(enhancedSchemeData)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    paymentReference: ").append(toIndentedString(paymentReference)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of StandalonePaymentCancelRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of StandalonePaymentCancelRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     StandalonePaymentCancelRequest
   */
  public static StandalonePaymentCancelRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, StandalonePaymentCancelRequest.class);
  }

  /**
   * Convert an instance of StandalonePaymentCancelRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
