/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.checkout;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** UpdatePaymentLinkRequest */
@JsonPropertyOrder({UpdatePaymentLinkRequest.JSON_PROPERTY_STATUS})
public class UpdatePaymentLinkRequest {
  /** Status of the payment link. Possible values: * **expired** */
  public enum StatusEnum {
    EXPIRED(String.valueOf("expired"));

    private static final Logger LOG = Logger.getLogger(StatusEnum.class.getName());

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public UpdatePaymentLinkRequest() {}

  /**
   * Status of the payment link. Possible values: * **expired**
   *
   * @param status Status of the payment link. Possible values: * **expired**
   * @return the current {@code UpdatePaymentLinkRequest} instance, allowing for method chaining
   */
  public UpdatePaymentLinkRequest status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Status of the payment link. Possible values: * **expired**
   *
   * @return status Status of the payment link. Possible values: * **expired**
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * Status of the payment link. Possible values: * **expired**
   *
   * @param status Status of the payment link. Possible values: * **expired**
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /** Return true if this UpdatePaymentLinkRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdatePaymentLinkRequest updatePaymentLinkRequest = (UpdatePaymentLinkRequest) o;
    return Objects.equals(this.status, updatePaymentLinkRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdatePaymentLinkRequest {\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of UpdatePaymentLinkRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UpdatePaymentLinkRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     UpdatePaymentLinkRequest
   */
  public static UpdatePaymentLinkRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UpdatePaymentLinkRequest.class);
  }

  /**
   * Convert an instance of UpdatePaymentLinkRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
