/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/** BalanceAccount */
@JsonPropertyOrder({
  BalanceAccount.JSON_PROPERTY_ACCOUNT_HOLDER_ID,
  BalanceAccount.JSON_PROPERTY_BALANCES,
  BalanceAccount.JSON_PROPERTY_DEFAULT_CURRENCY_CODE,
  BalanceAccount.JSON_PROPERTY_DESCRIPTION,
  BalanceAccount.JSON_PROPERTY_ID,
  BalanceAccount.JSON_PROPERTY_METADATA,
  BalanceAccount.JSON_PROPERTY_MIGRATED_ACCOUNT_CODE,
  BalanceAccount.JSON_PROPERTY_PLATFORM_PAYMENT_CONFIGURATION,
  BalanceAccount.JSON_PROPERTY_REFERENCE,
  BalanceAccount.JSON_PROPERTY_STATUS,
  BalanceAccount.JSON_PROPERTY_TIME_ZONE
})
public class BalanceAccount {
  public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
  private String accountHolderId;

  public static final String JSON_PROPERTY_BALANCES = "balances";
  private List<Balance> balances;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY_CODE = "defaultCurrencyCode";
  private String defaultCurrencyCode;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata;

  public static final String JSON_PROPERTY_MIGRATED_ACCOUNT_CODE = "migratedAccountCode";
  private String migratedAccountCode;

  public static final String JSON_PROPERTY_PLATFORM_PAYMENT_CONFIGURATION =
      "platformPaymentConfiguration";
  private PlatformPaymentConfiguration platformPaymentConfiguration;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  /** The status of the balance account, set to **active** by default. */
  public enum StatusEnum {
    ACTIVE(String.valueOf("active")),

    CLOSED(String.valueOf("closed")),

    INACTIVE(String.valueOf("inactive")),

    SUSPENDED(String.valueOf("suspended"));

    private static final Logger LOG = Logger.getLogger(StatusEnum.class.getName());

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
  private String timeZone;

  public BalanceAccount() {}

  /**
   * The unique identifier of the [account
   * holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id)
   * associated with the balance account.
   *
   * @param accountHolderId The unique identifier of the [account
   *     holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id)
   *     associated with the balance account.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount accountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
    return this;
  }

  /**
   * The unique identifier of the [account
   * holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id)
   * associated with the balance account.
   *
   * @return accountHolderId The unique identifier of the [account
   *     holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id)
   *     associated with the balance account.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountHolderId() {
    return accountHolderId;
  }

  /**
   * The unique identifier of the [account
   * holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id)
   * associated with the balance account.
   *
   * @param accountHolderId The unique identifier of the [account
   *     holder](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/accountHolders__resParam_id)
   *     associated with the balance account.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_HOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountHolderId(String accountHolderId) {
    this.accountHolderId = accountHolderId;
  }

  /**
   * List of balances with the amount and currency.
   *
   * @param balances List of balances with the amount and currency.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount balances(List<Balance> balances) {
    this.balances = balances;
    return this;
  }

  public BalanceAccount addBalancesItem(Balance balancesItem) {
    if (this.balances == null) {
      this.balances = new ArrayList<>();
    }
    this.balances.add(balancesItem);
    return this;
  }

  /**
   * List of balances with the amount and currency.
   *
   * @return balances List of balances with the amount and currency.
   */
  @JsonProperty(JSON_PROPERTY_BALANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Balance> getBalances() {
    return balances;
  }

  /**
   * List of balances with the amount and currency.
   *
   * @param balances List of balances with the amount and currency.
   */
  @JsonProperty(JSON_PROPERTY_BALANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalances(List<Balance> balances) {
    this.balances = balances;
  }

  /**
   * The default three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes) of the balance account. This
   * is the currency displayed on the Balance Account overview page in your Customer Area. The
   * default value is **EUR**. &gt; After a balance account is created, you cannot change its
   * default currency.
   *
   * @param defaultCurrencyCode The default three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes) of the balance account.
   *     This is the currency displayed on the Balance Account overview page in your Customer Area.
   *     The default value is **EUR**. &gt; After a balance account is created, you cannot change
   *     its default currency.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount defaultCurrencyCode(String defaultCurrencyCode) {
    this.defaultCurrencyCode = defaultCurrencyCode;
    return this;
  }

  /**
   * The default three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes) of the balance account. This
   * is the currency displayed on the Balance Account overview page in your Customer Area. The
   * default value is **EUR**. &gt; After a balance account is created, you cannot change its
   * default currency.
   *
   * @return defaultCurrencyCode The default three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes) of the balance account.
   *     This is the currency displayed on the Balance Account overview page in your Customer Area.
   *     The default value is **EUR**. &gt; After a balance account is created, you cannot change
   *     its default currency.
   */
  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDefaultCurrencyCode() {
    return defaultCurrencyCode;
  }

  /**
   * The default three-character [ISO currency
   * code](https://docs.adyen.com/development-resources/currency-codes) of the balance account. This
   * is the currency displayed on the Balance Account overview page in your Customer Area. The
   * default value is **EUR**. &gt; After a balance account is created, you cannot change its
   * default currency.
   *
   * @param defaultCurrencyCode The default three-character [ISO currency
   *     code](https://docs.adyen.com/development-resources/currency-codes) of the balance account.
   *     This is the currency displayed on the Balance Account overview page in your Customer Area.
   *     The default value is **EUR**. &gt; After a balance account is created, you cannot change
   *     its default currency.
   */
  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrencyCode(String defaultCurrencyCode) {
    this.defaultCurrencyCode = defaultCurrencyCode;
  }

  /**
   * A human-readable description of the balance account, maximum 300 characters. You can use this
   * parameter to distinguish between multiple balance accounts under an account holder.
   *
   * @param description A human-readable description of the balance account, maximum 300 characters.
   *     You can use this parameter to distinguish between multiple balance accounts under an
   *     account holder.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount description(String description) {
    this.description = description;
    return this;
  }

  /**
   * A human-readable description of the balance account, maximum 300 characters. You can use this
   * parameter to distinguish between multiple balance accounts under an account holder.
   *
   * @return description A human-readable description of the balance account, maximum 300
   *     characters. You can use this parameter to distinguish between multiple balance accounts
   *     under an account holder.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * A human-readable description of the balance account, maximum 300 characters. You can use this
   * parameter to distinguish between multiple balance accounts under an account holder.
   *
   * @param description A human-readable description of the balance account, maximum 300 characters.
   *     You can use this parameter to distinguish between multiple balance accounts under an
   *     account holder.
   */
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The unique identifier of the balance account.
   *
   * @param id The unique identifier of the balance account.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the balance account.
   *
   * @return id The unique identifier of the balance account.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the balance account.
   *
   * @param id The unique identifier of the balance account.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * A set of key and value pairs for general use. The keys do not have specific names and may be
   * used for storing miscellaneous data as desired. &gt; Note that during an update of metadata,
   * the omission of existing key-value pairs will result in the deletion of those key-value pairs.
   *
   * @param metadata A set of key and value pairs for general use. The keys do not have specific
   *     names and may be used for storing miscellaneous data as desired. &gt; Note that during an
   *     update of metadata, the omission of existing key-value pairs will result in the deletion of
   *     those key-value pairs.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount metadata(Map<String, String> metadata) {
    this.metadata = metadata;
    return this;
  }

  public BalanceAccount putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * A set of key and value pairs for general use. The keys do not have specific names and may be
   * used for storing miscellaneous data as desired. &gt; Note that during an update of metadata,
   * the omission of existing key-value pairs will result in the deletion of those key-value pairs.
   *
   * @return metadata A set of key and value pairs for general use. The keys do not have specific
   *     names and may be used for storing miscellaneous data as desired. &gt; Note that during an
   *     update of metadata, the omission of existing key-value pairs will result in the deletion of
   *     those key-value pairs.
   */
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getMetadata() {
    return metadata;
  }

  /**
   * A set of key and value pairs for general use. The keys do not have specific names and may be
   * used for storing miscellaneous data as desired. &gt; Note that during an update of metadata,
   * the omission of existing key-value pairs will result in the deletion of those key-value pairs.
   *
   * @param metadata A set of key and value pairs for general use. The keys do not have specific
   *     names and may be used for storing miscellaneous data as desired. &gt; Note that during an
   *     update of metadata, the omission of existing key-value pairs will result in the deletion of
   *     those key-value pairs.
   */
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  /**
   * The unique identifier of the account of the migrated account holder in the classic integration.
   *
   * @param migratedAccountCode The unique identifier of the account of the migrated account holder
   *     in the classic integration.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount migratedAccountCode(String migratedAccountCode) {
    this.migratedAccountCode = migratedAccountCode;
    return this;
  }

  /**
   * The unique identifier of the account of the migrated account holder in the classic integration.
   *
   * @return migratedAccountCode The unique identifier of the account of the migrated account holder
   *     in the classic integration.
   */
  @JsonProperty(JSON_PROPERTY_MIGRATED_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMigratedAccountCode() {
    return migratedAccountCode;
  }

  /**
   * The unique identifier of the account of the migrated account holder in the classic integration.
   *
   * @param migratedAccountCode The unique identifier of the account of the migrated account holder
   *     in the classic integration.
   */
  @JsonProperty(JSON_PROPERTY_MIGRATED_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMigratedAccountCode(String migratedAccountCode) {
    this.migratedAccountCode = migratedAccountCode;
  }

  /**
   * platformPaymentConfiguration
   *
   * @param platformPaymentConfiguration
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount platformPaymentConfiguration(
      PlatformPaymentConfiguration platformPaymentConfiguration) {
    this.platformPaymentConfiguration = platformPaymentConfiguration;
    return this;
  }

  /**
   * Get platformPaymentConfiguration
   *
   * @return platformPaymentConfiguration
   */
  @JsonProperty(JSON_PROPERTY_PLATFORM_PAYMENT_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PlatformPaymentConfiguration getPlatformPaymentConfiguration() {
    return platformPaymentConfiguration;
  }

  /**
   * platformPaymentConfiguration
   *
   * @param platformPaymentConfiguration
   */
  @JsonProperty(JSON_PROPERTY_PLATFORM_PAYMENT_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformPaymentConfiguration(
      PlatformPaymentConfiguration platformPaymentConfiguration) {
    this.platformPaymentConfiguration = platformPaymentConfiguration;
  }

  /**
   * Your reference for the balance account, maximum 150 characters.
   *
   * @param reference Your reference for the balance account, maximum 150 characters.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the balance account, maximum 150 characters.
   *
   * @return reference Your reference for the balance account, maximum 150 characters.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the balance account, maximum 150 characters.
   *
   * @param reference Your reference for the balance account, maximum 150 characters.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The status of the balance account, set to **active** by default.
   *
   * @param status The status of the balance account, set to **active** by default.
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the balance account, set to **active** by default.
   *
   * @return status The status of the balance account, set to **active** by default.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the balance account, set to **active** by default.
   *
   * @param status The status of the balance account, set to **active** by default.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The time zone of the balance account. For example, **Europe/Amsterdam**. Defaults to the time
   * zone of the account holder if no time zone is set. For possible values, see the [list of time
   * zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   *
   * @param timeZone The time zone of the balance account. For example, **Europe/Amsterdam**.
   *     Defaults to the time zone of the account holder if no time zone is set. For possible
   *     values, see the [list of time zone
   *     codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   * @return the current {@code BalanceAccount} instance, allowing for method chaining
   */
  public BalanceAccount timeZone(String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * The time zone of the balance account. For example, **Europe/Amsterdam**. Defaults to the time
   * zone of the account holder if no time zone is set. For possible values, see the [list of time
   * zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   *
   * @return timeZone The time zone of the balance account. For example, **Europe/Amsterdam**.
   *     Defaults to the time zone of the account holder if no time zone is set. For possible
   *     values, see the [list of time zone
   *     codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   */
  @JsonProperty(JSON_PROPERTY_TIME_ZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTimeZone() {
    return timeZone;
  }

  /**
   * The time zone of the balance account. For example, **Europe/Amsterdam**. Defaults to the time
   * zone of the account holder if no time zone is set. For possible values, see the [list of time
   * zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   *
   * @param timeZone The time zone of the balance account. For example, **Europe/Amsterdam**.
   *     Defaults to the time zone of the account holder if no time zone is set. For possible
   *     values, see the [list of time zone
   *     codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
   */
  @JsonProperty(JSON_PROPERTY_TIME_ZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }

  /** Return true if this BalanceAccount object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceAccount balanceAccount = (BalanceAccount) o;
    return Objects.equals(this.accountHolderId, balanceAccount.accountHolderId)
        && Objects.equals(this.balances, balanceAccount.balances)
        && Objects.equals(this.defaultCurrencyCode, balanceAccount.defaultCurrencyCode)
        && Objects.equals(this.description, balanceAccount.description)
        && Objects.equals(this.id, balanceAccount.id)
        && Objects.equals(this.metadata, balanceAccount.metadata)
        && Objects.equals(this.migratedAccountCode, balanceAccount.migratedAccountCode)
        && Objects.equals(
            this.platformPaymentConfiguration, balanceAccount.platformPaymentConfiguration)
        && Objects.equals(this.reference, balanceAccount.reference)
        && Objects.equals(this.status, balanceAccount.status)
        && Objects.equals(this.timeZone, balanceAccount.timeZone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountHolderId,
        balances,
        defaultCurrencyCode,
        description,
        id,
        metadata,
        migratedAccountCode,
        platformPaymentConfiguration,
        reference,
        status,
        timeZone);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceAccount {\n");
    sb.append("    accountHolderId: ").append(toIndentedString(accountHolderId)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    defaultCurrencyCode: ")
        .append(toIndentedString(defaultCurrencyCode))
        .append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    migratedAccountCode: ")
        .append(toIndentedString(migratedAccountCode))
        .append("\n");
    sb.append("    platformPaymentConfiguration: ")
        .append(toIndentedString(platformPaymentConfiguration))
        .append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of BalanceAccount given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of BalanceAccount
   * @throws JsonProcessingException if the JSON string is invalid with respect to BalanceAccount
   */
  public static BalanceAccount fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, BalanceAccount.class);
  }

  /**
   * Convert an instance of BalanceAccount to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
