/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import java.util.Optional;
import java.util.logging.Logger;

/**
 * Handler for processing ConfigurationWebhooks.
 *
 * <p>This class provides functionality to deserialize the payload of ConfigurationWebhooks events.
 */
public class ConfigurationWebhooksHandler {

  private static final Logger LOG = Logger.getLogger(ConfigurationWebhooksHandler.class.getName());

  private final String payload;

  /**
   * Constructs a new handler for the given webhook payload
   *
   * @param payload the raw JSON payload from the webhook
   */
  public ConfigurationWebhooksHandler(String payload) {
    this.payload = payload;
  }

  /**
   * Attempts to deserialize the webhook payload into a AccountHolderNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<AccountHolderNotificationRequest> getAccountHolderNotificationRequest() {

    var optionalAccountHolderNotificationRequest =
        getOptionalField(AccountHolderNotificationRequest.class);

    if (optionalAccountHolderNotificationRequest.isPresent()) {
      // verify event type
      for (var value : AccountHolderNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalAccountHolderNotificationRequest.get().getType())) {
          // found matching event type
          return optionalAccountHolderNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a BalanceAccountNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<BalanceAccountNotificationRequest> getBalanceAccountNotificationRequest() {

    var optionalBalanceAccountNotificationRequest =
        getOptionalField(BalanceAccountNotificationRequest.class);

    if (optionalBalanceAccountNotificationRequest.isPresent()) {
      // verify event type
      for (var value : BalanceAccountNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalBalanceAccountNotificationRequest.get().getType())) {
          // found matching event type
          return optionalBalanceAccountNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a CardOrderNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<CardOrderNotificationRequest> getCardOrderNotificationRequest() {

    var optionalCardOrderNotificationRequest = getOptionalField(CardOrderNotificationRequest.class);

    if (optionalCardOrderNotificationRequest.isPresent()) {
      // verify event type
      for (var value : CardOrderNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalCardOrderNotificationRequest.get().getType())) {
          // found matching event type
          return optionalCardOrderNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a NetworkTokenNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<NetworkTokenNotificationRequest> getNetworkTokenNotificationRequest() {

    var optionalNetworkTokenNotificationRequest =
        getOptionalField(NetworkTokenNotificationRequest.class);

    if (optionalNetworkTokenNotificationRequest.isPresent()) {
      // verify event type
      for (var value : NetworkTokenNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalNetworkTokenNotificationRequest.get().getType())) {
          // found matching event type
          return optionalNetworkTokenNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a PaymentNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<PaymentNotificationRequest> getPaymentNotificationRequest() {

    var optionalPaymentNotificationRequest = getOptionalField(PaymentNotificationRequest.class);

    if (optionalPaymentNotificationRequest.isPresent()) {
      // verify event type
      for (var value : PaymentNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalPaymentNotificationRequest.get().getType())) {
          // found matching event type
          return optionalPaymentNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a SweepConfigurationNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<SweepConfigurationNotificationRequest>
      getSweepConfigurationNotificationRequest() {

    var optionalSweepConfigurationNotificationRequest =
        getOptionalField(SweepConfigurationNotificationRequest.class);

    if (optionalSweepConfigurationNotificationRequest.isPresent()) {
      // verify event type
      for (var value : SweepConfigurationNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalSweepConfigurationNotificationRequest.get().getType())) {
          // found matching event type
          return optionalSweepConfigurationNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Deserializes the payload into the specified class type.
   *
   * @param clazz the class to deserialize into
   * @param <T> the type of the class
   * @return an Optional containing the deserialized object, or empty if an error occurs
   */
  private <T> Optional<T> getOptionalField(Class<T> clazz) {
    try {
      T val = JSON.getMapper().readValue(payload, clazz);
      return Optional.ofNullable(val);
    } catch (Exception e) {
      // an error has occurred during deserialization (object not found, deserialization error)
      LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
      LOG.warning("Deserialization error: " + e.getMessage());
      return Optional.empty();
    }
  }
}
