/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** Device */
@JsonPropertyOrder({Device.JSON_PROPERTY_FORM_FACTOR, Device.JSON_PROPERTY_OS_NAME})
public class Device {
  public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
  private String formFactor;

  public static final String JSON_PROPERTY_OS_NAME = "osName";
  private String osName;

  public Device() {}

  /**
   * The type of the device used for provisioning the network token. For example, **phone**,
   * **mobile_phone**, **watch**, **mobilephone_or_tablet**, etc
   *
   * @param formFactor The type of the device used for provisioning the network token. For example,
   *     **phone**, **mobile_phone**, **watch**, **mobilephone_or_tablet**, etc
   * @return the current {@code Device} instance, allowing for method chaining
   */
  public Device formFactor(String formFactor) {
    this.formFactor = formFactor;
    return this;
  }

  /**
   * The type of the device used for provisioning the network token. For example, **phone**,
   * **mobile_phone**, **watch**, **mobilephone_or_tablet**, etc
   *
   * @return formFactor The type of the device used for provisioning the network token. For example,
   *     **phone**, **mobile_phone**, **watch**, **mobilephone_or_tablet**, etc
   */
  @JsonProperty(JSON_PROPERTY_FORM_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFormFactor() {
    return formFactor;
  }

  /**
   * The type of the device used for provisioning the network token. For example, **phone**,
   * **mobile_phone**, **watch**, **mobilephone_or_tablet**, etc
   *
   * @param formFactor The type of the device used for provisioning the network token. For example,
   *     **phone**, **mobile_phone**, **watch**, **mobilephone_or_tablet**, etc
   */
  @JsonProperty(JSON_PROPERTY_FORM_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFactor(String formFactor) {
    this.formFactor = formFactor;
  }

  /**
   * The operating system of the device used for provisioning the network token.
   *
   * @param osName The operating system of the device used for provisioning the network token.
   * @return the current {@code Device} instance, allowing for method chaining
   */
  public Device osName(String osName) {
    this.osName = osName;
    return this;
  }

  /**
   * The operating system of the device used for provisioning the network token.
   *
   * @return osName The operating system of the device used for provisioning the network token.
   */
  @JsonProperty(JSON_PROPERTY_OS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOsName() {
    return osName;
  }

  /**
   * The operating system of the device used for provisioning the network token.
   *
   * @param osName The operating system of the device used for provisioning the network token.
   */
  @JsonProperty(JSON_PROPERTY_OS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsName(String osName) {
    this.osName = osName;
  }

  /** Return true if this Device object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Device device = (Device) o;
    return Objects.equals(this.formFactor, device.formFactor)
        && Objects.equals(this.osName, device.osName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(formFactor, osName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Device {\n");
    sb.append("    formFactor: ").append(toIndentedString(formFactor)).append("\n");
    sb.append("    osName: ").append(toIndentedString(osName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Device given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Device
   * @throws JsonProcessingException if the JSON string is invalid with respect to Device
   */
  public static Device fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Device.class);
  }

  /**
   * Convert an instance of Device to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
