/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** NetworkTokenNotificationDataV2 */
@JsonPropertyOrder({
  NetworkTokenNotificationDataV2.JSON_PROPERTY_AUTHENTICATION,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_AUTHENTICATION_APPLIED,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_BALANCE_PLATFORM,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_DECISION,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_ID,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_PAYMENT_INSTRUMENT_ID,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_STATUS,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_TOKEN_LAST_FOUR,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_TOKEN_REQUESTOR,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_TYPE,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_VALIDATION_FACTS,
  NetworkTokenNotificationDataV2.JSON_PROPERTY_WALLET
})
public class NetworkTokenNotificationDataV2 {
  public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
  private TokenAuthentication authentication;

  public static final String JSON_PROPERTY_AUTHENTICATION_APPLIED = "authenticationApplied";
  private Boolean authenticationApplied;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_DECISION = "decision";
  private String decision;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
  private String paymentInstrumentId;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public static final String JSON_PROPERTY_TOKEN_LAST_FOUR = "tokenLastFour";
  private String tokenLastFour;

  public static final String JSON_PROPERTY_TOKEN_REQUESTOR = "tokenRequestor";
  private NetworkTokenRequestor tokenRequestor;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_VALIDATION_FACTS = "validationFacts";
  private List<ValidationFacts> validationFacts;

  public static final String JSON_PROPERTY_WALLET = "wallet";
  private Wallet wallet;

  public NetworkTokenNotificationDataV2() {}

  /**
   * authentication
   *
   * @param authentication
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 authentication(TokenAuthentication authentication) {
    this.authentication = authentication;
    return this;
  }

  /**
   * Get authentication
   *
   * @return authentication
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TokenAuthentication getAuthentication() {
    return authentication;
  }

  /**
   * authentication
   *
   * @param authentication
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthentication(TokenAuthentication authentication) {
    this.authentication = authentication;
  }

  /**
   * Specifies whether the authentication process was triggered during token provisioning.
   *
   * @param authenticationApplied Specifies whether the authentication process was triggered during
   *     token provisioning.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 authenticationApplied(Boolean authenticationApplied) {
    this.authenticationApplied = authenticationApplied;
    return this;
  }

  /**
   * Specifies whether the authentication process was triggered during token provisioning.
   *
   * @return authenticationApplied Specifies whether the authentication process was triggered during
   *     token provisioning.
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_APPLIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAuthenticationApplied() {
    return authenticationApplied;
  }

  /**
   * Specifies whether the authentication process was triggered during token provisioning.
   *
   * @param authenticationApplied Specifies whether the authentication process was triggered during
   *     token provisioning.
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_APPLIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationApplied(Boolean authenticationApplied) {
    this.authenticationApplied = authenticationApplied;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform The unique identifier of the balance platform.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 balancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @return balancePlatform The unique identifier of the balance platform.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBalancePlatform() {
    return balancePlatform;
  }

  /**
   * The unique identifier of the balance platform.
   *
   * @param balancePlatform The unique identifier of the balance platform.
   */
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }

  /**
   * The decision about the network token provisioning. Possible values: **approved**, **declined**,
   * **requiresAuthentication**.
   *
   * @param decision The decision about the network token provisioning. Possible values:
   *     **approved**, **declined**, **requiresAuthentication**.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 decision(String decision) {
    this.decision = decision;
    return this;
  }

  /**
   * The decision about the network token provisioning. Possible values: **approved**, **declined**,
   * **requiresAuthentication**.
   *
   * @return decision The decision about the network token provisioning. Possible values:
   *     **approved**, **declined**, **requiresAuthentication**.
   */
  @JsonProperty(JSON_PROPERTY_DECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecision() {
    return decision;
  }

  /**
   * The decision about the network token provisioning. Possible values: **approved**, **declined**,
   * **requiresAuthentication**.
   *
   * @param decision The decision about the network token provisioning. Possible values:
   *     **approved**, **declined**, **requiresAuthentication**.
   */
  @JsonProperty(JSON_PROPERTY_DECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecision(String decision) {
    this.decision = decision;
  }

  /**
   * The unique identifier of the network token.
   *
   * @param id The unique identifier of the network token.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the network token.
   *
   * @return id The unique identifier of the network token.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the network token.
   *
   * @param id The unique identifier of the network token.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The unique identifier of the payment instrument to which the network token is associated.
   *
   * @param paymentInstrumentId The unique identifier of the payment instrument to which the network
   *     token is associated.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 paymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
    return this;
  }

  /**
   * The unique identifier of the payment instrument to which the network token is associated.
   *
   * @return paymentInstrumentId The unique identifier of the payment instrument to which the
   *     network token is associated.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentInstrumentId() {
    return paymentInstrumentId;
  }

  /**
   * The unique identifier of the payment instrument to which the network token is associated.
   *
   * @param paymentInstrumentId The unique identifier of the payment instrument to which the network
   *     token is associated.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
  }

  /**
   * The status of the network token.
   *
   * @param status The status of the network token.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the network token.
   *
   * @return status The status of the network token.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStatus() {
    return status;
  }

  /**
   * The status of the network token.
   *
   * @param status The status of the network token.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * The last four digits of the network token. Use this value to help your user to identify their
   * network token.
   *
   * @param tokenLastFour The last four digits of the network token. Use this value to help your
   *     user to identify their network token.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 tokenLastFour(String tokenLastFour) {
    this.tokenLastFour = tokenLastFour;
    return this;
  }

  /**
   * The last four digits of the network token. Use this value to help your user to identify their
   * network token.
   *
   * @return tokenLastFour The last four digits of the network token. Use this value to help your
   *     user to identify their network token.
   */
  @JsonProperty(JSON_PROPERTY_TOKEN_LAST_FOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTokenLastFour() {
    return tokenLastFour;
  }

  /**
   * The last four digits of the network token. Use this value to help your user to identify their
   * network token.
   *
   * @param tokenLastFour The last four digits of the network token. Use this value to help your
   *     user to identify their network token.
   */
  @JsonProperty(JSON_PROPERTY_TOKEN_LAST_FOUR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenLastFour(String tokenLastFour) {
    this.tokenLastFour = tokenLastFour;
  }

  /**
   * tokenRequestor
   *
   * @param tokenRequestor
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 tokenRequestor(NetworkTokenRequestor tokenRequestor) {
    this.tokenRequestor = tokenRequestor;
    return this;
  }

  /**
   * Get tokenRequestor
   *
   * @return tokenRequestor
   */
  @JsonProperty(JSON_PROPERTY_TOKEN_REQUESTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NetworkTokenRequestor getTokenRequestor() {
    return tokenRequestor;
  }

  /**
   * tokenRequestor
   *
   * @param tokenRequestor
   */
  @JsonProperty(JSON_PROPERTY_TOKEN_REQUESTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenRequestor(NetworkTokenRequestor tokenRequestor) {
    this.tokenRequestor = tokenRequestor;
  }

  /**
   * The type of network token.
   *
   * @param type The type of network token.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of network token.
   *
   * @return type The type of network token.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of network token.
   *
   * @param type The type of network token.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /**
   * The rules used to validate the request for provisioning the network token.
   *
   * @param validationFacts The rules used to validate the request for provisioning the network
   *     token.
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 validationFacts(List<ValidationFacts> validationFacts) {
    this.validationFacts = validationFacts;
    return this;
  }

  public NetworkTokenNotificationDataV2 addValidationFactsItem(
      ValidationFacts validationFactsItem) {
    if (this.validationFacts == null) {
      this.validationFacts = new ArrayList<>();
    }
    this.validationFacts.add(validationFactsItem);
    return this;
  }

  /**
   * The rules used to validate the request for provisioning the network token.
   *
   * @return validationFacts The rules used to validate the request for provisioning the network
   *     token.
   */
  @JsonProperty(JSON_PROPERTY_VALIDATION_FACTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ValidationFacts> getValidationFacts() {
    return validationFacts;
  }

  /**
   * The rules used to validate the request for provisioning the network token.
   *
   * @param validationFacts The rules used to validate the request for provisioning the network
   *     token.
   */
  @JsonProperty(JSON_PROPERTY_VALIDATION_FACTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidationFacts(List<ValidationFacts> validationFacts) {
    this.validationFacts = validationFacts;
  }

  /**
   * wallet
   *
   * @param wallet
   * @return the current {@code NetworkTokenNotificationDataV2} instance, allowing for method
   *     chaining
   */
  public NetworkTokenNotificationDataV2 wallet(Wallet wallet) {
    this.wallet = wallet;
    return this;
  }

  /**
   * Get wallet
   *
   * @return wallet
   */
  @JsonProperty(JSON_PROPERTY_WALLET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Wallet getWallet() {
    return wallet;
  }

  /**
   * wallet
   *
   * @param wallet
   */
  @JsonProperty(JSON_PROPERTY_WALLET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWallet(Wallet wallet) {
    this.wallet = wallet;
  }

  /** Return true if this NetworkTokenNotificationDataV2 object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NetworkTokenNotificationDataV2 networkTokenNotificationDataV2 =
        (NetworkTokenNotificationDataV2) o;
    return Objects.equals(this.authentication, networkTokenNotificationDataV2.authentication)
        && Objects.equals(
            this.authenticationApplied, networkTokenNotificationDataV2.authenticationApplied)
        && Objects.equals(this.balancePlatform, networkTokenNotificationDataV2.balancePlatform)
        && Objects.equals(this.decision, networkTokenNotificationDataV2.decision)
        && Objects.equals(this.id, networkTokenNotificationDataV2.id)
        && Objects.equals(
            this.paymentInstrumentId, networkTokenNotificationDataV2.paymentInstrumentId)
        && Objects.equals(this.status, networkTokenNotificationDataV2.status)
        && Objects.equals(this.tokenLastFour, networkTokenNotificationDataV2.tokenLastFour)
        && Objects.equals(this.tokenRequestor, networkTokenNotificationDataV2.tokenRequestor)
        && Objects.equals(this.type, networkTokenNotificationDataV2.type)
        && Objects.equals(this.validationFacts, networkTokenNotificationDataV2.validationFacts)
        && Objects.equals(this.wallet, networkTokenNotificationDataV2.wallet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        authentication,
        authenticationApplied,
        balancePlatform,
        decision,
        id,
        paymentInstrumentId,
        status,
        tokenLastFour,
        tokenRequestor,
        type,
        validationFacts,
        wallet);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NetworkTokenNotificationDataV2 {\n");
    sb.append("    authentication: ").append(toIndentedString(authentication)).append("\n");
    sb.append("    authenticationApplied: ")
        .append(toIndentedString(authenticationApplied))
        .append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    decision: ").append(toIndentedString(decision)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    paymentInstrumentId: ")
        .append(toIndentedString(paymentInstrumentId))
        .append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tokenLastFour: ").append(toIndentedString(tokenLastFour)).append("\n");
    sb.append("    tokenRequestor: ").append(toIndentedString(tokenRequestor)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validationFacts: ").append(toIndentedString(validationFacts)).append("\n");
    sb.append("    wallet: ").append(toIndentedString(wallet)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of NetworkTokenNotificationDataV2 given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of NetworkTokenNotificationDataV2
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     NetworkTokenNotificationDataV2
   */
  public static NetworkTokenNotificationDataV2 fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, NetworkTokenNotificationDataV2.class);
  }

  /**
   * Convert an instance of NetworkTokenNotificationDataV2 to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
