/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** TokenAuthentication */
@JsonPropertyOrder({
  TokenAuthentication.JSON_PROPERTY_METHOD,
  TokenAuthentication.JSON_PROPERTY_RESULT
})
public class TokenAuthentication {
  public static final String JSON_PROPERTY_METHOD = "method";
  private String method;

  public static final String JSON_PROPERTY_RESULT = "result";
  private String result;

  public TokenAuthentication() {}

  /**
   * The method used to complete the authentication process. Possible values: **sms_OTP**,
   * **email_OTP**.
   *
   * @param method The method used to complete the authentication process. Possible values:
   *     **sms_OTP**, **email_OTP**.
   * @return the current {@code TokenAuthentication} instance, allowing for method chaining
   */
  public TokenAuthentication method(String method) {
    this.method = method;
    return this;
  }

  /**
   * The method used to complete the authentication process. Possible values: **sms_OTP**,
   * **email_OTP**.
   *
   * @return method The method used to complete the authentication process. Possible values:
   *     **sms_OTP**, **email_OTP**.
   */
  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMethod() {
    return method;
  }

  /**
   * The method used to complete the authentication process. Possible values: **sms_OTP**,
   * **email_OTP**.
   *
   * @param method The method used to complete the authentication process. Possible values:
   *     **sms_OTP**, **email_OTP**.
   */
  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMethod(String method) {
    this.method = method;
  }

  /**
   * The result of the authentication process.
   *
   * @param result The result of the authentication process.
   * @return the current {@code TokenAuthentication} instance, allowing for method chaining
   */
  public TokenAuthentication result(String result) {
    this.result = result;
    return this;
  }

  /**
   * The result of the authentication process.
   *
   * @return result The result of the authentication process.
   */
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getResult() {
    return result;
  }

  /**
   * The result of the authentication process.
   *
   * @param result The result of the authentication process.
   */
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResult(String result) {
    this.result = result;
  }

  /** Return true if this TokenAuthentication object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TokenAuthentication tokenAuthentication = (TokenAuthentication) o;
    return Objects.equals(this.method, tokenAuthentication.method)
        && Objects.equals(this.result, tokenAuthentication.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(method, result);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TokenAuthentication {\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TokenAuthentication given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TokenAuthentication
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TokenAuthentication
   */
  public static TokenAuthentication fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TokenAuthentication.class);
  }

  /**
   * Convert an instance of TokenAuthentication to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
