/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** ValidationFacts */
@JsonPropertyOrder({
  ValidationFacts.JSON_PROPERTY_REASONS,
  ValidationFacts.JSON_PROPERTY_RESULT,
  ValidationFacts.JSON_PROPERTY_TYPE
})
public class ValidationFacts {
  public static final String JSON_PROPERTY_REASONS = "reasons";
  private List<String> reasons;

  /**
   * The evaluation result of the validation facts. Possible values: **valid**, **invalid**,
   * **notValidated**, **notApplicable**.
   */
  public enum ResultEnum {
    INVALID(String.valueOf("invalid")),

    NOTAPPLICABLE(String.valueOf("notApplicable")),

    NOTVALIDATED(String.valueOf("notValidated")),

    VALID(String.valueOf("valid"));

    private static final Logger LOG = Logger.getLogger(ResultEnum.class.getName());

    private String value;

    ResultEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultEnum fromValue(String value) {
      for (ResultEnum b : ResultEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "ResultEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(ResultEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_RESULT = "result";
  private ResultEnum result;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public ValidationFacts() {}

  /**
   * The reason for the &#x60;result&#x60; of the validations. This field is only sent for
   * &#x60;validationFacts.type&#x60; **walletValidation**, when &#x60;validationFacts.result&#x60;
   * is **invalid**.
   *
   * @param reasons The reason for the &#x60;result&#x60; of the validations. This field is only
   *     sent for &#x60;validationFacts.type&#x60; **walletValidation**, when
   *     &#x60;validationFacts.result&#x60; is **invalid**.
   * @return the current {@code ValidationFacts} instance, allowing for method chaining
   */
  public ValidationFacts reasons(List<String> reasons) {
    this.reasons = reasons;
    return this;
  }

  public ValidationFacts addReasonsItem(String reasonsItem) {
    if (this.reasons == null) {
      this.reasons = new ArrayList<>();
    }
    this.reasons.add(reasonsItem);
    return this;
  }

  /**
   * The reason for the &#x60;result&#x60; of the validations. This field is only sent for
   * &#x60;validationFacts.type&#x60; **walletValidation**, when &#x60;validationFacts.result&#x60;
   * is **invalid**.
   *
   * @return reasons The reason for the &#x60;result&#x60; of the validations. This field is only
   *     sent for &#x60;validationFacts.type&#x60; **walletValidation**, when
   *     &#x60;validationFacts.result&#x60; is **invalid**.
   */
  @JsonProperty(JSON_PROPERTY_REASONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getReasons() {
    return reasons;
  }

  /**
   * The reason for the &#x60;result&#x60; of the validations. This field is only sent for
   * &#x60;validationFacts.type&#x60; **walletValidation**, when &#x60;validationFacts.result&#x60;
   * is **invalid**.
   *
   * @param reasons The reason for the &#x60;result&#x60; of the validations. This field is only
   *     sent for &#x60;validationFacts.type&#x60; **walletValidation**, when
   *     &#x60;validationFacts.result&#x60; is **invalid**.
   */
  @JsonProperty(JSON_PROPERTY_REASONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReasons(List<String> reasons) {
    this.reasons = reasons;
  }

  /**
   * The evaluation result of the validation facts. Possible values: **valid**, **invalid**,
   * **notValidated**, **notApplicable**.
   *
   * @param result The evaluation result of the validation facts. Possible values: **valid**,
   *     **invalid**, **notValidated**, **notApplicable**.
   * @return the current {@code ValidationFacts} instance, allowing for method chaining
   */
  public ValidationFacts result(ResultEnum result) {
    this.result = result;
    return this;
  }

  /**
   * The evaluation result of the validation facts. Possible values: **valid**, **invalid**,
   * **notValidated**, **notApplicable**.
   *
   * @return result The evaluation result of the validation facts. Possible values: **valid**,
   *     **invalid**, **notValidated**, **notApplicable**.
   */
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResultEnum getResult() {
    return result;
  }

  /**
   * The evaluation result of the validation facts. Possible values: **valid**, **invalid**,
   * **notValidated**, **notApplicable**.
   *
   * @param result The evaluation result of the validation facts. Possible values: **valid**,
   *     **invalid**, **notValidated**, **notApplicable**.
   */
  @JsonProperty(JSON_PROPERTY_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResult(ResultEnum result) {
    this.result = result;
  }

  /**
   * The type of the validation fact.
   *
   * @param type The type of the validation fact.
   * @return the current {@code ValidationFacts} instance, allowing for method chaining
   */
  public ValidationFacts type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the validation fact.
   *
   * @return type The type of the validation fact.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of the validation fact.
   *
   * @param type The type of the validation fact.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /** Return true if this ValidationFacts object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValidationFacts validationFacts = (ValidationFacts) o;
    return Objects.equals(this.reasons, validationFacts.reasons)
        && Objects.equals(this.result, validationFacts.result)
        && Objects.equals(this.type, validationFacts.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reasons, result, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ValidationFacts {\n");
    sb.append("    reasons: ").append(toIndentedString(reasons)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ValidationFacts given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ValidationFacts
   * @throws JsonProcessingException if the JSON string is invalid with respect to ValidationFacts
   */
  public static ValidationFacts fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ValidationFacts.class);
  }

  /**
   * Convert an instance of ValidationFacts to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
