/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.configurationwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** Wallet */
@JsonPropertyOrder({
  Wallet.JSON_PROPERTY_ACCOUNT_SCORE,
  Wallet.JSON_PROPERTY_DEVICE,
  Wallet.JSON_PROPERTY_DEVICE_SCORE,
  Wallet.JSON_PROPERTY_PROVISIONING_METHOD,
  Wallet.JSON_PROPERTY_RECOMMENDATION_REASONS,
  Wallet.JSON_PROPERTY_TYPE
})
public class Wallet {
  public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
  private String accountScore;

  public static final String JSON_PROPERTY_DEVICE = "device";
  private Device device;

  public static final String JSON_PROPERTY_DEVICE_SCORE = "deviceScore";
  private String deviceScore;

  public static final String JSON_PROPERTY_PROVISIONING_METHOD = "provisioningMethod";
  private String provisioningMethod;

  /** Gets or Sets recommendationReasons */
  public enum RecommendationReasonsEnum {
    ACCOUNTCARDTOONEW(String.valueOf("accountCardTooNew")),

    ACCOUNTHIGHRISK(String.valueOf("accountHighRisk")),

    ACCOUNTRECENTLYCHANGED(String.valueOf("accountRecentlyChanged")),

    ACCOUNTTOONEW(String.valueOf("accountTooNew")),

    ACCOUNTTOONEWSINCELAUNCH(String.valueOf("accountTooNewSinceLaunch")),

    CARDHOLDERPANASSOCIATEDTOACCOUNTWITHINTHRESHOLDDAYS(
        String.valueOf("cardholderPanAssociatedToAccountWithinThresholdDays")),

    CHANGESMADETOACCOUNTDATAWITHINTHRESHOLDDAYS(
        String.valueOf("changesMadeToAccountDataWithinThresholdDays")),

    DEVICEPROVISIONINGLOCATIONOUTSIDEOFCARDHOLDERSWALLETACCOUNTHOMECOUNTRY(
        String.valueOf("deviceProvisioningLocationOutsideOfCardholdersWalletAccountHomeCountry")),

    DEVICERECENTLYLOST(String.valueOf("deviceRecentlyLost")),

    ENCRYPTEDPAYMENTINSTRUMENTDATAISBEINGPUSHEDBYTHEISSUERTOTHESAMEDEVICETHATISSUERAPPLICATIONAUTHENTICATEDBUTWITHSUCCESSFULUPFRONTAUTHENTICATION(
        String.valueOf(
            "encryptedPaymentInstrumentDataIsBeingPushedByTheIssuerToTheSameDeviceThatIssuerApplicationAuthenticatedButWithSuccessfulUpfrontAuthentication")),

    ENCRYPTEDPAYMENTINSTRUMENTDATAISBEINGPUSHEDBYTHEISSUERTOTHESAMEDEVICETHATISSUERAPPLICATIONAUTHENTICATEDBUTWITHOUTANYUPFRONTAUTHENTICATION(
        String.valueOf(
            "encryptedPaymentInstrumentDataIsBeingPushedByTheIssuerToTheSameDeviceThatIssuerApplicationAuthenticatedButWithoutAnyUpfrontAuthentication")),

    ENCRYPTEDPAYMENTINSTRUMENTDATAISPUSHEDTOADIFFERENTDEVICETHANTHEONETHATISSUERAPPLICATIONAUTHENTICATED(
        String.valueOf(
            "encryptedPaymentInstrumentDataIsPushedToADifferentDeviceThanTheOneThatIssuerApplicationAuthenticated")),

    ENCRYPTEDPAYMENTINSTRUMENTDATAISPUSHEDTOADIFFERENTUSERTHANTHECARDHOLDER(
        String.valueOf("encryptedPaymentInstrumentDataIsPushedToADifferentUserThanTheCardHolder")),

    HASSUSPENDEDTOKENS(String.valueOf("hasSuspendedTokens")),

    INACTIVEACCOUNT(String.valueOf("inactiveAccount")),

    ISSUERDEFERREDIDVDECISION(String.valueOf("issuerDeferredIDVDecision")),

    ISSUERENCRYPTEDPAYMENTINSTRUMENTDATAEXPIRED(
        String.valueOf("issuerEncryptedPaymentInstrumentDataExpired")),

    LOWACCOUNTSCORE(String.valueOf("lowAccountScore")),

    LOWDEVICESCORE(String.valueOf("lowDeviceScore")),

    LOWPHONENUMBERSCORE(String.valueOf("lowPhoneNumberScore")),

    NUMBEROFACTIVETOKENSGREATERTHANTHRESHOLD(
        String.valueOf("numberOfActiveTokensGreaterThanThreshold")),

    NUMBEROFACTIVETOKENSONALLDEVICESISGREATERTHANTHRESHOLD(
        String.valueOf("numberOfActiveTokensOnAllDevicesIsGreaterThanThreshold")),

    NUMBEROFDAYSSINCEDEVICEWASLASTREPORTEDLOSTISLESSTHANTHRESHOLDDAYS(
        String.valueOf("numberOfDaysSinceDeviceWasLastReportedLostIsLessThanThresholdDays")),

    NUMBEROFDEVICESWITHSAMEUSERIDWITHTOKENISGREATERTHANTHRESHOLD(
        String.valueOf("numberOfDevicesWithSameUseridWithTokenIsGreaterThanThreshold")),

    NUMBEROFTRANSACTIONSINLAST12MONTHSLESSTHANTHRESHOLDNUMBER(
        String.valueOf("numberOfTransactionsInLast12MonthsLessThanThresholdNumber")),

    OUTSIDEHOMETERRITORY(String.valueOf("outSideHomeTerritory")),

    SUSPENDEDCARDSINTHEWALLETACCOUNTISGREATERTHANTHRESHOLD(
        String.valueOf("suspendedCardsInTheWALLETAccountIsGreaterThanThreshold")),

    SUSPICIOUSACTIVITY(String.valueOf("suspiciousActivity")),

    THENUMBEROFPROVISIONINGATTEMPTSACROSSALLCARDSONTHISDEVICEINTHELAST24HOURSEXCEEDSTHETHRESHOLD(
        String.valueOf(
            "theNumberOfProvisioningAttemptsAcrossAllCardsOnThisDeviceInTheLast24HoursExceedsTheThreshold")),

    THEWALLETACCOUNTINTOWHICHTHECARDISBEINGPROVISIONEDCONTAINDISTINCTNAMESGREATERTHANTHRESHOLD(
        String.valueOf(
            "theWALLETAccountIntoWhichTheCardIsBeingProvisionedContainDistinctNamesGreaterThanThreshold")),

    THISACCOUNTHASNOTHADACTIVITYWITHINTHRESHOLDPERIOD(
        String.valueOf("thisAccountHasNotHadActivityWithinThresholdPeriod")),

    TOOMANYDIFFERENTCARDHOLDERS(String.valueOf("tooManyDifferentCardholders")),

    TOOMANYRECENTATTEMPTS(String.valueOf("tooManyRecentAttempts")),

    TOOMANYRECENTTOKENS(String.valueOf("tooManyRecentTokens")),

    UNABLETOASSESS(String.valueOf("unableToAssess")),

    UNKNOWN(String.valueOf("unknown")),

    USERACCOUNTWASCREATEDWITHINTHRESHOLDDAYS(
        String.valueOf("userAccountWasCreatedWithinThresholdDays")),

    USERDEVICERECEIVINGENCRYPTEDPAYMENTINSTRUMENTDATAISDIFFERENTTHANTHEONETHATISPROVISIONINGTHETOKEN(
        String.valueOf(
            "userDeviceReceivingEncryptedPaymentInstrumentDataIsDifferentThanTheOneThatIsProvisioningTheToken")),

    USERSACCOUNTONDEVICELESSTHANTHRESHOLDDAYS(
        String.valueOf("usersAccountOnDeviceLessThanThresholdDays")),

    WALLETACCOUNTCREATEDWITHINTHRESHOLDDAYS(
        String.valueOf("walletAccountCreatedWithinThresholdDays")),

    WALLETACCOUNTHOLDERNAMEONFILEDOESNOTMATCHCARDHOLDERENTEREDNAME(
        String.valueOf("walletAccountHolderNameOnFileDoesNotMatchCardholderEnteredName"));

    private static final Logger LOG = Logger.getLogger(RecommendationReasonsEnum.class.getName());

    private String value;

    RecommendationReasonsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RecommendationReasonsEnum fromValue(String value) {
      for (RecommendationReasonsEnum b : RecommendationReasonsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "RecommendationReasonsEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(RecommendationReasonsEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_RECOMMENDATION_REASONS = "recommendationReasons";
  private List<RecommendationReasonsEnum> recommendationReasons;

  public static final String JSON_PROPERTY_TYPE = "type";
  @Deprecated // deprecated since Configuration webhooks v2: Use name of the `tokenRequestor`
  // instead.
  private String type;

  public Wallet() {}

  /**
   * The confidence score of the wallet account, calculated by the wallet provider. A high score
   * means that account is considered trustworthy. A low score means that the account is considered
   * suspicious. Possible values: **1** to **5**.
   *
   * @param accountScore The confidence score of the wallet account, calculated by the wallet
   *     provider. A high score means that account is considered trustworthy. A low score means that
   *     the account is considered suspicious. Possible values: **1** to **5**.
   * @return the current {@code Wallet} instance, allowing for method chaining
   */
  public Wallet accountScore(String accountScore) {
    this.accountScore = accountScore;
    return this;
  }

  /**
   * The confidence score of the wallet account, calculated by the wallet provider. A high score
   * means that account is considered trustworthy. A low score means that the account is considered
   * suspicious. Possible values: **1** to **5**.
   *
   * @return accountScore The confidence score of the wallet account, calculated by the wallet
   *     provider. A high score means that account is considered trustworthy. A low score means that
   *     the account is considered suspicious. Possible values: **1** to **5**.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountScore() {
    return accountScore;
  }

  /**
   * The confidence score of the wallet account, calculated by the wallet provider. A high score
   * means that account is considered trustworthy. A low score means that the account is considered
   * suspicious. Possible values: **1** to **5**.
   *
   * @param accountScore The confidence score of the wallet account, calculated by the wallet
   *     provider. A high score means that account is considered trustworthy. A low score means that
   *     the account is considered suspicious. Possible values: **1** to **5**.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountScore(String accountScore) {
    this.accountScore = accountScore;
  }

  /**
   * device
   *
   * @param device
   * @return the current {@code Wallet} instance, allowing for method chaining
   */
  public Wallet device(Device device) {
    this.device = device;
    return this;
  }

  /**
   * Get device
   *
   * @return device
   */
  @JsonProperty(JSON_PROPERTY_DEVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Device getDevice() {
    return device;
  }

  /**
   * device
   *
   * @param device
   */
  @JsonProperty(JSON_PROPERTY_DEVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDevice(Device device) {
    this.device = device;
  }

  /**
   * The confidence score of the device, calculated by the wallet provider. A high score means that
   * device is considered trustworthy. A low score means that the device is considered suspicious.
   * Possible values: **1** to **5**.
   *
   * @param deviceScore The confidence score of the device, calculated by the wallet provider. A
   *     high score means that device is considered trustworthy. A low score means that the device
   *     is considered suspicious. Possible values: **1** to **5**.
   * @return the current {@code Wallet} instance, allowing for method chaining
   */
  public Wallet deviceScore(String deviceScore) {
    this.deviceScore = deviceScore;
    return this;
  }

  /**
   * The confidence score of the device, calculated by the wallet provider. A high score means that
   * device is considered trustworthy. A low score means that the device is considered suspicious.
   * Possible values: **1** to **5**.
   *
   * @return deviceScore The confidence score of the device, calculated by the wallet provider. A
   *     high score means that device is considered trustworthy. A low score means that the device
   *     is considered suspicious. Possible values: **1** to **5**.
   */
  @JsonProperty(JSON_PROPERTY_DEVICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeviceScore() {
    return deviceScore;
  }

  /**
   * The confidence score of the device, calculated by the wallet provider. A high score means that
   * device is considered trustworthy. A low score means that the device is considered suspicious.
   * Possible values: **1** to **5**.
   *
   * @param deviceScore The confidence score of the device, calculated by the wallet provider. A
   *     high score means that device is considered trustworthy. A low score means that the device
   *     is considered suspicious. Possible values: **1** to **5**.
   */
  @JsonProperty(JSON_PROPERTY_DEVICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceScore(String deviceScore) {
    this.deviceScore = deviceScore;
  }

  /**
   * The method used for provisioning the network token. Possible values: **push**, **manual**.
   *
   * @param provisioningMethod The method used for provisioning the network token. Possible values:
   *     **push**, **manual**.
   * @return the current {@code Wallet} instance, allowing for method chaining
   */
  public Wallet provisioningMethod(String provisioningMethod) {
    this.provisioningMethod = provisioningMethod;
    return this;
  }

  /**
   * The method used for provisioning the network token. Possible values: **push**, **manual**.
   *
   * @return provisioningMethod The method used for provisioning the network token. Possible values:
   *     **push**, **manual**.
   */
  @JsonProperty(JSON_PROPERTY_PROVISIONING_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProvisioningMethod() {
    return provisioningMethod;
  }

  /**
   * The method used for provisioning the network token. Possible values: **push**, **manual**.
   *
   * @param provisioningMethod The method used for provisioning the network token. Possible values:
   *     **push**, **manual**.
   */
  @JsonProperty(JSON_PROPERTY_PROVISIONING_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvisioningMethod(String provisioningMethod) {
    this.provisioningMethod = provisioningMethod;
  }

  /**
   * A list of risk indicators triggered at the time of provisioning the network token. Some example
   * values of risk indicators are: * **accountTooNewSinceLaunch** * **tooManyRecentAttempts** *
   * **lowDeviceScore** * **lowAccountScore**
   *
   * @param recommendationReasons A list of risk indicators triggered at the time of provisioning
   *     the network token. Some example values of risk indicators are: *
   *     **accountTooNewSinceLaunch** * **tooManyRecentAttempts** * **lowDeviceScore** *
   *     **lowAccountScore**
   * @return the current {@code Wallet} instance, allowing for method chaining
   */
  public Wallet recommendationReasons(List<RecommendationReasonsEnum> recommendationReasons) {
    this.recommendationReasons = recommendationReasons;
    return this;
  }

  public Wallet addRecommendationReasonsItem(RecommendationReasonsEnum recommendationReasonsItem) {
    if (this.recommendationReasons == null) {
      this.recommendationReasons = new ArrayList<>();
    }
    this.recommendationReasons.add(recommendationReasonsItem);
    return this;
  }

  /**
   * A list of risk indicators triggered at the time of provisioning the network token. Some example
   * values of risk indicators are: * **accountTooNewSinceLaunch** * **tooManyRecentAttempts** *
   * **lowDeviceScore** * **lowAccountScore**
   *
   * @return recommendationReasons A list of risk indicators triggered at the time of provisioning
   *     the network token. Some example values of risk indicators are: *
   *     **accountTooNewSinceLaunch** * **tooManyRecentAttempts** * **lowDeviceScore** *
   *     **lowAccountScore**
   */
  @JsonProperty(JSON_PROPERTY_RECOMMENDATION_REASONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<RecommendationReasonsEnum> getRecommendationReasons() {
    return recommendationReasons;
  }

  /**
   * A list of risk indicators triggered at the time of provisioning the network token. Some example
   * values of risk indicators are: * **accountTooNewSinceLaunch** * **tooManyRecentAttempts** *
   * **lowDeviceScore** * **lowAccountScore**
   *
   * @param recommendationReasons A list of risk indicators triggered at the time of provisioning
   *     the network token. Some example values of risk indicators are: *
   *     **accountTooNewSinceLaunch** * **tooManyRecentAttempts** * **lowDeviceScore** *
   *     **lowAccountScore**
   */
  @JsonProperty(JSON_PROPERTY_RECOMMENDATION_REASONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecommendationReasons(List<RecommendationReasonsEnum> recommendationReasons) {
    this.recommendationReasons = recommendationReasons;
  }

  /**
   * The type of wallet that the network token is associated with. Possible values: **applePay**,
   * **googlePay**, **garminPay**.
   *
   * @param type The type of wallet that the network token is associated with. Possible values:
   *     **applePay**, **googlePay**, **garminPay**.
   * @return the current {@code Wallet} instance, allowing for method chaining
   * @deprecated since Configuration webhooks v2 Use name of the &#x60;tokenRequestor&#x60; instead.
   */
  @Deprecated // deprecated since Configuration webhooks v2: Use name of the `tokenRequestor`
  // instead.
  public Wallet type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of wallet that the network token is associated with. Possible values: **applePay**,
   * **googlePay**, **garminPay**.
   *
   * @return type The type of wallet that the network token is associated with. Possible values:
   *     **applePay**, **googlePay**, **garminPay**.
   * @deprecated // deprecated since Configuration webhooks v2: Use name of the `tokenRequestor`
   *     instead.
   */
  @Deprecated // deprecated since Configuration webhooks v2: Use name of the `tokenRequestor`
  // instead.
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of wallet that the network token is associated with. Possible values: **applePay**,
   * **googlePay**, **garminPay**.
   *
   * @param type The type of wallet that the network token is associated with. Possible values:
   *     **applePay**, **googlePay**, **garminPay**.
   * @deprecated since Configuration webhooks v2 Use name of the &#x60;tokenRequestor&#x60; instead.
   */
  @Deprecated // deprecated since Configuration webhooks v2: Use name of the `tokenRequestor`
  // instead.
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /** Return true if this Wallet object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Wallet wallet = (Wallet) o;
    return Objects.equals(this.accountScore, wallet.accountScore)
        && Objects.equals(this.device, wallet.device)
        && Objects.equals(this.deviceScore, wallet.deviceScore)
        && Objects.equals(this.provisioningMethod, wallet.provisioningMethod)
        && Objects.equals(this.recommendationReasons, wallet.recommendationReasons)
        && Objects.equals(this.type, wallet.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountScore, device, deviceScore, provisioningMethod, recommendationReasons, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Wallet {\n");
    sb.append("    accountScore: ").append(toIndentedString(accountScore)).append("\n");
    sb.append("    device: ").append(toIndentedString(device)).append("\n");
    sb.append("    deviceScore: ").append(toIndentedString(deviceScore)).append("\n");
    sb.append("    provisioningMethod: ").append(toIndentedString(provisioningMethod)).append("\n");
    sb.append("    recommendationReasons: ")
        .append(toIndentedString(recommendationReasons))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Wallet given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Wallet
   * @throws JsonProcessingException if the JSON string is invalid with respect to Wallet
   */
  public static Wallet fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Wallet.class);
  }

  /**
   * Convert an instance of Wallet to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
