/*
 * Disputes API
 *
 * The version of the OpenAPI document: 30
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.disputes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.List;

/** SupplyDefenseDocumentRequest */
@JsonPropertyOrder({
  SupplyDefenseDocumentRequest.JSON_PROPERTY_DEFENSE_DOCUMENTS,
  SupplyDefenseDocumentRequest.JSON_PROPERTY_DISPUTE_PSP_REFERENCE,
  SupplyDefenseDocumentRequest.JSON_PROPERTY_MERCHANT_ACCOUNT_CODE
})
public class SupplyDefenseDocumentRequest {
  public static final String JSON_PROPERTY_DEFENSE_DOCUMENTS = "defenseDocuments";
  private List<DefenseDocument> defenseDocuments;

  public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
  private String disputePspReference;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
  private String merchantAccountCode;

  public SupplyDefenseDocumentRequest() {}

  /**
   * An array containing a list of the defense documents.
   *
   * @param defenseDocuments An array containing a list of the defense documents.
   * @return the current {@code SupplyDefenseDocumentRequest} instance, allowing for method chaining
   */
  public SupplyDefenseDocumentRequest defenseDocuments(List<DefenseDocument> defenseDocuments) {
    this.defenseDocuments = defenseDocuments;
    return this;
  }

  public SupplyDefenseDocumentRequest addDefenseDocumentsItem(
      DefenseDocument defenseDocumentsItem) {
    if (this.defenseDocuments == null) {
      this.defenseDocuments = new ArrayList<>();
    }
    this.defenseDocuments.add(defenseDocumentsItem);
    return this;
  }

  /**
   * An array containing a list of the defense documents.
   *
   * @return defenseDocuments An array containing a list of the defense documents.
   */
  @JsonProperty(JSON_PROPERTY_DEFENSE_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<DefenseDocument> getDefenseDocuments() {
    return defenseDocuments;
  }

  /**
   * An array containing a list of the defense documents.
   *
   * @param defenseDocuments An array containing a list of the defense documents.
   */
  @JsonProperty(JSON_PROPERTY_DEFENSE_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefenseDocuments(List<DefenseDocument> defenseDocuments) {
    this.defenseDocuments = defenseDocuments;
  }

  /**
   * The PSP reference assigned to the dispute.
   *
   * @param disputePspReference The PSP reference assigned to the dispute.
   * @return the current {@code SupplyDefenseDocumentRequest} instance, allowing for method chaining
   */
  public SupplyDefenseDocumentRequest disputePspReference(String disputePspReference) {
    this.disputePspReference = disputePspReference;
    return this;
  }

  /**
   * The PSP reference assigned to the dispute.
   *
   * @return disputePspReference The PSP reference assigned to the dispute.
   */
  @JsonProperty(JSON_PROPERTY_DISPUTE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDisputePspReference() {
    return disputePspReference;
  }

  /**
   * The PSP reference assigned to the dispute.
   *
   * @param disputePspReference The PSP reference assigned to the dispute.
   */
  @JsonProperty(JSON_PROPERTY_DISPUTE_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisputePspReference(String disputePspReference) {
    this.disputePspReference = disputePspReference;
  }

  /**
   * The merchant account identifier, for which you want to process the dispute transaction.
   *
   * @param merchantAccountCode The merchant account identifier, for which you want to process the
   *     dispute transaction.
   * @return the current {@code SupplyDefenseDocumentRequest} instance, allowing for method chaining
   */
  public SupplyDefenseDocumentRequest merchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
    return this;
  }

  /**
   * The merchant account identifier, for which you want to process the dispute transaction.
   *
   * @return merchantAccountCode The merchant account identifier, for which you want to process the
   *     dispute transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccountCode() {
    return merchantAccountCode;
  }

  /**
   * The merchant account identifier, for which you want to process the dispute transaction.
   *
   * @param merchantAccountCode The merchant account identifier, for which you want to process the
   *     dispute transaction.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
  }

  /** Return true if this SupplyDefenseDocumentRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupplyDefenseDocumentRequest supplyDefenseDocumentRequest = (SupplyDefenseDocumentRequest) o;
    return Objects.equals(this.defenseDocuments, supplyDefenseDocumentRequest.defenseDocuments)
        && Objects.equals(
            this.disputePspReference, supplyDefenseDocumentRequest.disputePspReference)
        && Objects.equals(
            this.merchantAccountCode, supplyDefenseDocumentRequest.merchantAccountCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defenseDocuments, disputePspReference, merchantAccountCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupplyDefenseDocumentRequest {\n");
    sb.append("    defenseDocuments: ").append(toIndentedString(defenseDocuments)).append("\n");
    sb.append("    disputePspReference: ")
        .append(toIndentedString(disputePspReference))
        .append("\n");
    sb.append("    merchantAccountCode: ")
        .append(toIndentedString(merchantAccountCode))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of SupplyDefenseDocumentRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SupplyDefenseDocumentRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     SupplyDefenseDocumentRequest
   */
  public static SupplyDefenseDocumentRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SupplyDefenseDocumentRequest.class);
  }

  /**
   * Convert an instance of SupplyDefenseDocumentRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
