/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.legalentitymanagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** TermsOfServiceAcceptanceInfo */
@JsonPropertyOrder({
  TermsOfServiceAcceptanceInfo.JSON_PROPERTY_ACCEPTED_BY,
  TermsOfServiceAcceptanceInfo.JSON_PROPERTY_ACCEPTED_FOR,
  TermsOfServiceAcceptanceInfo.JSON_PROPERTY_CREATED_AT,
  TermsOfServiceAcceptanceInfo.JSON_PROPERTY_ID,
  TermsOfServiceAcceptanceInfo.JSON_PROPERTY_TYPE,
  TermsOfServiceAcceptanceInfo.JSON_PROPERTY_VALID_TO
})
public class TermsOfServiceAcceptanceInfo {
  public static final String JSON_PROPERTY_ACCEPTED_BY = "acceptedBy";
  private String acceptedBy;

  public static final String JSON_PROPERTY_ACCEPTED_FOR = "acceptedFor";
  private String acceptedFor;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   */
  public enum TypeEnum {
    ADYENACCOUNT(String.valueOf("adyenAccount")),

    ADYENCAPITAL(String.valueOf("adyenCapital")),

    ADYENCARD(String.valueOf("adyenCard")),

    ADYENCHARGECARD(String.valueOf("adyenChargeCard")),

    ADYENFORPLATFORMSADVANCED(String.valueOf("adyenForPlatformsAdvanced")),

    ADYENFORPLATFORMSMANAGE(String.valueOf("adyenForPlatformsManage")),

    ADYENFRANCHISEE(String.valueOf("adyenFranchisee")),

    ADYENISSUING(String.valueOf("adyenIssuing")),

    ADYENPCCR(String.valueOf("adyenPccr")),

    KYCONINVITE(String.valueOf("kycOnInvite"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VALID_TO = "validTo";
  private OffsetDateTime validTo;

  public TermsOfServiceAcceptanceInfo() {}

  /**
   * The unique identifier of the user that accepted the Terms of Service.
   *
   * @param acceptedBy The unique identifier of the user that accepted the Terms of Service.
   * @return the current {@code TermsOfServiceAcceptanceInfo} instance, allowing for method chaining
   */
  public TermsOfServiceAcceptanceInfo acceptedBy(String acceptedBy) {
    this.acceptedBy = acceptedBy;
    return this;
  }

  /**
   * The unique identifier of the user that accepted the Terms of Service.
   *
   * @return acceptedBy The unique identifier of the user that accepted the Terms of Service.
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcceptedBy() {
    return acceptedBy;
  }

  /**
   * The unique identifier of the user that accepted the Terms of Service.
   *
   * @param acceptedBy The unique identifier of the user that accepted the Terms of Service.
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcceptedBy(String acceptedBy) {
    this.acceptedBy = acceptedBy;
  }

  /**
   * The unique identifier of the legal entity for which the Terms of Service are accepted.
   *
   * @param acceptedFor The unique identifier of the legal entity for which the Terms of Service are
   *     accepted.
   * @return the current {@code TermsOfServiceAcceptanceInfo} instance, allowing for method chaining
   */
  public TermsOfServiceAcceptanceInfo acceptedFor(String acceptedFor) {
    this.acceptedFor = acceptedFor;
    return this;
  }

  /**
   * The unique identifier of the legal entity for which the Terms of Service are accepted.
   *
   * @return acceptedFor The unique identifier of the legal entity for which the Terms of Service
   *     are accepted.
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_FOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcceptedFor() {
    return acceptedFor;
  }

  /**
   * The unique identifier of the legal entity for which the Terms of Service are accepted.
   *
   * @param acceptedFor The unique identifier of the legal entity for which the Terms of Service are
   *     accepted.
   */
  @JsonProperty(JSON_PROPERTY_ACCEPTED_FOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcceptedFor(String acceptedFor) {
    this.acceptedFor = acceptedFor;
  }

  /**
   * The date when the Terms of Service were accepted, in ISO 8601 extended format. For example,
   * 2022-12-18T10:15:30+01:00.
   *
   * @param createdAt The date when the Terms of Service were accepted, in ISO 8601 extended format.
   *     For example, 2022-12-18T10:15:30+01:00.
   * @return the current {@code TermsOfServiceAcceptanceInfo} instance, allowing for method chaining
   */
  public TermsOfServiceAcceptanceInfo createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * The date when the Terms of Service were accepted, in ISO 8601 extended format. For example,
   * 2022-12-18T10:15:30+01:00.
   *
   * @return createdAt The date when the Terms of Service were accepted, in ISO 8601 extended
   *     format. For example, 2022-12-18T10:15:30+01:00.
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * The date when the Terms of Service were accepted, in ISO 8601 extended format. For example,
   * 2022-12-18T10:15:30+01:00.
   *
   * @param createdAt The date when the Terms of Service were accepted, in ISO 8601 extended format.
   *     For example, 2022-12-18T10:15:30+01:00.
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  /**
   * An Adyen-generated reference for the accepted Terms of Service.
   *
   * @param id An Adyen-generated reference for the accepted Terms of Service.
   * @return the current {@code TermsOfServiceAcceptanceInfo} instance, allowing for method chaining
   */
  public TermsOfServiceAcceptanceInfo id(String id) {
    this.id = id;
    return this;
  }

  /**
   * An Adyen-generated reference for the accepted Terms of Service.
   *
   * @return id An Adyen-generated reference for the accepted Terms of Service.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * An Adyen-generated reference for the accepted Terms of Service.
   *
   * @param id An Adyen-generated reference for the accepted Terms of Service.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   *
   * @param type The type of Terms of Service. Possible values: * **adyenForPlatformsManage** *
   *     **adyenIssuing** * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** *
   *     **adyenCard** * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   * @return the current {@code TermsOfServiceAcceptanceInfo} instance, allowing for method chaining
   */
  public TermsOfServiceAcceptanceInfo type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   *
   * @return type The type of Terms of Service. Possible values: * **adyenForPlatformsManage** *
   *     **adyenIssuing** * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** *
   *     **adyenCard** * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of Terms of Service. Possible values: * **adyenForPlatformsManage** * **adyenIssuing**
   * * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** * **adyenCard** *
   * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   *
   * @param type The type of Terms of Service. Possible values: * **adyenForPlatformsManage** *
   *     **adyenIssuing** * **adyenForPlatformsAdvanced** * **adyenCapital** * **adyenAccount** *
   *     **adyenCard** * **adyenFranchisee** * **adyenPccr** * **adyenChargeCard** * **kycOnInvite**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * The expiration date for the Terms of Service acceptance, in ISO 8601 extended format. For
   * example, 2022-12-18T00:00:00+01:00.
   *
   * @param validTo The expiration date for the Terms of Service acceptance, in ISO 8601 extended
   *     format. For example, 2022-12-18T00:00:00+01:00.
   * @return the current {@code TermsOfServiceAcceptanceInfo} instance, allowing for method chaining
   */
  public TermsOfServiceAcceptanceInfo validTo(OffsetDateTime validTo) {
    this.validTo = validTo;
    return this;
  }

  /**
   * The expiration date for the Terms of Service acceptance, in ISO 8601 extended format. For
   * example, 2022-12-18T00:00:00+01:00.
   *
   * @return validTo The expiration date for the Terms of Service acceptance, in ISO 8601 extended
   *     format. For example, 2022-12-18T00:00:00+01:00.
   */
  @JsonProperty(JSON_PROPERTY_VALID_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getValidTo() {
    return validTo;
  }

  /**
   * The expiration date for the Terms of Service acceptance, in ISO 8601 extended format. For
   * example, 2022-12-18T00:00:00+01:00.
   *
   * @param validTo The expiration date for the Terms of Service acceptance, in ISO 8601 extended
   *     format. For example, 2022-12-18T00:00:00+01:00.
   */
  @JsonProperty(JSON_PROPERTY_VALID_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidTo(OffsetDateTime validTo) {
    this.validTo = validTo;
  }

  /** Return true if this TermsOfServiceAcceptanceInfo object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TermsOfServiceAcceptanceInfo termsOfServiceAcceptanceInfo = (TermsOfServiceAcceptanceInfo) o;
    return Objects.equals(this.acceptedBy, termsOfServiceAcceptanceInfo.acceptedBy)
        && Objects.equals(this.acceptedFor, termsOfServiceAcceptanceInfo.acceptedFor)
        && Objects.equals(this.createdAt, termsOfServiceAcceptanceInfo.createdAt)
        && Objects.equals(this.id, termsOfServiceAcceptanceInfo.id)
        && Objects.equals(this.type, termsOfServiceAcceptanceInfo.type)
        && Objects.equals(this.validTo, termsOfServiceAcceptanceInfo.validTo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acceptedBy, acceptedFor, createdAt, id, type, validTo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TermsOfServiceAcceptanceInfo {\n");
    sb.append("    acceptedBy: ").append(toIndentedString(acceptedBy)).append("\n");
    sb.append("    acceptedFor: ").append(toIndentedString(acceptedFor)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validTo: ").append(toIndentedString(validTo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TermsOfServiceAcceptanceInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TermsOfServiceAcceptanceInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TermsOfServiceAcceptanceInfo
   */
  public static TermsOfServiceAcceptanceInfo fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TermsOfServiceAcceptanceInfo.class);
  }

  /**
   * Convert an instance of TermsOfServiceAcceptanceInfo to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
