/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** PayAtTable */
@JsonPropertyOrder({
  PayAtTable.JSON_PROPERTY_AUTHENTICATION_METHOD,
  PayAtTable.JSON_PROPERTY_ENABLE_PAY_AT_TABLE,
  PayAtTable.JSON_PROPERTY_PAYMENT_INSTRUMENT
})
public class PayAtTable {
  /** Allowed authentication methods: Magswipe, Manual Entry. */
  public enum AuthenticationMethodEnum {
    MAGSWIPE(String.valueOf("MAGSWIPE")),

    MKE(String.valueOf("MKE"));

    private static final Logger LOG = Logger.getLogger(AuthenticationMethodEnum.class.getName());

    private String value;

    AuthenticationMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AuthenticationMethodEnum fromValue(String value) {
      for (AuthenticationMethodEnum b : AuthenticationMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "AuthenticationMethodEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(AuthenticationMethodEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_AUTHENTICATION_METHOD = "authenticationMethod";
  private AuthenticationMethodEnum authenticationMethod;

  public static final String JSON_PROPERTY_ENABLE_PAY_AT_TABLE = "enablePayAtTable";
  private Boolean enablePayAtTable;

  /**
   * Sets the allowed payment instrument for Pay at table transactions. Can be: **cash** or
   * **card**. If not set, the terminal presents both options.
   */
  public enum PaymentInstrumentEnum {
    CASH(String.valueOf("Cash")),

    CARD(String.valueOf("Card"));

    private static final Logger LOG = Logger.getLogger(PaymentInstrumentEnum.class.getName());

    private String value;

    PaymentInstrumentEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentInstrumentEnum fromValue(String value) {
      for (PaymentInstrumentEnum b : PaymentInstrumentEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "PaymentInstrumentEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(PaymentInstrumentEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT = "paymentInstrument";
  private PaymentInstrumentEnum paymentInstrument;

  public PayAtTable() {}

  /**
   * Allowed authentication methods: Magswipe, Manual Entry.
   *
   * @param authenticationMethod Allowed authentication methods: Magswipe, Manual Entry.
   * @return the current {@code PayAtTable} instance, allowing for method chaining
   */
  public PayAtTable authenticationMethod(AuthenticationMethodEnum authenticationMethod) {
    this.authenticationMethod = authenticationMethod;
    return this;
  }

  /**
   * Allowed authentication methods: Magswipe, Manual Entry.
   *
   * @return authenticationMethod Allowed authentication methods: Magswipe, Manual Entry.
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AuthenticationMethodEnum getAuthenticationMethod() {
    return authenticationMethod;
  }

  /**
   * Allowed authentication methods: Magswipe, Manual Entry.
   *
   * @param authenticationMethod Allowed authentication methods: Magswipe, Manual Entry.
   */
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationMethod(AuthenticationMethodEnum authenticationMethod) {
    this.authenticationMethod = authenticationMethod;
  }

  /**
   * Enable Pay at table.
   *
   * @param enablePayAtTable Enable Pay at table.
   * @return the current {@code PayAtTable} instance, allowing for method chaining
   */
  public PayAtTable enablePayAtTable(Boolean enablePayAtTable) {
    this.enablePayAtTable = enablePayAtTable;
    return this;
  }

  /**
   * Enable Pay at table.
   *
   * @return enablePayAtTable Enable Pay at table.
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_AT_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnablePayAtTable() {
    return enablePayAtTable;
  }

  /**
   * Enable Pay at table.
   *
   * @param enablePayAtTable Enable Pay at table.
   */
  @JsonProperty(JSON_PROPERTY_ENABLE_PAY_AT_TABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnablePayAtTable(Boolean enablePayAtTable) {
    this.enablePayAtTable = enablePayAtTable;
  }

  /**
   * Sets the allowed payment instrument for Pay at table transactions. Can be: **cash** or
   * **card**. If not set, the terminal presents both options.
   *
   * @param paymentInstrument Sets the allowed payment instrument for Pay at table transactions. Can
   *     be: **cash** or **card**. If not set, the terminal presents both options.
   * @return the current {@code PayAtTable} instance, allowing for method chaining
   */
  public PayAtTable paymentInstrument(PaymentInstrumentEnum paymentInstrument) {
    this.paymentInstrument = paymentInstrument;
    return this;
  }

  /**
   * Sets the allowed payment instrument for Pay at table transactions. Can be: **cash** or
   * **card**. If not set, the terminal presents both options.
   *
   * @return paymentInstrument Sets the allowed payment instrument for Pay at table transactions.
   *     Can be: **cash** or **card**. If not set, the terminal presents both options.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaymentInstrumentEnum getPaymentInstrument() {
    return paymentInstrument;
  }

  /**
   * Sets the allowed payment instrument for Pay at table transactions. Can be: **cash** or
   * **card**. If not set, the terminal presents both options.
   *
   * @param paymentInstrument Sets the allowed payment instrument for Pay at table transactions. Can
   *     be: **cash** or **card**. If not set, the terminal presents both options.
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrument(PaymentInstrumentEnum paymentInstrument) {
    this.paymentInstrument = paymentInstrument;
  }

  /** Return true if this PayAtTable object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayAtTable payAtTable = (PayAtTable) o;
    return Objects.equals(this.authenticationMethod, payAtTable.authenticationMethod)
        && Objects.equals(this.enablePayAtTable, payAtTable.enablePayAtTable)
        && Objects.equals(this.paymentInstrument, payAtTable.paymentInstrument);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationMethod, enablePayAtTable, paymentInstrument);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayAtTable {\n");
    sb.append("    authenticationMethod: ")
        .append(toIndentedString(authenticationMethod))
        .append("\n");
    sb.append("    enablePayAtTable: ").append(toIndentedString(enablePayAtTable)).append("\n");
    sb.append("    paymentInstrument: ").append(toIndentedString(paymentInstrument)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PayAtTable given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PayAtTable
   * @throws JsonProcessingException if the JSON string is invalid with respect to PayAtTable
   */
  public static PayAtTable fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PayAtTable.class);
  }

  /**
   * Convert an instance of PayAtTable to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
