/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/** PaymentMethod */
@JsonPropertyOrder({
  PaymentMethod.JSON_PROPERTY_ACCEL,
  PaymentMethod.JSON_PROPERTY_AFFIRM,
  PaymentMethod.JSON_PROPERTY_AFTERPAY_TOUCH,
  PaymentMethod.JSON_PROPERTY_ALIPAY_PLUS,
  PaymentMethod.JSON_PROPERTY_ALLOWED,
  PaymentMethod.JSON_PROPERTY_AMEX,
  PaymentMethod.JSON_PROPERTY_APPLE_PAY,
  PaymentMethod.JSON_PROPERTY_BCMC,
  PaymentMethod.JSON_PROPERTY_BUSINESS_LINE_ID,
  PaymentMethod.JSON_PROPERTY_CARTES_BANCAIRES,
  PaymentMethod.JSON_PROPERTY_CLEARPAY,
  PaymentMethod.JSON_PROPERTY_COUNTRIES,
  PaymentMethod.JSON_PROPERTY_CUP,
  PaymentMethod.JSON_PROPERTY_CURRENCIES,
  PaymentMethod.JSON_PROPERTY_CUSTOM_ROUTING_FLAGS,
  PaymentMethod.JSON_PROPERTY_DINERS,
  PaymentMethod.JSON_PROPERTY_DISCOVER,
  PaymentMethod.JSON_PROPERTY_EFT_DIRECTDEBIT_C_A,
  PaymentMethod.JSON_PROPERTY_EFTPOS_AUSTRALIA,
  PaymentMethod.JSON_PROPERTY_ENABLED,
  PaymentMethod.JSON_PROPERTY_GIROCARD,
  PaymentMethod.JSON_PROPERTY_GOOGLE_PAY,
  PaymentMethod.JSON_PROPERTY_ID,
  PaymentMethod.JSON_PROPERTY_IDEAL,
  PaymentMethod.JSON_PROPERTY_INTERAC_CARD,
  PaymentMethod.JSON_PROPERTY_JCB,
  PaymentMethod.JSON_PROPERTY_KLARNA,
  PaymentMethod.JSON_PROPERTY_MAESTRO,
  PaymentMethod.JSON_PROPERTY_MAESTRO_USA,
  PaymentMethod.JSON_PROPERTY_MC,
  PaymentMethod.JSON_PROPERTY_MEAL_VOUCHER_F_R,
  PaymentMethod.JSON_PROPERTY_NYCE,
  PaymentMethod.JSON_PROPERTY_PAYBYBANK_PLAID,
  PaymentMethod.JSON_PROPERTY_PAYME,
  PaymentMethod.JSON_PROPERTY_PAYPAL,
  PaymentMethod.JSON_PROPERTY_PAYTO,
  PaymentMethod.JSON_PROPERTY_PULSE,
  PaymentMethod.JSON_PROPERTY_REFERENCE,
  PaymentMethod.JSON_PROPERTY_SHOPPER_INTERACTION,
  PaymentMethod.JSON_PROPERTY_SODEXO,
  PaymentMethod.JSON_PROPERTY_SOFORT,
  PaymentMethod.JSON_PROPERTY_STAR,
  PaymentMethod.JSON_PROPERTY_STORE_IDS,
  PaymentMethod.JSON_PROPERTY_SWISH,
  PaymentMethod.JSON_PROPERTY_TICKET,
  PaymentMethod.JSON_PROPERTY_TWINT,
  PaymentMethod.JSON_PROPERTY_TYPE,
  PaymentMethod.JSON_PROPERTY_VERIFICATION_STATUS,
  PaymentMethod.JSON_PROPERTY_VIPPS,
  PaymentMethod.JSON_PROPERTY_VISA,
  PaymentMethod.JSON_PROPERTY_WECHATPAY,
  PaymentMethod.JSON_PROPERTY_WECHATPAY_POS
})
public class PaymentMethod {
  public static final String JSON_PROPERTY_ACCEL = "accel";
  private AccelInfo accel;

  public static final String JSON_PROPERTY_AFFIRM = "affirm";
  private AffirmInfo affirm;

  public static final String JSON_PROPERTY_AFTERPAY_TOUCH = "afterpayTouch";
  private AfterpayTouchInfo afterpayTouch;

  public static final String JSON_PROPERTY_ALIPAY_PLUS = "alipayPlus";
  private AlipayPlusInfo alipayPlus;

  public static final String JSON_PROPERTY_ALLOWED = "allowed";
  private Boolean allowed;

  public static final String JSON_PROPERTY_AMEX = "amex";
  private AmexInfo amex;

  public static final String JSON_PROPERTY_APPLE_PAY = "applePay";
  private ApplePayInfo applePay;

  public static final String JSON_PROPERTY_BCMC = "bcmc";
  private BcmcInfo bcmc;

  public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
  private String businessLineId;

  public static final String JSON_PROPERTY_CARTES_BANCAIRES = "cartesBancaires";
  private CartesBancairesInfo cartesBancaires;

  public static final String JSON_PROPERTY_CLEARPAY = "clearpay";
  private ClearpayInfo clearpay;

  public static final String JSON_PROPERTY_COUNTRIES = "countries";
  private List<String> countries;

  public static final String JSON_PROPERTY_CUP = "cup";
  private GenericPmWithTdiInfo cup;

  public static final String JSON_PROPERTY_CURRENCIES = "currencies";
  private List<String> currencies;

  public static final String JSON_PROPERTY_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
  private List<String> customRoutingFlags;

  public static final String JSON_PROPERTY_DINERS = "diners";
  private DinersInfo diners;

  public static final String JSON_PROPERTY_DISCOVER = "discover";
  private GenericPmWithTdiInfo discover;

  public static final String JSON_PROPERTY_EFT_DIRECTDEBIT_C_A = "eft_directdebit_CA";
  private GenericPmWithTdiInfo eftDirectdebitCA;

  public static final String JSON_PROPERTY_EFTPOS_AUSTRALIA = "eftpos_australia";
  private GenericPmWithTdiInfo eftposAustralia;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_GIROCARD = "girocard";
  private GenericPmWithTdiInfo girocard;

  public static final String JSON_PROPERTY_GOOGLE_PAY = "googlePay";
  private GooglePayInfo googlePay;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_IDEAL = "ideal";
  private GenericPmWithTdiInfo ideal;

  public static final String JSON_PROPERTY_INTERAC_CARD = "interac_card";
  private GenericPmWithTdiInfo interacCard;

  public static final String JSON_PROPERTY_JCB = "jcb";
  private JCBInfo jcb;

  public static final String JSON_PROPERTY_KLARNA = "klarna";
  private KlarnaInfo klarna;

  public static final String JSON_PROPERTY_MAESTRO = "maestro";
  private GenericPmWithTdiInfo maestro;

  public static final String JSON_PROPERTY_MAESTRO_USA = "maestro_usa";
  private GenericPmWithTdiInfo maestroUsa;

  public static final String JSON_PROPERTY_MC = "mc";
  private GenericPmWithTdiInfo mc;

  public static final String JSON_PROPERTY_MEAL_VOUCHER_F_R = "mealVoucher_FR";
  private MealVoucherFRInfo mealVoucherFR;

  public static final String JSON_PROPERTY_NYCE = "nyce";
  private NyceInfo nyce;

  public static final String JSON_PROPERTY_PAYBYBANK_PLAID = "paybybank_plaid";
  private PayByBankPlaidInfo paybybankPlaid;

  public static final String JSON_PROPERTY_PAYME = "payme";
  private PayMeInfo payme;

  public static final String JSON_PROPERTY_PAYPAL = "paypal";
  private PayPalInfo paypal;

  public static final String JSON_PROPERTY_PAYTO = "payto";
  private PayToInfo payto;

  public static final String JSON_PROPERTY_PULSE = "pulse";
  private PulseInfo pulse;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private String shopperInteraction;

  public static final String JSON_PROPERTY_SODEXO = "sodexo";
  private SodexoInfo sodexo;

  public static final String JSON_PROPERTY_SOFORT = "sofort";
  private SofortInfo sofort;

  public static final String JSON_PROPERTY_STAR = "star";
  private StarInfo star;

  public static final String JSON_PROPERTY_STORE_IDS = "storeIds";
  private List<String> storeIds;

  public static final String JSON_PROPERTY_SWISH = "swish";
  private SwishInfo swish;

  public static final String JSON_PROPERTY_TICKET = "ticket";
  private TicketInfo ticket;

  public static final String JSON_PROPERTY_TWINT = "twint";
  private TwintInfo twint;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  /**
   * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
   */
  public enum VerificationStatusEnum {
    VALID(String.valueOf("valid")),

    PENDING(String.valueOf("pending")),

    INVALID(String.valueOf("invalid")),

    REJECTED(String.valueOf("rejected"));

    private static final Logger LOG = Logger.getLogger(VerificationStatusEnum.class.getName());

    private String value;

    VerificationStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VerificationStatusEnum fromValue(String value) {
      for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "VerificationStatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(VerificationStatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
  private VerificationStatusEnum verificationStatus;

  public static final String JSON_PROPERTY_VIPPS = "vipps";
  private VippsInfo vipps;

  public static final String JSON_PROPERTY_VISA = "visa";
  private GenericPmWithTdiInfo visa;

  public static final String JSON_PROPERTY_WECHATPAY = "wechatpay";
  private WeChatPayInfo wechatpay;

  public static final String JSON_PROPERTY_WECHATPAY_POS = "wechatpay_pos";
  private WeChatPayPosInfo wechatpayPos;

  public PaymentMethod() {}

  /**
   * accel
   *
   * @param accel
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod accel(AccelInfo accel) {
    this.accel = accel;
    return this;
  }

  /**
   * Get accel
   *
   * @return accel
   */
  @JsonProperty(JSON_PROPERTY_ACCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AccelInfo getAccel() {
    return accel;
  }

  /**
   * accel
   *
   * @param accel
   */
  @JsonProperty(JSON_PROPERTY_ACCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccel(AccelInfo accel) {
    this.accel = accel;
  }

  /**
   * affirm
   *
   * @param affirm
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod affirm(AffirmInfo affirm) {
    this.affirm = affirm;
    return this;
  }

  /**
   * Get affirm
   *
   * @return affirm
   */
  @JsonProperty(JSON_PROPERTY_AFFIRM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AffirmInfo getAffirm() {
    return affirm;
  }

  /**
   * affirm
   *
   * @param affirm
   */
  @JsonProperty(JSON_PROPERTY_AFFIRM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAffirm(AffirmInfo affirm) {
    this.affirm = affirm;
  }

  /**
   * afterpayTouch
   *
   * @param afterpayTouch
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod afterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
    return this;
  }

  /**
   * Get afterpayTouch
   *
   * @return afterpayTouch
   */
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AfterpayTouchInfo getAfterpayTouch() {
    return afterpayTouch;
  }

  /**
   * afterpayTouch
   *
   * @param afterpayTouch
   */
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAfterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
  }

  /**
   * alipayPlus
   *
   * @param alipayPlus
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod alipayPlus(AlipayPlusInfo alipayPlus) {
    this.alipayPlus = alipayPlus;
    return this;
  }

  /**
   * Get alipayPlus
   *
   * @return alipayPlus
   */
  @JsonProperty(JSON_PROPERTY_ALIPAY_PLUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AlipayPlusInfo getAlipayPlus() {
    return alipayPlus;
  }

  /**
   * alipayPlus
   *
   * @param alipayPlus
   */
  @JsonProperty(JSON_PROPERTY_ALIPAY_PLUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlipayPlus(AlipayPlusInfo alipayPlus) {
    this.alipayPlus = alipayPlus;
  }

  /**
   * Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after
   * screening your merchant account.
   *
   * @param allowed Indicates whether receiving payments is allowed. This value is set to **true**
   *     by Adyen after screening your merchant account.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod allowed(Boolean allowed) {
    this.allowed = allowed;
    return this;
  }

  /**
   * Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after
   * screening your merchant account.
   *
   * @return allowed Indicates whether receiving payments is allowed. This value is set to **true**
   *     by Adyen after screening your merchant account.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowed() {
    return allowed;
  }

  /**
   * Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after
   * screening your merchant account.
   *
   * @param allowed Indicates whether receiving payments is allowed. This value is set to **true**
   *     by Adyen after screening your merchant account.
   */
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowed(Boolean allowed) {
    this.allowed = allowed;
  }

  /**
   * amex
   *
   * @param amex
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod amex(AmexInfo amex) {
    this.amex = amex;
    return this;
  }

  /**
   * Get amex
   *
   * @return amex
   */
  @JsonProperty(JSON_PROPERTY_AMEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AmexInfo getAmex() {
    return amex;
  }

  /**
   * amex
   *
   * @param amex
   */
  @JsonProperty(JSON_PROPERTY_AMEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmex(AmexInfo amex) {
    this.amex = amex;
  }

  /**
   * applePay
   *
   * @param applePay
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod applePay(ApplePayInfo applePay) {
    this.applePay = applePay;
    return this;
  }

  /**
   * Get applePay
   *
   * @return applePay
   */
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplePayInfo getApplePay() {
    return applePay;
  }

  /**
   * applePay
   *
   * @param applePay
   */
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplePay(ApplePayInfo applePay) {
    this.applePay = applePay;
  }

  /**
   * bcmc
   *
   * @param bcmc
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod bcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
    return this;
  }

  /**
   * Get bcmc
   *
   * @return bcmc
   */
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BcmcInfo getBcmc() {
    return bcmc;
  }

  /**
   * bcmc
   *
   * @param bcmc
   */
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
  }

  /**
   * The unique identifier of the business line. Required if you are a [platform
   * model](https://docs.adyen.com/platforms).
   *
   * @param businessLineId The unique identifier of the business line. Required if you are a
   *     [platform model](https://docs.adyen.com/platforms).
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod businessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
    return this;
  }

  /**
   * The unique identifier of the business line. Required if you are a [platform
   * model](https://docs.adyen.com/platforms).
   *
   * @return businessLineId The unique identifier of the business line. Required if you are a
   *     [platform model](https://docs.adyen.com/platforms).
   */
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBusinessLineId() {
    return businessLineId;
  }

  /**
   * The unique identifier of the business line. Required if you are a [platform
   * model](https://docs.adyen.com/platforms).
   *
   * @param businessLineId The unique identifier of the business line. Required if you are a
   *     [platform model](https://docs.adyen.com/platforms).
   */
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
  }

  /**
   * cartesBancaires
   *
   * @param cartesBancaires
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod cartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
    return this;
  }

  /**
   * Get cartesBancaires
   *
   * @return cartesBancaires
   */
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CartesBancairesInfo getCartesBancaires() {
    return cartesBancaires;
  }

  /**
   * cartesBancaires
   *
   * @param cartesBancaires
   */
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
  }

  /**
   * clearpay
   *
   * @param clearpay
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod clearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
    return this;
  }

  /**
   * Get clearpay
   *
   * @return clearpay
   */
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ClearpayInfo getClearpay() {
    return clearpay;
  }

  /**
   * clearpay
   *
   * @param clearpay
   */
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
  }

  /**
   * The list of countries where a payment method is available. By default, all countries supported
   * by the payment method.
   *
   * @param countries The list of countries where a payment method is available. By default, all
   *     countries supported by the payment method.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod countries(List<String> countries) {
    this.countries = countries;
    return this;
  }

  public PaymentMethod addCountriesItem(String countriesItem) {
    if (this.countries == null) {
      this.countries = new ArrayList<>();
    }
    this.countries.add(countriesItem);
    return this;
  }

  /**
   * The list of countries where a payment method is available. By default, all countries supported
   * by the payment method.
   *
   * @return countries The list of countries where a payment method is available. By default, all
   *     countries supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCountries() {
    return countries;
  }

  /**
   * The list of countries where a payment method is available. By default, all countries supported
   * by the payment method.
   *
   * @param countries The list of countries where a payment method is available. By default, all
   *     countries supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountries(List<String> countries) {
    this.countries = countries;
  }

  /**
   * cup
   *
   * @param cup
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod cup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
    return this;
  }

  /**
   * Get cup
   *
   * @return cup
   */
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getCup() {
    return cup;
  }

  /**
   * cup
   *
   * @param cup
   */
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
  }

  /**
   * The list of currencies that a payment method supports. By default, all currencies supported by
   * the payment method.
   *
   * @param currencies The list of currencies that a payment method supports. By default, all
   *     currencies supported by the payment method.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod currencies(List<String> currencies) {
    this.currencies = currencies;
    return this;
  }

  public PaymentMethod addCurrenciesItem(String currenciesItem) {
    if (this.currencies == null) {
      this.currencies = new ArrayList<>();
    }
    this.currencies.add(currenciesItem);
    return this;
  }

  /**
   * The list of currencies that a payment method supports. By default, all currencies supported by
   * the payment method.
   *
   * @return currencies The list of currencies that a payment method supports. By default, all
   *     currencies supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCurrencies() {
    return currencies;
  }

  /**
   * The list of currencies that a payment method supports. By default, all currencies supported by
   * the payment method.
   *
   * @param currencies The list of currencies that a payment method supports. By default, all
   *     currencies supported by the payment method.
   */
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencies(List<String> currencies) {
    this.currencies = currencies;
  }

  /**
   * The list of custom routing flags to route payment to the intended acquirer.
   *
   * @param customRoutingFlags The list of custom routing flags to route payment to the intended
   *     acquirer.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod customRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
    return this;
  }

  public PaymentMethod addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
    if (this.customRoutingFlags == null) {
      this.customRoutingFlags = new ArrayList<>();
    }
    this.customRoutingFlags.add(customRoutingFlagsItem);
    return this;
  }

  /**
   * The list of custom routing flags to route payment to the intended acquirer.
   *
   * @return customRoutingFlags The list of custom routing flags to route payment to the intended
   *     acquirer.
   */
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCustomRoutingFlags() {
    return customRoutingFlags;
  }

  /**
   * The list of custom routing flags to route payment to the intended acquirer.
   *
   * @param customRoutingFlags The list of custom routing flags to route payment to the intended
   *     acquirer.
   */
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
  }

  /**
   * diners
   *
   * @param diners
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod diners(DinersInfo diners) {
    this.diners = diners;
    return this;
  }

  /**
   * Get diners
   *
   * @return diners
   */
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DinersInfo getDiners() {
    return diners;
  }

  /**
   * diners
   *
   * @param diners
   */
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiners(DinersInfo diners) {
    this.diners = diners;
  }

  /**
   * discover
   *
   * @param discover
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod discover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
    return this;
  }

  /**
   * Get discover
   *
   * @return discover
   */
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getDiscover() {
    return discover;
  }

  /**
   * discover
   *
   * @param discover
   */
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
  }

  /**
   * eftDirectdebitCA
   *
   * @param eftDirectdebitCA
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod eftDirectdebitCA(GenericPmWithTdiInfo eftDirectdebitCA) {
    this.eftDirectdebitCA = eftDirectdebitCA;
    return this;
  }

  /**
   * Get eftDirectdebitCA
   *
   * @return eftDirectdebitCA
   */
  @JsonProperty(JSON_PROPERTY_EFT_DIRECTDEBIT_C_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getEftDirectdebitCA() {
    return eftDirectdebitCA;
  }

  /**
   * eftDirectdebitCA
   *
   * @param eftDirectdebitCA
   */
  @JsonProperty(JSON_PROPERTY_EFT_DIRECTDEBIT_C_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEftDirectdebitCA(GenericPmWithTdiInfo eftDirectdebitCA) {
    this.eftDirectdebitCA = eftDirectdebitCA;
  }

  /**
   * eftposAustralia
   *
   * @param eftposAustralia
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod eftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
    return this;
  }

  /**
   * Get eftposAustralia
   *
   * @return eftposAustralia
   */
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getEftposAustralia() {
    return eftposAustralia;
  }

  /**
   * eftposAustralia
   *
   * @param eftposAustralia
   */
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
  }

  /**
   * Indicates whether the payment method is enabled (**true**) or disabled (**false**).
   *
   * @param enabled Indicates whether the payment method is enabled (**true**) or disabled
   *     (**false**).
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Indicates whether the payment method is enabled (**true**) or disabled (**false**).
   *
   * @return enabled Indicates whether the payment method is enabled (**true**) or disabled
   *     (**false**).
   */
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * Indicates whether the payment method is enabled (**true**) or disabled (**false**).
   *
   * @param enabled Indicates whether the payment method is enabled (**true**) or disabled
   *     (**false**).
   */
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  /**
   * girocard
   *
   * @param girocard
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod girocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
    return this;
  }

  /**
   * Get girocard
   *
   * @return girocard
   */
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getGirocard() {
    return girocard;
  }

  /**
   * girocard
   *
   * @param girocard
   */
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGirocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
  }

  /**
   * googlePay
   *
   * @param googlePay
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod googlePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
    return this;
  }

  /**
   * Get googlePay
   *
   * @return googlePay
   */
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GooglePayInfo getGooglePay() {
    return googlePay;
  }

  /**
   * googlePay
   *
   * @param googlePay
   */
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGooglePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
  }

  /**
   * The identifier of the resource.
   *
   * @param id The identifier of the resource.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The identifier of the resource.
   *
   * @return id The identifier of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The identifier of the resource.
   *
   * @param id The identifier of the resource.
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * ideal
   *
   * @param ideal
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod ideal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
    return this;
  }

  /**
   * Get ideal
   *
   * @return ideal
   */
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getIdeal() {
    return ideal;
  }

  /**
   * ideal
   *
   * @param ideal
   */
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdeal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
  }

  /**
   * interacCard
   *
   * @param interacCard
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod interacCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
    return this;
  }

  /**
   * Get interacCard
   *
   * @return interacCard
   */
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getInteracCard() {
    return interacCard;
  }

  /**
   * interacCard
   *
   * @param interacCard
   */
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInteracCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
  }

  /**
   * jcb
   *
   * @param jcb
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod jcb(JCBInfo jcb) {
    this.jcb = jcb;
    return this;
  }

  /**
   * Get jcb
   *
   * @return jcb
   */
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JCBInfo getJcb() {
    return jcb;
  }

  /**
   * jcb
   *
   * @param jcb
   */
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJcb(JCBInfo jcb) {
    this.jcb = jcb;
  }

  /**
   * klarna
   *
   * @param klarna
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod klarna(KlarnaInfo klarna) {
    this.klarna = klarna;
    return this;
  }

  /**
   * Get klarna
   *
   * @return klarna
   */
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public KlarnaInfo getKlarna() {
    return klarna;
  }

  /**
   * klarna
   *
   * @param klarna
   */
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKlarna(KlarnaInfo klarna) {
    this.klarna = klarna;
  }

  /**
   * maestro
   *
   * @param maestro
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod maestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
    return this;
  }

  /**
   * Get maestro
   *
   * @return maestro
   */
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getMaestro() {
    return maestro;
  }

  /**
   * maestro
   *
   * @param maestro
   */
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
  }

  /**
   * maestroUsa
   *
   * @param maestroUsa
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod maestroUsa(GenericPmWithTdiInfo maestroUsa) {
    this.maestroUsa = maestroUsa;
    return this;
  }

  /**
   * Get maestroUsa
   *
   * @return maestroUsa
   */
  @JsonProperty(JSON_PROPERTY_MAESTRO_USA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getMaestroUsa() {
    return maestroUsa;
  }

  /**
   * maestroUsa
   *
   * @param maestroUsa
   */
  @JsonProperty(JSON_PROPERTY_MAESTRO_USA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaestroUsa(GenericPmWithTdiInfo maestroUsa) {
    this.maestroUsa = maestroUsa;
  }

  /**
   * mc
   *
   * @param mc
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod mc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
    return this;
  }

  /**
   * Get mc
   *
   * @return mc
   */
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getMc() {
    return mc;
  }

  /**
   * mc
   *
   * @param mc
   */
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
  }

  /**
   * mealVoucherFR
   *
   * @param mealVoucherFR
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod mealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
    return this;
  }

  /**
   * Get mealVoucherFR
   *
   * @return mealVoucherFR
   */
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MealVoucherFRInfo getMealVoucherFR() {
    return mealVoucherFR;
  }

  /**
   * mealVoucherFR
   *
   * @param mealVoucherFR
   */
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
  }

  /**
   * nyce
   *
   * @param nyce
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod nyce(NyceInfo nyce) {
    this.nyce = nyce;
    return this;
  }

  /**
   * Get nyce
   *
   * @return nyce
   */
  @JsonProperty(JSON_PROPERTY_NYCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NyceInfo getNyce() {
    return nyce;
  }

  /**
   * nyce
   *
   * @param nyce
   */
  @JsonProperty(JSON_PROPERTY_NYCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNyce(NyceInfo nyce) {
    this.nyce = nyce;
  }

  /**
   * paybybankPlaid
   *
   * @param paybybankPlaid
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod paybybankPlaid(PayByBankPlaidInfo paybybankPlaid) {
    this.paybybankPlaid = paybybankPlaid;
    return this;
  }

  /**
   * Get paybybankPlaid
   *
   * @return paybybankPlaid
   */
  @JsonProperty(JSON_PROPERTY_PAYBYBANK_PLAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayByBankPlaidInfo getPaybybankPlaid() {
    return paybybankPlaid;
  }

  /**
   * paybybankPlaid
   *
   * @param paybybankPlaid
   */
  @JsonProperty(JSON_PROPERTY_PAYBYBANK_PLAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaybybankPlaid(PayByBankPlaidInfo paybybankPlaid) {
    this.paybybankPlaid = paybybankPlaid;
  }

  /**
   * payme
   *
   * @param payme
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod payme(PayMeInfo payme) {
    this.payme = payme;
    return this;
  }

  /**
   * Get payme
   *
   * @return payme
   */
  @JsonProperty(JSON_PROPERTY_PAYME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayMeInfo getPayme() {
    return payme;
  }

  /**
   * payme
   *
   * @param payme
   */
  @JsonProperty(JSON_PROPERTY_PAYME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayme(PayMeInfo payme) {
    this.payme = payme;
  }

  /**
   * paypal
   *
   * @param paypal
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod paypal(PayPalInfo paypal) {
    this.paypal = paypal;
    return this;
  }

  /**
   * Get paypal
   *
   * @return paypal
   */
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayPalInfo getPaypal() {
    return paypal;
  }

  /**
   * paypal
   *
   * @param paypal
   */
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaypal(PayPalInfo paypal) {
    this.paypal = paypal;
  }

  /**
   * payto
   *
   * @param payto
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod payto(PayToInfo payto) {
    this.payto = payto;
    return this;
  }

  /**
   * Get payto
   *
   * @return payto
   */
  @JsonProperty(JSON_PROPERTY_PAYTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PayToInfo getPayto() {
    return payto;
  }

  /**
   * payto
   *
   * @param payto
   */
  @JsonProperty(JSON_PROPERTY_PAYTO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayto(PayToInfo payto) {
    this.payto = payto;
  }

  /**
   * pulse
   *
   * @param pulse
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod pulse(PulseInfo pulse) {
    this.pulse = pulse;
    return this;
  }

  /**
   * Get pulse
   *
   * @return pulse
   */
  @JsonProperty(JSON_PROPERTY_PULSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PulseInfo getPulse() {
    return pulse;
  }

  /**
   * pulse
   *
   * @param pulse
   */
  @JsonProperty(JSON_PROPERTY_PULSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPulse(PulseInfo pulse) {
    this.pulse = pulse;
  }

  /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   *
   * @param reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   *
   * @return reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getReference() {
    return reference;
  }

  /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   *
   * @param reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   */
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * The sales channel.
   *
   * @param shopperInteraction The sales channel.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod shopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

  /**
   * The sales channel.
   *
   * @return shopperInteraction The sales channel.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperInteraction() {
    return shopperInteraction;
  }

  /**
   * The sales channel.
   *
   * @param shopperInteraction The sales channel.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }

  /**
   * sodexo
   *
   * @param sodexo
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod sodexo(SodexoInfo sodexo) {
    this.sodexo = sodexo;
    return this;
  }

  /**
   * Get sodexo
   *
   * @return sodexo
   */
  @JsonProperty(JSON_PROPERTY_SODEXO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SodexoInfo getSodexo() {
    return sodexo;
  }

  /**
   * sodexo
   *
   * @param sodexo
   */
  @JsonProperty(JSON_PROPERTY_SODEXO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSodexo(SodexoInfo sodexo) {
    this.sodexo = sodexo;
  }

  /**
   * sofort
   *
   * @param sofort
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod sofort(SofortInfo sofort) {
    this.sofort = sofort;
    return this;
  }

  /**
   * Get sofort
   *
   * @return sofort
   */
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SofortInfo getSofort() {
    return sofort;
  }

  /**
   * sofort
   *
   * @param sofort
   */
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSofort(SofortInfo sofort) {
    this.sofort = sofort;
  }

  /**
   * star
   *
   * @param star
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod star(StarInfo star) {
    this.star = star;
    return this;
  }

  /**
   * Get star
   *
   * @return star
   */
  @JsonProperty(JSON_PROPERTY_STAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StarInfo getStar() {
    return star;
  }

  /**
   * star
   *
   * @param star
   */
  @JsonProperty(JSON_PROPERTY_STAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStar(StarInfo star) {
    this.star = star;
  }

  /**
   * The unique identifier of the store for which to configure the payment method, if any.
   *
   * @param storeIds The unique identifier of the store for which to configure the payment method,
   *     if any.
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod storeIds(List<String> storeIds) {
    this.storeIds = storeIds;
    return this;
  }

  public PaymentMethod addStoreIdsItem(String storeIdsItem) {
    if (this.storeIds == null) {
      this.storeIds = new ArrayList<>();
    }
    this.storeIds.add(storeIdsItem);
    return this;
  }

  /**
   * The unique identifier of the store for which to configure the payment method, if any.
   *
   * @return storeIds The unique identifier of the store for which to configure the payment method,
   *     if any.
   */
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getStoreIds() {
    return storeIds;
  }

  /**
   * The unique identifier of the store for which to configure the payment method, if any.
   *
   * @param storeIds The unique identifier of the store for which to configure the payment method,
   *     if any.
   */
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreIds(List<String> storeIds) {
    this.storeIds = storeIds;
  }

  /**
   * swish
   *
   * @param swish
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod swish(SwishInfo swish) {
    this.swish = swish;
    return this;
  }

  /**
   * Get swish
   *
   * @return swish
   */
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SwishInfo getSwish() {
    return swish;
  }

  /**
   * swish
   *
   * @param swish
   */
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSwish(SwishInfo swish) {
    this.swish = swish;
  }

  /**
   * ticket
   *
   * @param ticket
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod ticket(TicketInfo ticket) {
    this.ticket = ticket;
    return this;
  }

  /**
   * Get ticket
   *
   * @return ticket
   */
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TicketInfo getTicket() {
    return ticket;
  }

  /**
   * ticket
   *
   * @param ticket
   */
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTicket(TicketInfo ticket) {
    this.ticket = ticket;
  }

  /**
   * twint
   *
   * @param twint
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod twint(TwintInfo twint) {
    this.twint = twint;
    return this;
  }

  /**
   * Get twint
   *
   * @return twint
   */
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TwintInfo getTwint() {
    return twint;
  }

  /**
   * twint
   *
   * @param twint
   */
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwint(TwintInfo twint) {
    this.twint = twint;
  }

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   *
   * @param type Payment method
   *     [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   *
   * @return type Payment method
   *     [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * Payment method
   * [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   *
   * @param type Payment method
   *     [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
   *
   * @param verificationStatus Payment method status. Possible values: * **valid** * **pending** *
   *     **invalid** * **rejected**
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod verificationStatus(VerificationStatusEnum verificationStatus) {
    this.verificationStatus = verificationStatus;
    return this;
  }

  /**
   * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
   *
   * @return verificationStatus Payment method status. Possible values: * **valid** * **pending** *
   *     **invalid** * **rejected**
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VerificationStatusEnum getVerificationStatus() {
    return verificationStatus;
  }

  /**
   * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
   *
   * @param verificationStatus Payment method status. Possible values: * **valid** * **pending** *
   *     **invalid** * **rejected**
   */
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
    this.verificationStatus = verificationStatus;
  }

  /**
   * vipps
   *
   * @param vipps
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod vipps(VippsInfo vipps) {
    this.vipps = vipps;
    return this;
  }

  /**
   * Get vipps
   *
   * @return vipps
   */
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VippsInfo getVipps() {
    return vipps;
  }

  /**
   * vipps
   *
   * @param vipps
   */
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVipps(VippsInfo vipps) {
    this.vipps = vipps;
  }

  /**
   * visa
   *
   * @param visa
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod visa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
    return this;
  }

  /**
   * Get visa
   *
   * @return visa
   */
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GenericPmWithTdiInfo getVisa() {
    return visa;
  }

  /**
   * visa
   *
   * @param visa
   */
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
  }

  /**
   * wechatpay
   *
   * @param wechatpay
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod wechatpay(WeChatPayInfo wechatpay) {
    this.wechatpay = wechatpay;
    return this;
  }

  /**
   * Get wechatpay
   *
   * @return wechatpay
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WeChatPayInfo getWechatpay() {
    return wechatpay;
  }

  /**
   * wechatpay
   *
   * @param wechatpay
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWechatpay(WeChatPayInfo wechatpay) {
    this.wechatpay = wechatpay;
  }

  /**
   * wechatpayPos
   *
   * @param wechatpayPos
   * @return the current {@code PaymentMethod} instance, allowing for method chaining
   */
  public PaymentMethod wechatpayPos(WeChatPayPosInfo wechatpayPos) {
    this.wechatpayPos = wechatpayPos;
    return this;
  }

  /**
   * Get wechatpayPos
   *
   * @return wechatpayPos
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WeChatPayPosInfo getWechatpayPos() {
    return wechatpayPos;
  }

  /**
   * wechatpayPos
   *
   * @param wechatpayPos
   */
  @JsonProperty(JSON_PROPERTY_WECHATPAY_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWechatpayPos(WeChatPayPosInfo wechatpayPos) {
    this.wechatpayPos = wechatpayPos;
  }

  /** Return true if this PaymentMethod object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethod paymentMethod = (PaymentMethod) o;
    return Objects.equals(this.accel, paymentMethod.accel)
        && Objects.equals(this.affirm, paymentMethod.affirm)
        && Objects.equals(this.afterpayTouch, paymentMethod.afterpayTouch)
        && Objects.equals(this.alipayPlus, paymentMethod.alipayPlus)
        && Objects.equals(this.allowed, paymentMethod.allowed)
        && Objects.equals(this.amex, paymentMethod.amex)
        && Objects.equals(this.applePay, paymentMethod.applePay)
        && Objects.equals(this.bcmc, paymentMethod.bcmc)
        && Objects.equals(this.businessLineId, paymentMethod.businessLineId)
        && Objects.equals(this.cartesBancaires, paymentMethod.cartesBancaires)
        && Objects.equals(this.clearpay, paymentMethod.clearpay)
        && Objects.equals(this.countries, paymentMethod.countries)
        && Objects.equals(this.cup, paymentMethod.cup)
        && Objects.equals(this.currencies, paymentMethod.currencies)
        && Objects.equals(this.customRoutingFlags, paymentMethod.customRoutingFlags)
        && Objects.equals(this.diners, paymentMethod.diners)
        && Objects.equals(this.discover, paymentMethod.discover)
        && Objects.equals(this.eftDirectdebitCA, paymentMethod.eftDirectdebitCA)
        && Objects.equals(this.eftposAustralia, paymentMethod.eftposAustralia)
        && Objects.equals(this.enabled, paymentMethod.enabled)
        && Objects.equals(this.girocard, paymentMethod.girocard)
        && Objects.equals(this.googlePay, paymentMethod.googlePay)
        && Objects.equals(this.id, paymentMethod.id)
        && Objects.equals(this.ideal, paymentMethod.ideal)
        && Objects.equals(this.interacCard, paymentMethod.interacCard)
        && Objects.equals(this.jcb, paymentMethod.jcb)
        && Objects.equals(this.klarna, paymentMethod.klarna)
        && Objects.equals(this.maestro, paymentMethod.maestro)
        && Objects.equals(this.maestroUsa, paymentMethod.maestroUsa)
        && Objects.equals(this.mc, paymentMethod.mc)
        && Objects.equals(this.mealVoucherFR, paymentMethod.mealVoucherFR)
        && Objects.equals(this.nyce, paymentMethod.nyce)
        && Objects.equals(this.paybybankPlaid, paymentMethod.paybybankPlaid)
        && Objects.equals(this.payme, paymentMethod.payme)
        && Objects.equals(this.paypal, paymentMethod.paypal)
        && Objects.equals(this.payto, paymentMethod.payto)
        && Objects.equals(this.pulse, paymentMethod.pulse)
        && Objects.equals(this.reference, paymentMethod.reference)
        && Objects.equals(this.shopperInteraction, paymentMethod.shopperInteraction)
        && Objects.equals(this.sodexo, paymentMethod.sodexo)
        && Objects.equals(this.sofort, paymentMethod.sofort)
        && Objects.equals(this.star, paymentMethod.star)
        && Objects.equals(this.storeIds, paymentMethod.storeIds)
        && Objects.equals(this.swish, paymentMethod.swish)
        && Objects.equals(this.ticket, paymentMethod.ticket)
        && Objects.equals(this.twint, paymentMethod.twint)
        && Objects.equals(this.type, paymentMethod.type)
        && Objects.equals(this.verificationStatus, paymentMethod.verificationStatus)
        && Objects.equals(this.vipps, paymentMethod.vipps)
        && Objects.equals(this.visa, paymentMethod.visa)
        && Objects.equals(this.wechatpay, paymentMethod.wechatpay)
        && Objects.equals(this.wechatpayPos, paymentMethod.wechatpayPos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accel,
        affirm,
        afterpayTouch,
        alipayPlus,
        allowed,
        amex,
        applePay,
        bcmc,
        businessLineId,
        cartesBancaires,
        clearpay,
        countries,
        cup,
        currencies,
        customRoutingFlags,
        diners,
        discover,
        eftDirectdebitCA,
        eftposAustralia,
        enabled,
        girocard,
        googlePay,
        id,
        ideal,
        interacCard,
        jcb,
        klarna,
        maestro,
        maestroUsa,
        mc,
        mealVoucherFR,
        nyce,
        paybybankPlaid,
        payme,
        paypal,
        payto,
        pulse,
        reference,
        shopperInteraction,
        sodexo,
        sofort,
        star,
        storeIds,
        swish,
        ticket,
        twint,
        type,
        verificationStatus,
        vipps,
        visa,
        wechatpay,
        wechatpayPos);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethod {\n");
    sb.append("    accel: ").append(toIndentedString(accel)).append("\n");
    sb.append("    affirm: ").append(toIndentedString(affirm)).append("\n");
    sb.append("    afterpayTouch: ").append(toIndentedString(afterpayTouch)).append("\n");
    sb.append("    alipayPlus: ").append(toIndentedString(alipayPlus)).append("\n");
    sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
    sb.append("    amex: ").append(toIndentedString(amex)).append("\n");
    sb.append("    applePay: ").append(toIndentedString(applePay)).append("\n");
    sb.append("    bcmc: ").append(toIndentedString(bcmc)).append("\n");
    sb.append("    businessLineId: ").append(toIndentedString(businessLineId)).append("\n");
    sb.append("    cartesBancaires: ").append(toIndentedString(cartesBancaires)).append("\n");
    sb.append("    clearpay: ").append(toIndentedString(clearpay)).append("\n");
    sb.append("    countries: ").append(toIndentedString(countries)).append("\n");
    sb.append("    cup: ").append(toIndentedString(cup)).append("\n");
    sb.append("    currencies: ").append(toIndentedString(currencies)).append("\n");
    sb.append("    customRoutingFlags: ").append(toIndentedString(customRoutingFlags)).append("\n");
    sb.append("    diners: ").append(toIndentedString(diners)).append("\n");
    sb.append("    discover: ").append(toIndentedString(discover)).append("\n");
    sb.append("    eftDirectdebitCA: ").append(toIndentedString(eftDirectdebitCA)).append("\n");
    sb.append("    eftposAustralia: ").append(toIndentedString(eftposAustralia)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    girocard: ").append(toIndentedString(girocard)).append("\n");
    sb.append("    googlePay: ").append(toIndentedString(googlePay)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    ideal: ").append(toIndentedString(ideal)).append("\n");
    sb.append("    interacCard: ").append(toIndentedString(interacCard)).append("\n");
    sb.append("    jcb: ").append(toIndentedString(jcb)).append("\n");
    sb.append("    klarna: ").append(toIndentedString(klarna)).append("\n");
    sb.append("    maestro: ").append(toIndentedString(maestro)).append("\n");
    sb.append("    maestroUsa: ").append(toIndentedString(maestroUsa)).append("\n");
    sb.append("    mc: ").append(toIndentedString(mc)).append("\n");
    sb.append("    mealVoucherFR: ").append(toIndentedString(mealVoucherFR)).append("\n");
    sb.append("    nyce: ").append(toIndentedString(nyce)).append("\n");
    sb.append("    paybybankPlaid: ").append(toIndentedString(paybybankPlaid)).append("\n");
    sb.append("    payme: ").append(toIndentedString(payme)).append("\n");
    sb.append("    paypal: ").append(toIndentedString(paypal)).append("\n");
    sb.append("    payto: ").append(toIndentedString(payto)).append("\n");
    sb.append("    pulse: ").append(toIndentedString(pulse)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    sodexo: ").append(toIndentedString(sodexo)).append("\n");
    sb.append("    sofort: ").append(toIndentedString(sofort)).append("\n");
    sb.append("    star: ").append(toIndentedString(star)).append("\n");
    sb.append("    storeIds: ").append(toIndentedString(storeIds)).append("\n");
    sb.append("    swish: ").append(toIndentedString(swish)).append("\n");
    sb.append("    ticket: ").append(toIndentedString(ticket)).append("\n");
    sb.append("    twint: ").append(toIndentedString(twint)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
    sb.append("    vipps: ").append(toIndentedString(vipps)).append("\n");
    sb.append("    visa: ").append(toIndentedString(visa)).append("\n");
    sb.append("    wechatpay: ").append(toIndentedString(wechatpay)).append("\n");
    sb.append("    wechatpayPos: ").append(toIndentedString(wechatpayPos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentMethod given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethod
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentMethod
   */
  public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethod.class);
  }

  /**
   * Convert an instance of PaymentMethod to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
