/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** UninstallAndroidAppDetails */
@JsonPropertyOrder({
  UninstallAndroidAppDetails.JSON_PROPERTY_APP_ID,
  UninstallAndroidAppDetails.JSON_PROPERTY_TYPE
})
public class UninstallAndroidAppDetails {
  public static final String JSON_PROPERTY_APP_ID = "appId";
  private String appId;

  /** Type of terminal action: Uninstall an Android app. */
  public enum TypeEnum {
    UNINSTALLANDROIDAPP(String.valueOf("UninstallAndroidApp"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public UninstallAndroidAppDetails() {}

  /**
   * The unique identifier of the app to be uninstalled.
   *
   * @param appId The unique identifier of the app to be uninstalled.
   * @return the current {@code UninstallAndroidAppDetails} instance, allowing for method chaining
   */
  public UninstallAndroidAppDetails appId(String appId) {
    this.appId = appId;
    return this;
  }

  /**
   * The unique identifier of the app to be uninstalled.
   *
   * @return appId The unique identifier of the app to be uninstalled.
   */
  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAppId() {
    return appId;
  }

  /**
   * The unique identifier of the app to be uninstalled.
   *
   * @param appId The unique identifier of the app to be uninstalled.
   */
  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * Type of terminal action: Uninstall an Android app.
   *
   * @param type Type of terminal action: Uninstall an Android app.
   * @return the current {@code UninstallAndroidAppDetails} instance, allowing for method chaining
   */
  public UninstallAndroidAppDetails type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Type of terminal action: Uninstall an Android app.
   *
   * @return type Type of terminal action: Uninstall an Android app.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * Type of terminal action: Uninstall an Android app.
   *
   * @param type Type of terminal action: Uninstall an Android app.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this UninstallAndroidAppDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UninstallAndroidAppDetails uninstallAndroidAppDetails = (UninstallAndroidAppDetails) o;
    return Objects.equals(this.appId, uninstallAndroidAppDetails.appId)
        && Objects.equals(this.type, uninstallAndroidAppDetails.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UninstallAndroidAppDetails {\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of UninstallAndroidAppDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UninstallAndroidAppDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     UninstallAndroidAppDetails
   */
  public static UninstallAndroidAppDetails fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UninstallAndroidAppDetails.class);
  }

  /**
   * Convert an instance of UninstallAndroidAppDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
