/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** Url */
@JsonPropertyOrder({
  Url.JSON_PROPERTY_ENCRYPTED,
  Url.JSON_PROPERTY_PASSWORD,
  Url.JSON_PROPERTY_URL,
  Url.JSON_PROPERTY_USERNAME
})
public class Url {
  public static final String JSON_PROPERTY_ENCRYPTED = "encrypted";
  private Boolean encrypted;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private String password;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_USERNAME = "username";
  private String username;

  public Url() {}

  /**
   * Indicates if the message sent to this URL should be encrypted.
   *
   * @param encrypted Indicates if the message sent to this URL should be encrypted.
   * @return the current {@code Url} instance, allowing for method chaining
   */
  public Url encrypted(Boolean encrypted) {
    this.encrypted = encrypted;
    return this;
  }

  /**
   * Indicates if the message sent to this URL should be encrypted.
   *
   * @return encrypted Indicates if the message sent to this URL should be encrypted.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getEncrypted() {
    return encrypted;
  }

  /**
   * Indicates if the message sent to this URL should be encrypted.
   *
   * @param encrypted Indicates if the message sent to this URL should be encrypted.
   */
  @JsonProperty(JSON_PROPERTY_ENCRYPTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEncrypted(Boolean encrypted) {
    this.encrypted = encrypted;
  }

  /**
   * The password for authentication of the notifications.
   *
   * @param password The password for authentication of the notifications.
   * @return the current {@code Url} instance, allowing for method chaining
   */
  public Url password(String password) {
    this.password = password;
    return this;
  }

  /**
   * The password for authentication of the notifications.
   *
   * @return password The password for authentication of the notifications.
   */
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPassword() {
    return password;
  }

  /**
   * The password for authentication of the notifications.
   *
   * @param password The password for authentication of the notifications.
   */
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * The URL in the format: http(s)://domain.com.
   *
   * @param url The URL in the format: http(s)://domain.com.
   * @return the current {@code Url} instance, allowing for method chaining
   */
  public Url url(String url) {
    this.url = url;
    return this;
  }

  /**
   * The URL in the format: http(s)://domain.com.
   *
   * @return url The URL in the format: http(s)://domain.com.
   */
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUrl() {
    return url;
  }

  /**
   * The URL in the format: http(s)://domain.com.
   *
   * @param url The URL in the format: http(s)://domain.com.
   */
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * The username for authentication of the notifications.
   *
   * @param username The username for authentication of the notifications.
   * @return the current {@code Url} instance, allowing for method chaining
   */
  public Url username(String username) {
    this.username = username;
    return this;
  }

  /**
   * The username for authentication of the notifications.
   *
   * @return username The username for authentication of the notifications.
   */
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUsername() {
    return username;
  }

  /**
   * The username for authentication of the notifications.
   *
   * @param username The username for authentication of the notifications.
   */
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(String username) {
    this.username = username;
  }

  /** Return true if this Url object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Url url = (Url) o;
    return Objects.equals(this.encrypted, url.encrypted)
        && Objects.equals(this.password, url.password)
        && Objects.equals(this.url, url.url)
        && Objects.equals(this.username, url.username);
  }

  @Override
  public int hashCode() {
    return Objects.hash(encrypted, password, url, username);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Url {\n");
    sb.append("    encrypted: ").append(toIndentedString(encrypted)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Url given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Url
   * @throws JsonProcessingException if the JSON string is invalid with respect to Url
   */
  public static Url fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Url.class);
  }

  /**
   * Convert an instance of Url to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
