/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayaccount;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** AccountPayoutState */
@JsonPropertyOrder({
  AccountPayoutState.JSON_PROPERTY_ALLOW_PAYOUT,
  AccountPayoutState.JSON_PROPERTY_DISABLE_REASON,
  AccountPayoutState.JSON_PROPERTY_DISABLED,
  AccountPayoutState.JSON_PROPERTY_NOT_ALLOWED_REASON,
  AccountPayoutState.JSON_PROPERTY_PAYOUT_LIMIT,
  AccountPayoutState.JSON_PROPERTY_TIER_NUMBER
})
public class AccountPayoutState {
  public static final String JSON_PROPERTY_ALLOW_PAYOUT = "allowPayout";
  private Boolean allowPayout;

  public static final String JSON_PROPERTY_DISABLE_REASON = "disableReason";
  private String disableReason;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public static final String JSON_PROPERTY_NOT_ALLOWED_REASON = "notAllowedReason";
  private String notAllowedReason;

  public static final String JSON_PROPERTY_PAYOUT_LIMIT = "payoutLimit";
  private Amount payoutLimit;

  public static final String JSON_PROPERTY_TIER_NUMBER = "tierNumber";
  private Integer tierNumber;

  public AccountPayoutState() {}

  public AccountPayoutState allowPayout(Boolean allowPayout) {
    this.allowPayout = allowPayout;
    return this;
  }

  /**
   * Indicates whether payouts are allowed. This field is the overarching payout status, and is the
   * aggregate of multiple conditions (e.g., KYC status, disabled flag, etc). If this field is
   * false, no payouts will be permitted for any of the account holder&#39;s accounts. If this field
   * is true, payouts will be permitted for any of the account holder&#39;s accounts.
   *
   * @return allowPayout
   */
  @ApiModelProperty(
      value =
          "Indicates whether payouts are allowed. This field is the overarching payout status, and is the aggregate of multiple conditions (e.g., KYC status, disabled flag, etc). If this field is false, no payouts will be permitted for any of the account holder's accounts. If this field is true, payouts will be permitted for any of the account holder's accounts.")
  @JsonProperty(JSON_PROPERTY_ALLOW_PAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAllowPayout() {
    return allowPayout;
  }

  @JsonProperty(JSON_PROPERTY_ALLOW_PAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowPayout(Boolean allowPayout) {
    this.allowPayout = allowPayout;
  }

  public AccountPayoutState disableReason(String disableReason) {
    this.disableReason = disableReason;
    return this;
  }

  /**
   * The reason why payouts (to all of the account holder&#39;s accounts) have been disabled (by the
   * platform). If the &#x60;disabled&#x60; field is true, this field can be used to explain why.
   *
   * @return disableReason
   */
  @ApiModelProperty(
      value =
          "The reason why payouts (to all of the account holder's accounts) have been disabled (by the platform). If the `disabled` field is true, this field can be used to explain why.")
  @JsonProperty(JSON_PROPERTY_DISABLE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDisableReason() {
    return disableReason;
  }

  @JsonProperty(JSON_PROPERTY_DISABLE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisableReason(String disableReason) {
    this.disableReason = disableReason;
  }

  public AccountPayoutState disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Indicates whether payouts have been disabled (by the platform) for all of the account
   * holder&#39;s accounts. A platform may enable and disable this field at their discretion. If
   * this field is true, &#x60;allowPayout&#x60; will be false and no payouts will be permitted for
   * any of the account holder&#39;s accounts. If this field is false, &#x60;allowPayout&#x60; may
   * or may not be enabled, depending on other factors.
   *
   * @return disabled
   */
  @ApiModelProperty(
      value =
          "Indicates whether payouts have been disabled (by the platform) for all of the account holder's accounts. A platform may enable and disable this field at their discretion. If this field is true, `allowPayout` will be false and no payouts will be permitted for any of the account holder's accounts. If this field is false, `allowPayout` may or may not be enabled, depending on other factors.")
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDisabled() {
    return disabled;
  }

  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  public AccountPayoutState notAllowedReason(String notAllowedReason) {
    this.notAllowedReason = notAllowedReason;
    return this;
  }

  /**
   * The reason why payouts (to all of the account holder&#39;s accounts) have been disabled (by
   * Adyen). If payouts have been disabled by Adyen, this field will explain why. If this field is
   * blank, payouts have not been disabled by Adyen.
   *
   * @return notAllowedReason
   */
  @ApiModelProperty(
      value =
          "The reason why payouts (to all of the account holder's accounts) have been disabled (by Adyen). If payouts have been disabled by Adyen, this field will explain why. If this field is blank, payouts have not been disabled by Adyen.")
  @JsonProperty(JSON_PROPERTY_NOT_ALLOWED_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNotAllowedReason() {
    return notAllowedReason;
  }

  @JsonProperty(JSON_PROPERTY_NOT_ALLOWED_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotAllowedReason(String notAllowedReason) {
    this.notAllowedReason = notAllowedReason;
  }

  public AccountPayoutState payoutLimit(Amount payoutLimit) {
    this.payoutLimit = payoutLimit;
    return this;
  }

  /**
   * Get payoutLimit
   *
   * @return payoutLimit
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOUT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getPayoutLimit() {
    return payoutLimit;
  }

  @JsonProperty(JSON_PROPERTY_PAYOUT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutLimit(Amount payoutLimit) {
    this.payoutLimit = payoutLimit;
  }

  public AccountPayoutState tierNumber(Integer tierNumber) {
    this.tierNumber = tierNumber;
    return this;
  }

  /**
   * The payout tier that the account holder occupies.
   *
   * @return tierNumber
   */
  @ApiModelProperty(value = "The payout tier that the account holder occupies.")
  @JsonProperty(JSON_PROPERTY_TIER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getTierNumber() {
    return tierNumber;
  }

  @JsonProperty(JSON_PROPERTY_TIER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTierNumber(Integer tierNumber) {
    this.tierNumber = tierNumber;
  }

  /** Return true if this AccountPayoutState object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountPayoutState accountPayoutState = (AccountPayoutState) o;
    return Objects.equals(this.allowPayout, accountPayoutState.allowPayout)
        && Objects.equals(this.disableReason, accountPayoutState.disableReason)
        && Objects.equals(this.disabled, accountPayoutState.disabled)
        && Objects.equals(this.notAllowedReason, accountPayoutState.notAllowedReason)
        && Objects.equals(this.payoutLimit, accountPayoutState.payoutLimit)
        && Objects.equals(this.tierNumber, accountPayoutState.tierNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        allowPayout, disableReason, disabled, notAllowedReason, payoutLimit, tierNumber);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountPayoutState {\n");
    sb.append("    allowPayout: ").append(toIndentedString(allowPayout)).append("\n");
    sb.append("    disableReason: ").append(toIndentedString(disableReason)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    notAllowedReason: ").append(toIndentedString(notAllowedReason)).append("\n");
    sb.append("    payoutLimit: ").append(toIndentedString(payoutLimit)).append("\n");
    sb.append("    tierNumber: ").append(toIndentedString(tierNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of AccountPayoutState given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccountPayoutState
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     AccountPayoutState
   */
  public static AccountPayoutState fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AccountPayoutState.class);
  }

  /**
   * Convert an instance of AccountPayoutState to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
