/*
 * Notification Configuration API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Notification Configuration API provides endpoints for setting up and testing notifications that inform you of events on your platform, for example when a verification check or a payout has been completed.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/notifications). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Notification Configuration API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Notification/v6/createNotificationConfiguration ```
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpayconfiguration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** GetNotificationConfigurationListResponse */
@JsonPropertyOrder({
  GetNotificationConfigurationListResponse.JSON_PROPERTY_CONFIGURATIONS,
  GetNotificationConfigurationListResponse.JSON_PROPERTY_INVALID_FIELDS,
  GetNotificationConfigurationListResponse.JSON_PROPERTY_PSP_REFERENCE,
  GetNotificationConfigurationListResponse.JSON_PROPERTY_RESULT_CODE
})
public class GetNotificationConfigurationListResponse {
  public static final String JSON_PROPERTY_CONFIGURATIONS = "configurations";
  private List<NotificationConfigurationDetails> configurations = null;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
  private String resultCode;

  public GetNotificationConfigurationListResponse() {}

  public GetNotificationConfigurationListResponse configurations(
      List<NotificationConfigurationDetails> configurations) {
    this.configurations = configurations;
    return this;
  }

  public GetNotificationConfigurationListResponse addConfigurationsItem(
      NotificationConfigurationDetails configurationsItem) {
    if (this.configurations == null) {
      this.configurations = new ArrayList<>();
    }
    this.configurations.add(configurationsItem);
    return this;
  }

  /**
   * Details of the notification subscription configurations.
   *
   * @return configurations
   */
  @ApiModelProperty(value = "Details of the notification subscription configurations.")
  @JsonProperty(JSON_PROPERTY_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<NotificationConfigurationDetails> getConfigurations() {
    return configurations;
  }

  @JsonProperty(JSON_PROPERTY_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfigurations(List<NotificationConfigurationDetails> configurations) {
    this.configurations = configurations;
  }

  public GetNotificationConfigurationListResponse invalidFields(
      List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public GetNotificationConfigurationListResponse addInvalidFieldsItem(
      ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

  /**
   * Contains field validation errors that would prevent requests from being processed.
   *
   * @return invalidFields
   */
  @ApiModelProperty(
      value = "Contains field validation errors that would prevent requests from being processed.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }

  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }

  public GetNotificationConfigurationListResponse pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

  /**
   * The reference of a request. Can be used to uniquely identify the request.
   *
   * @return pspReference
   */
  @ApiModelProperty(
      value = "The reference of a request. Can be used to uniquely identify the request.")
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPspReference() {
    return pspReference;
  }

  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }

  public GetNotificationConfigurationListResponse resultCode(String resultCode) {
    this.resultCode = resultCode;
    return this;
  }

  /**
   * The result code.
   *
   * @return resultCode
   */
  @ApiModelProperty(value = "The result code.")
  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getResultCode() {
    return resultCode;
  }

  @JsonProperty(JSON_PROPERTY_RESULT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }

  /** Return true if this GetNotificationConfigurationListResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetNotificationConfigurationListResponse getNotificationConfigurationListResponse =
        (GetNotificationConfigurationListResponse) o;
    return Objects.equals(
            this.configurations, getNotificationConfigurationListResponse.configurations)
        && Objects.equals(
            this.invalidFields, getNotificationConfigurationListResponse.invalidFields)
        && Objects.equals(this.pspReference, getNotificationConfigurationListResponse.pspReference)
        && Objects.equals(this.resultCode, getNotificationConfigurationListResponse.resultCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configurations, invalidFields, pspReference, resultCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetNotificationConfigurationListResponse {\n");
    sb.append("    configurations: ").append(toIndentedString(configurations)).append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of GetNotificationConfigurationListResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GetNotificationConfigurationListResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     GetNotificationConfigurationListResponse
   */
  public static GetNotificationConfigurationListResponse fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GetNotificationConfigurationListResponse.class);
  }

  /**
   * Convert an instance of GetNotificationConfigurationListResponse to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
