/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** DirectDebitInitiatedNotificationContent */
@JsonPropertyOrder({
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_ACCOUNT_CODE,
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_AMOUNT,
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_DEBIT_INITIATION_DATE,
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_INVALID_FIELDS,
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_MERCHANT_ACCOUNT_CODE,
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_SPLITS,
  DirectDebitInitiatedNotificationContent.JSON_PROPERTY_STATUS
})
public class DirectDebitInitiatedNotificationContent {
  public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
  private String accountCode;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_DEBIT_INITIATION_DATE = "debitInitiationDate";
  private LocalDate debitInitiationDate;

  public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
  private List<ErrorFieldType> invalidFields = null;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
  private String merchantAccountCode;

  public static final String JSON_PROPERTY_SPLITS = "splits";
  private List<Split> splits = null;

  public static final String JSON_PROPERTY_STATUS = "status";
  private OperationStatus status;

  public DirectDebitInitiatedNotificationContent() {}

  public DirectDebitInitiatedNotificationContent accountCode(String accountCode) {
    this.accountCode = accountCode;
    return this;
  }

  /**
   * The code of the account.
   *
   * @return accountCode
   */
  @ApiModelProperty(required = true, value = "The code of the account.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountCode() {
    return accountCode;
  }

  @JsonProperty(JSON_PROPERTY_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountCode(String accountCode) {
    this.accountCode = accountCode;
  }

  public DirectDebitInitiatedNotificationContent amount(Amount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   *
   * @return amount
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Amount getAmount() {
    return amount;
  }

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }

  public DirectDebitInitiatedNotificationContent debitInitiationDate(
      LocalDate debitInitiationDate) {
    this.debitInitiationDate = debitInitiationDate;
    return this;
  }

  /**
   * Get debitInitiationDate
   *
   * @return debitInitiationDate
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEBIT_INITIATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDebitInitiationDate() {
    return debitInitiationDate;
  }

  @JsonProperty(JSON_PROPERTY_DEBIT_INITIATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDebitInitiationDate(LocalDate debitInitiationDate) {
    this.debitInitiationDate = debitInitiationDate;
  }

  public DirectDebitInitiatedNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
    return this;
  }

  public DirectDebitInitiatedNotificationContent addInvalidFieldsItem(
      ErrorFieldType invalidFieldsItem) {
    if (this.invalidFields == null) {
      this.invalidFields = new ArrayList<>();
    }
    this.invalidFields.add(invalidFieldsItem);
    return this;
  }

  /**
   * Invalid fields list.
   *
   * @return invalidFields
   */
  @ApiModelProperty(value = "Invalid fields list.")
  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ErrorFieldType> getInvalidFields() {
    return invalidFields;
  }

  @JsonProperty(JSON_PROPERTY_INVALID_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvalidFields(List<ErrorFieldType> invalidFields) {
    this.invalidFields = invalidFields;
  }

  public DirectDebitInitiatedNotificationContent merchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
    return this;
  }

  /**
   * The code of the merchant account.
   *
   * @return merchantAccountCode
   */
  @ApiModelProperty(required = true, value = "The code of the merchant account.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccountCode() {
    return merchantAccountCode;
  }

  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
  }

  public DirectDebitInitiatedNotificationContent splits(List<Split> splits) {
    this.splits = splits;
    return this;
  }

  public DirectDebitInitiatedNotificationContent addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

  /**
   * The split data for the debit request.
   *
   * @return splits
   */
  @ApiModelProperty(value = "The split data for the debit request.")
  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Split> getSplits() {
    return splits;
  }

  @JsonProperty(JSON_PROPERTY_SPLITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }

  public DirectDebitInitiatedNotificationContent status(OperationStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   *
   * @return status
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OperationStatus getStatus() {
    return status;
  }

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(OperationStatus status) {
    this.status = status;
  }

  /** Return true if this DirectDebitInitiatedNotificationContent object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DirectDebitInitiatedNotificationContent directDebitInitiatedNotificationContent =
        (DirectDebitInitiatedNotificationContent) o;
    return Objects.equals(this.accountCode, directDebitInitiatedNotificationContent.accountCode)
        && Objects.equals(this.amount, directDebitInitiatedNotificationContent.amount)
        && Objects.equals(
            this.debitInitiationDate, directDebitInitiatedNotificationContent.debitInitiationDate)
        && Objects.equals(this.invalidFields, directDebitInitiatedNotificationContent.invalidFields)
        && Objects.equals(
            this.merchantAccountCode, directDebitInitiatedNotificationContent.merchantAccountCode)
        && Objects.equals(this.splits, directDebitInitiatedNotificationContent.splits)
        && Objects.equals(this.status, directDebitInitiatedNotificationContent.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountCode,
        amount,
        debitInitiationDate,
        invalidFields,
        merchantAccountCode,
        splits,
        status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DirectDebitInitiatedNotificationContent {\n");
    sb.append("    accountCode: ").append(toIndentedString(accountCode)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    debitInitiationDate: ")
        .append(toIndentedString(debitInitiationDate))
        .append("\n");
    sb.append("    invalidFields: ").append(toIndentedString(invalidFields)).append("\n");
    sb.append("    merchantAccountCode: ")
        .append(toIndentedString(merchantAccountCode))
        .append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of DirectDebitInitiatedNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of DirectDebitInitiatedNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     DirectDebitInitiatedNotificationContent
   */
  public static DirectDebitInitiatedNotificationContent fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, DirectDebitInitiatedNotificationContent.class);
  }

  /**
   * Convert an instance of DirectDebitInitiatedNotificationContent to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
