/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** NotificationErrorContainer */
@JsonPropertyOrder({
  NotificationErrorContainer.JSON_PROPERTY_ERROR_CODE,
  NotificationErrorContainer.JSON_PROPERTY_MESSAGE
})
public class NotificationErrorContainer {
  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  private String errorCode;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public NotificationErrorContainer() {}

  public NotificationErrorContainer errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The Adyen code that is mapped to the error message.
   *
   * @return errorCode
   */
  @ApiModelProperty(value = "The Adyen code that is mapped to the error message.")
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getErrorCode() {
    return errorCode;
  }

  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  public NotificationErrorContainer message(String message) {
    this.message = message;
    return this;
  }

  /**
   * A short explanation of the issue.
   *
   * @return message
   */
  @ApiModelProperty(value = "A short explanation of the issue.")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }

  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }

  /** Return true if this NotificationErrorContainer object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NotificationErrorContainer notificationErrorContainer = (NotificationErrorContainer) o;
    return Objects.equals(this.errorCode, notificationErrorContainer.errorCode)
        && Objects.equals(this.message, notificationErrorContainer.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorCode, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NotificationErrorContainer {\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of NotificationErrorContainer given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of NotificationErrorContainer
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     NotificationErrorContainer
   */
  public static NotificationErrorContainer fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, NotificationErrorContainer.class);
  }

  /**
   * Convert an instance of NotificationErrorContainer to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
