/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.marketpaywebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PaymentFailureNotificationContent */
@JsonPropertyOrder({
  PaymentFailureNotificationContent.JSON_PROPERTY_ERROR_FIELDS,
  PaymentFailureNotificationContent.JSON_PROPERTY_ERROR_MESSAGE,
  PaymentFailureNotificationContent.JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE,
  PaymentFailureNotificationContent.JSON_PROPERTY_MODIFICATION_PSP_REFERENCE,
  PaymentFailureNotificationContent.JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE,
  PaymentFailureNotificationContent.JSON_PROPERTY_PAYMENT_PSP_REFERENCE
})
public class PaymentFailureNotificationContent {
  public static final String JSON_PROPERTY_ERROR_FIELDS = "errorFields";
  private List<ErrorFieldType> errorFields = null;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private Message errorMessage;

  public static final String JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE =
      "modificationMerchantReference";
  private String modificationMerchantReference;

  public static final String JSON_PROPERTY_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
  private String modificationPspReference;

  public static final String JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
  private String paymentMerchantReference;

  public static final String JSON_PROPERTY_PAYMENT_PSP_REFERENCE = "paymentPspReference";
  private String paymentPspReference;

  public PaymentFailureNotificationContent() {}

  public PaymentFailureNotificationContent errorFields(List<ErrorFieldType> errorFields) {
    this.errorFields = errorFields;
    return this;
  }

  public PaymentFailureNotificationContent addErrorFieldsItem(ErrorFieldType errorFieldsItem) {
    if (this.errorFields == null) {
      this.errorFields = new ArrayList<>();
    }
    this.errorFields.add(errorFieldsItem);
    return this;
  }

  /**
   * Missing or invalid fields that caused the payment error.
   *
   * @return errorFields
   */
  @ApiModelProperty(value = "Missing or invalid fields that caused the payment error.")
  @JsonProperty(JSON_PROPERTY_ERROR_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ErrorFieldType> getErrorFields() {
    return errorFields;
  }

  @JsonProperty(JSON_PROPERTY_ERROR_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorFields(List<ErrorFieldType> errorFields) {
    this.errorFields = errorFields;
  }

  public PaymentFailureNotificationContent errorMessage(Message errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Get errorMessage
   *
   * @return errorMessage
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Message getErrorMessage() {
    return errorMessage;
  }

  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(Message errorMessage) {
    this.errorMessage = errorMessage;
  }

  public PaymentFailureNotificationContent modificationMerchantReference(
      String modificationMerchantReference) {
    this.modificationMerchantReference = modificationMerchantReference;
    return this;
  }

  /**
   * The &#x60;reference&#x60; of the capture or refund.
   *
   * @return modificationMerchantReference
   */
  @ApiModelProperty(value = "The `reference` of the capture or refund.")
  @JsonProperty(JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getModificationMerchantReference() {
    return modificationMerchantReference;
  }

  @JsonProperty(JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationMerchantReference(String modificationMerchantReference) {
    this.modificationMerchantReference = modificationMerchantReference;
  }

  public PaymentFailureNotificationContent modificationPspReference(
      String modificationPspReference) {
    this.modificationPspReference = modificationPspReference;
    return this;
  }

  /**
   * The &#x60;pspReference&#x60; of the capture or refund.
   *
   * @return modificationPspReference
   */
  @ApiModelProperty(value = "The `pspReference` of the capture or refund.")
  @JsonProperty(JSON_PROPERTY_MODIFICATION_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getModificationPspReference() {
    return modificationPspReference;
  }

  @JsonProperty(JSON_PROPERTY_MODIFICATION_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationPspReference(String modificationPspReference) {
    this.modificationPspReference = modificationPspReference;
  }

  public PaymentFailureNotificationContent paymentMerchantReference(
      String paymentMerchantReference) {
    this.paymentMerchantReference = paymentMerchantReference;
    return this;
  }

  /**
   * The &#x60;reference&#x60; of the payment.
   *
   * @return paymentMerchantReference
   */
  @ApiModelProperty(value = "The `reference` of the payment.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentMerchantReference() {
    return paymentMerchantReference;
  }

  @JsonProperty(JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMerchantReference(String paymentMerchantReference) {
    this.paymentMerchantReference = paymentMerchantReference;
  }

  public PaymentFailureNotificationContent paymentPspReference(String paymentPspReference) {
    this.paymentPspReference = paymentPspReference;
    return this;
  }

  /**
   * The &#x60;pspReference&#x60; of the payment.
   *
   * @return paymentPspReference
   */
  @ApiModelProperty(value = "The `pspReference` of the payment.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPaymentPspReference() {
    return paymentPspReference;
  }

  @JsonProperty(JSON_PROPERTY_PAYMENT_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentPspReference(String paymentPspReference) {
    this.paymentPspReference = paymentPspReference;
  }

  /** Return true if this PaymentFailureNotificationContent object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentFailureNotificationContent paymentFailureNotificationContent =
        (PaymentFailureNotificationContent) o;
    return Objects.equals(this.errorFields, paymentFailureNotificationContent.errorFields)
        && Objects.equals(this.errorMessage, paymentFailureNotificationContent.errorMessage)
        && Objects.equals(
            this.modificationMerchantReference,
            paymentFailureNotificationContent.modificationMerchantReference)
        && Objects.equals(
            this.modificationPspReference,
            paymentFailureNotificationContent.modificationPspReference)
        && Objects.equals(
            this.paymentMerchantReference,
            paymentFailureNotificationContent.paymentMerchantReference)
        && Objects.equals(
            this.paymentPspReference, paymentFailureNotificationContent.paymentPspReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        errorFields,
        errorMessage,
        modificationMerchantReference,
        modificationPspReference,
        paymentMerchantReference,
        paymentPspReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentFailureNotificationContent {\n");
    sb.append("    errorFields: ").append(toIndentedString(errorFields)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    modificationMerchantReference: ")
        .append(toIndentedString(modificationMerchantReference))
        .append("\n");
    sb.append("    modificationPspReference: ")
        .append(toIndentedString(modificationPspReference))
        .append("\n");
    sb.append("    paymentMerchantReference: ")
        .append(toIndentedString(paymentMerchantReference))
        .append("\n");
    sb.append("    paymentPspReference: ")
        .append(toIndentedString(paymentPspReference))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of PaymentFailureNotificationContent given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentFailureNotificationContent
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     PaymentFailureNotificationContent
   */
  public static PaymentFailureNotificationContent fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentFailureNotificationContent.class);
  }

  /**
   * Convert an instance of PaymentFailureNotificationContent to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
