/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** Installments */
@JsonPropertyOrder({
  Installments.JSON_PROPERTY_EXTRA,
  Installments.JSON_PROPERTY_PLAN,
  Installments.JSON_PROPERTY_VALUE
})
public class Installments {
  public static final String JSON_PROPERTY_EXTRA = "extra";
  private Integer extra;

  /**
   * The installment plan, used for [card installments in
   * Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   * and
   * [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   * By default, this is set to **regular**.
   */
  public enum PlanEnum {
    BONUS(String.valueOf("bonus")),

    BUYNOW_PAYLATER(String.valueOf("buynow_paylater")),

    INTERES_REFUND_PRCTG(String.valueOf("interes_refund_prctg")),

    INTEREST_BONUS(String.valueOf("interest_bonus")),

    NOINTERES_REFUND_PRCTG(String.valueOf("nointeres_refund_prctg")),

    NOINTEREST_BONUS(String.valueOf("nointerest_bonus")),

    REFUND_PRCTG(String.valueOf("refund_prctg")),

    REGULAR(String.valueOf("regular")),

    REVOLVING(String.valueOf("revolving")),

    WITH_INTEREST(String.valueOf("with_interest"));

    private static final Logger LOG = Logger.getLogger(PlanEnum.class.getName());

    private String value;

    PlanEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PlanEnum fromValue(String value) {
      for (PlanEnum b : PlanEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "PlanEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(PlanEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_PLAN = "plan";
  private PlanEnum plan;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Integer value;

  public Installments() {}

  /**
   * Defines the bonus percentage, refund percentage or if the transaction is Buy now Pay later.
   * Used for [card installments in
   * Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico)
   *
   * @param extra Defines the bonus percentage, refund percentage or if the transaction is Buy now
   *     Pay later. Used for [card installments in
   *     Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico)
   * @return the current {@code Installments} instance, allowing for method chaining
   */
  public Installments extra(Integer extra) {
    this.extra = extra;
    return this;
  }

  /**
   * Defines the bonus percentage, refund percentage or if the transaction is Buy now Pay later.
   * Used for [card installments in
   * Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico)
   *
   * @return extra Defines the bonus percentage, refund percentage or if the transaction is Buy now
   *     Pay later. Used for [card installments in
   *     Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico)
   */
  @JsonProperty(JSON_PROPERTY_EXTRA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getExtra() {
    return extra;
  }

  /**
   * Defines the bonus percentage, refund percentage or if the transaction is Buy now Pay later.
   * Used for [card installments in
   * Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico)
   *
   * @param extra Defines the bonus percentage, refund percentage or if the transaction is Buy now
   *     Pay later. Used for [card installments in
   *     Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico)
   */
  @JsonProperty(JSON_PROPERTY_EXTRA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtra(Integer extra) {
    this.extra = extra;
  }

  /**
   * The installment plan, used for [card installments in
   * Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   * and
   * [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   * By default, this is set to **regular**.
   *
   * @param plan The installment plan, used for [card installments in
   *     Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   *     and
   *     [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   *     By default, this is set to **regular**.
   * @return the current {@code Installments} instance, allowing for method chaining
   */
  public Installments plan(PlanEnum plan) {
    this.plan = plan;
    return this;
  }

  /**
   * The installment plan, used for [card installments in
   * Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   * and
   * [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   * By default, this is set to **regular**.
   *
   * @return plan The installment plan, used for [card installments in
   *     Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   *     and
   *     [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   *     By default, this is set to **regular**.
   */
  @JsonProperty(JSON_PROPERTY_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PlanEnum getPlan() {
    return plan;
  }

  /**
   * The installment plan, used for [card installments in
   * Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   * and
   * [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   * By default, this is set to **regular**.
   *
   * @param plan The installment plan, used for [card installments in
   *     Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan).
   *     and
   *     [Mexico](https://docs.adyen.com/payment-methods/cards/credit-card-installments/#getting-paid-mexico).
   *     By default, this is set to **regular**.
   */
  @JsonProperty(JSON_PROPERTY_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlan(PlanEnum plan) {
    this.plan = plan;
  }

  /**
   * Defines the number of installments. Usually, the maximum allowed number of installments is
   * capped. For example, it may not be possible to split a payment in more than 24 installments.
   * The acquirer sets this upper limit, so its value may vary. This value can be zero for
   * Installments processed in Mexico.
   *
   * @param value Defines the number of installments. Usually, the maximum allowed number of
   *     installments is capped. For example, it may not be possible to split a payment in more than
   *     24 installments. The acquirer sets this upper limit, so its value may vary. This value can
   *     be zero for Installments processed in Mexico.
   * @return the current {@code Installments} instance, allowing for method chaining
   */
  public Installments value(Integer value) {
    this.value = value;
    return this;
  }

  /**
   * Defines the number of installments. Usually, the maximum allowed number of installments is
   * capped. For example, it may not be possible to split a payment in more than 24 installments.
   * The acquirer sets this upper limit, so its value may vary. This value can be zero for
   * Installments processed in Mexico.
   *
   * @return value Defines the number of installments. Usually, the maximum allowed number of
   *     installments is capped. For example, it may not be possible to split a payment in more than
   *     24 installments. The acquirer sets this upper limit, so its value may vary. This value can
   *     be zero for Installments processed in Mexico.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getValue() {
    return value;
  }

  /**
   * Defines the number of installments. Usually, the maximum allowed number of installments is
   * capped. For example, it may not be possible to split a payment in more than 24 installments.
   * The acquirer sets this upper limit, so its value may vary. This value can be zero for
   * Installments processed in Mexico.
   *
   * @param value Defines the number of installments. Usually, the maximum allowed number of
   *     installments is capped. For example, it may not be possible to split a payment in more than
   *     24 installments. The acquirer sets this upper limit, so its value may vary. This value can
   *     be zero for Installments processed in Mexico.
   */
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Integer value) {
    this.value = value;
  }

  /** Return true if this Installments object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Installments installments = (Installments) o;
    return Objects.equals(this.extra, installments.extra)
        && Objects.equals(this.plan, installments.plan)
        && Objects.equals(this.value, installments.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(extra, plan, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Installments {\n");
    sb.append("    extra: ").append(toIndentedString(extra)).append("\n");
    sb.append("    plan: ").append(toIndentedString(plan)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of Installments given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Installments
   * @throws JsonProcessingException if the JSON string is invalid with respect to Installments
   */
  public static Installments fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Installments.class);
  }

  /**
   * Convert an instance of Installments to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
