/*
 * Tokenization webhooks
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.tokenizationwebhooks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;

/** RecurringTokenStoreOperation */
@JsonPropertyOrder({
  RecurringTokenStoreOperation.JSON_PROPERTY_MERCHANT_ACCOUNT,
  RecurringTokenStoreOperation.JSON_PROPERTY_OPERATION,
  RecurringTokenStoreOperation.JSON_PROPERTY_SHOPPER_REFERENCE,
  RecurringTokenStoreOperation.JSON_PROPERTY_STORED_PAYMENT_METHOD_ID,
  RecurringTokenStoreOperation.JSON_PROPERTY_TYPE
})
public class RecurringTokenStoreOperation {
  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_OPERATION = "operation";
  private String operation;

  public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
  private String shopperReference;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  private String storedPaymentMethodId;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public RecurringTokenStoreOperation() {}

  /**
   * The identifier of the merchant account related to the event that triggered the webhook.
   *
   * @param merchantAccount The identifier of the merchant account related to the event that
   *     triggered the webhook.
   * @return the current {@code RecurringTokenStoreOperation} instance, allowing for method chaining
   */
  public RecurringTokenStoreOperation merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The identifier of the merchant account related to the event that triggered the webhook.
   *
   * @return merchantAccount The identifier of the merchant account related to the event that
   *     triggered the webhook.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The identifier of the merchant account related to the event that triggered the webhook.
   *
   * @param merchantAccount The identifier of the merchant account related to the event that
   *     triggered the webhook.
   */
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * A text description that provides details about the operation, intended for audit purposes.
   *
   * @param operation A text description that provides details about the operation, intended for
   *     audit purposes.
   * @return the current {@code RecurringTokenStoreOperation} instance, allowing for method chaining
   */
  public RecurringTokenStoreOperation operation(String operation) {
    this.operation = operation;
    return this;
  }

  /**
   * A text description that provides details about the operation, intended for audit purposes.
   *
   * @return operation A text description that provides details about the operation, intended for
   *     audit purposes.
   */
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOperation() {
    return operation;
  }

  /**
   * A text description that provides details about the operation, intended for audit purposes.
   *
   * @param operation A text description that provides details about the operation, intended for
   *     audit purposes.
   */
  @JsonProperty(JSON_PROPERTY_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperation(String operation) {
    this.operation = operation;
  }

  /**
   * Your unique shopper reference that is associated with the &#x60;storedPaymentMethodId&#x60;.
   *
   * @param shopperReference Your unique shopper reference that is associated with the
   *     &#x60;storedPaymentMethodId&#x60;.
   * @return the current {@code RecurringTokenStoreOperation} instance, allowing for method chaining
   */
  public RecurringTokenStoreOperation shopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
    return this;
  }

  /**
   * Your unique shopper reference that is associated with the &#x60;storedPaymentMethodId&#x60;.
   *
   * @return shopperReference Your unique shopper reference that is associated with the
   *     &#x60;storedPaymentMethodId&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getShopperReference() {
    return shopperReference;
  }

  /**
   * Your unique shopper reference that is associated with the &#x60;storedPaymentMethodId&#x60;.
   *
   * @param shopperReference Your unique shopper reference that is associated with the
   *     &#x60;storedPaymentMethodId&#x60;.
   */
  @JsonProperty(JSON_PROPERTY_SHOPPER_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }

  /**
   * The ID of the token.
   *
   * @param storedPaymentMethodId The ID of the token.
   * @return the current {@code RecurringTokenStoreOperation} instance, allowing for method chaining
   */
  public RecurringTokenStoreOperation storedPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

  /**
   * The ID of the token.
   *
   * @return storedPaymentMethodId The ID of the token.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }

  /**
   * The ID of the token.
   *
   * @param storedPaymentMethodId The ID of the token.
   */
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }

  /**
   * The type of the payment method.
   *
   * @param type The type of the payment method.
   * @return the current {@code RecurringTokenStoreOperation} instance, allowing for method chaining
   */
  public RecurringTokenStoreOperation type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the payment method.
   *
   * @return type The type of the payment method.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * The type of the payment method.
   *
   * @param type The type of the payment method.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  /** Return true if this RecurringTokenStoreOperation object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecurringTokenStoreOperation recurringTokenStoreOperation = (RecurringTokenStoreOperation) o;
    return Objects.equals(this.merchantAccount, recurringTokenStoreOperation.merchantAccount)
        && Objects.equals(this.operation, recurringTokenStoreOperation.operation)
        && Objects.equals(this.shopperReference, recurringTokenStoreOperation.shopperReference)
        && Objects.equals(
            this.storedPaymentMethodId, recurringTokenStoreOperation.storedPaymentMethodId)
        && Objects.equals(this.type, recurringTokenStoreOperation.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantAccount, operation, shopperReference, storedPaymentMethodId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecurringTokenStoreOperation {\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    operation: ").append(toIndentedString(operation)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    storedPaymentMethodId: ")
        .append(toIndentedString(storedPaymentMethodId))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of RecurringTokenStoreOperation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RecurringTokenStoreOperation
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     RecurringTokenStoreOperation
   */
  public static RecurringTokenStoreOperation fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RecurringTokenStoreOperation.class);
  }

  /**
   * Convert an instance of RecurringTokenStoreOperation to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
