/*
 * Tokenization webhooks
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.tokenizationwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** TokenizationAlreadyExistingDetailsNotificationRequest */
@JsonPropertyOrder({
  TokenizationAlreadyExistingDetailsNotificationRequest.JSON_PROPERTY_CREATED_AT,
  TokenizationAlreadyExistingDetailsNotificationRequest.JSON_PROPERTY_DATA,
  TokenizationAlreadyExistingDetailsNotificationRequest.JSON_PROPERTY_ENVIRONMENT,
  TokenizationAlreadyExistingDetailsNotificationRequest.JSON_PROPERTY_EVENT_ID,
  TokenizationAlreadyExistingDetailsNotificationRequest.JSON_PROPERTY_TYPE,
  TokenizationAlreadyExistingDetailsNotificationRequest.JSON_PROPERTY_VERSION
})
public class TokenizationAlreadyExistingDetailsNotificationRequest {
  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DATA = "data";
  private RecurringTokenStoreOperation data;

  /** The environment from which the webhook originated. Possible values: **test**, **live**. */
  public enum EnvironmentEnum {
    TEST(String.valueOf("test")),

    LIVE(String.valueOf("live"));

    private static final Logger LOG = Logger.getLogger(EnvironmentEnum.class.getName());

    private String value;

    EnvironmentEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EnvironmentEnum fromValue(String value) {
      for (EnvironmentEnum b : EnvironmentEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "EnvironmentEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(EnvironmentEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
  private EnvironmentEnum environment;

  public static final String JSON_PROPERTY_EVENT_ID = "eventId";
  private String eventId;

  /** The type of webhook. */
  public enum TypeEnum {
    RECURRING_TOKEN_ALREADYEXISTING(String.valueOf("recurring.token.alreadyExisting"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public TokenizationAlreadyExistingDetailsNotificationRequest() {}

  /**
   * The date and time when the event happened, in ISO 8601 extended format.
   *
   * @param createdAt The date and time when the event happened, in ISO 8601 extended format.
   * @return the current {@code TokenizationAlreadyExistingDetailsNotificationRequest} instance,
   *     allowing for method chaining
   */
  public TokenizationAlreadyExistingDetailsNotificationRequest createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * The date and time when the event happened, in ISO 8601 extended format.
   *
   * @return createdAt The date and time when the event happened, in ISO 8601 extended format.
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * The date and time when the event happened, in ISO 8601 extended format.
   *
   * @param createdAt The date and time when the event happened, in ISO 8601 extended format.
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  /**
   * data
   *
   * @param data
   * @return the current {@code TokenizationAlreadyExistingDetailsNotificationRequest} instance,
   *     allowing for method chaining
   */
  public TokenizationAlreadyExistingDetailsNotificationRequest data(
      RecurringTokenStoreOperation data) {
    this.data = data;
    return this;
  }

  /**
   * Get data
   *
   * @return data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RecurringTokenStoreOperation getData() {
    return data;
  }

  /**
   * data
   *
   * @param data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(RecurringTokenStoreOperation data) {
    this.data = data;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   * @return the current {@code TokenizationAlreadyExistingDetailsNotificationRequest} instance,
   *     allowing for method chaining
   */
  public TokenizationAlreadyExistingDetailsNotificationRequest environment(
      EnvironmentEnum environment) {
    this.environment = environment;
    return this;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @return environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EnvironmentEnum getEnvironment() {
    return environment;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnvironment(EnvironmentEnum environment) {
    this.environment = environment;
  }

  /**
   * The PSP reference of the event that triggered the webhook.
   *
   * @param eventId The PSP reference of the event that triggered the webhook.
   * @return the current {@code TokenizationAlreadyExistingDetailsNotificationRequest} instance,
   *     allowing for method chaining
   */
  public TokenizationAlreadyExistingDetailsNotificationRequest eventId(String eventId) {
    this.eventId = eventId;
    return this;
  }

  /**
   * The PSP reference of the event that triggered the webhook.
   *
   * @return eventId The PSP reference of the event that triggered the webhook.
   */
  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEventId() {
    return eventId;
  }

  /**
   * The PSP reference of the event that triggered the webhook.
   *
   * @param eventId The PSP reference of the event that triggered the webhook.
   */
  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventId(String eventId) {
    this.eventId = eventId;
  }

  /**
   * The type of webhook.
   *
   * @param type The type of webhook.
   * @return the current {@code TokenizationAlreadyExistingDetailsNotificationRequest} instance,
   *     allowing for method chaining
   */
  public TokenizationAlreadyExistingDetailsNotificationRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of webhook.
   *
   * @return type The type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of webhook.
   *
   * @param type The type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * The version of this entity.
   *
   * @param version The version of this entity.
   * @return the current {@code TokenizationAlreadyExistingDetailsNotificationRequest} instance,
   *     allowing for method chaining
   */
  public TokenizationAlreadyExistingDetailsNotificationRequest version(String version) {
    this.version = version;
    return this;
  }

  /**
   * The version of this entity.
   *
   * @return version The version of this entity.
   */
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVersion() {
    return version;
  }

  /**
   * The version of this entity.
   *
   * @param version The version of this entity.
   */
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
    this.version = version;
  }

  /**
   * Return true if this TokenizationAlreadyExistingDetailsNotificationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TokenizationAlreadyExistingDetailsNotificationRequest
        tokenizationAlreadyExistingDetailsNotificationRequest =
            (TokenizationAlreadyExistingDetailsNotificationRequest) o;
    return Objects.equals(
            this.createdAt, tokenizationAlreadyExistingDetailsNotificationRequest.createdAt)
        && Objects.equals(this.data, tokenizationAlreadyExistingDetailsNotificationRequest.data)
        && Objects.equals(
            this.environment, tokenizationAlreadyExistingDetailsNotificationRequest.environment)
        && Objects.equals(
            this.eventId, tokenizationAlreadyExistingDetailsNotificationRequest.eventId)
        && Objects.equals(this.type, tokenizationAlreadyExistingDetailsNotificationRequest.type)
        && Objects.equals(
            this.version, tokenizationAlreadyExistingDetailsNotificationRequest.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, data, environment, eventId, type, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TokenizationAlreadyExistingDetailsNotificationRequest {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TokenizationAlreadyExistingDetailsNotificationRequest given an JSON
   * string
   *
   * @param jsonString JSON string
   * @return An instance of TokenizationAlreadyExistingDetailsNotificationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TokenizationAlreadyExistingDetailsNotificationRequest
   */
  public static TokenizationAlreadyExistingDetailsNotificationRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper()
        .readValue(jsonString, TokenizationAlreadyExistingDetailsNotificationRequest.class);
  }

  /**
   * Convert an instance of TokenizationAlreadyExistingDetailsNotificationRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
