/*
 * Tokenization webhooks
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.tokenizationwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** TokenizationDisabledDetailsNotificationRequest */
@JsonPropertyOrder({
  TokenizationDisabledDetailsNotificationRequest.JSON_PROPERTY_CREATED_AT,
  TokenizationDisabledDetailsNotificationRequest.JSON_PROPERTY_DATA,
  TokenizationDisabledDetailsNotificationRequest.JSON_PROPERTY_ENVIRONMENT,
  TokenizationDisabledDetailsNotificationRequest.JSON_PROPERTY_EVENT_ID,
  TokenizationDisabledDetailsNotificationRequest.JSON_PROPERTY_TYPE,
  TokenizationDisabledDetailsNotificationRequest.JSON_PROPERTY_VERSION
})
public class TokenizationDisabledDetailsNotificationRequest {
  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DATA = "data";
  private RecurringToken data;

  /** The environment from which the webhook originated. Possible values: **test**, **live**. */
  public enum EnvironmentEnum {
    TEST(String.valueOf("test")),

    LIVE(String.valueOf("live"));

    private static final Logger LOG = Logger.getLogger(EnvironmentEnum.class.getName());

    private String value;

    EnvironmentEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EnvironmentEnum fromValue(String value) {
      for (EnvironmentEnum b : EnvironmentEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "EnvironmentEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(EnvironmentEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
  private EnvironmentEnum environment;

  public static final String JSON_PROPERTY_EVENT_ID = "eventId";
  private String eventId;

  /** The type of webhook. */
  public enum TypeEnum {
    RECURRING_TOKEN_DISABLED(String.valueOf("recurring.token.disabled"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  public TokenizationDisabledDetailsNotificationRequest() {}

  /**
   * The date and time when the event happened, in ISO 8601 extended format.
   *
   * @param createdAt The date and time when the event happened, in ISO 8601 extended format.
   * @return the current {@code TokenizationDisabledDetailsNotificationRequest} instance, allowing
   *     for method chaining
   */
  public TokenizationDisabledDetailsNotificationRequest createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * The date and time when the event happened, in ISO 8601 extended format.
   *
   * @return createdAt The date and time when the event happened, in ISO 8601 extended format.
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * The date and time when the event happened, in ISO 8601 extended format.
   *
   * @param createdAt The date and time when the event happened, in ISO 8601 extended format.
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  /**
   * data
   *
   * @param data
   * @return the current {@code TokenizationDisabledDetailsNotificationRequest} instance, allowing
   *     for method chaining
   */
  public TokenizationDisabledDetailsNotificationRequest data(RecurringToken data) {
    this.data = data;
    return this;
  }

  /**
   * Get data
   *
   * @return data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RecurringToken getData() {
    return data;
  }

  /**
   * data
   *
   * @param data
   */
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(RecurringToken data) {
    this.data = data;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   * @return the current {@code TokenizationDisabledDetailsNotificationRequest} instance, allowing
   *     for method chaining
   */
  public TokenizationDisabledDetailsNotificationRequest environment(EnvironmentEnum environment) {
    this.environment = environment;
    return this;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @return environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public EnvironmentEnum getEnvironment() {
    return environment;
  }

  /**
   * The environment from which the webhook originated. Possible values: **test**, **live**.
   *
   * @param environment The environment from which the webhook originated. Possible values:
   *     **test**, **live**.
   */
  @JsonProperty(JSON_PROPERTY_ENVIRONMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnvironment(EnvironmentEnum environment) {
    this.environment = environment;
  }

  /**
   * The PSP reference of the event that triggered the webhook.
   *
   * @param eventId The PSP reference of the event that triggered the webhook.
   * @return the current {@code TokenizationDisabledDetailsNotificationRequest} instance, allowing
   *     for method chaining
   */
  public TokenizationDisabledDetailsNotificationRequest eventId(String eventId) {
    this.eventId = eventId;
    return this;
  }

  /**
   * The PSP reference of the event that triggered the webhook.
   *
   * @return eventId The PSP reference of the event that triggered the webhook.
   */
  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEventId() {
    return eventId;
  }

  /**
   * The PSP reference of the event that triggered the webhook.
   *
   * @param eventId The PSP reference of the event that triggered the webhook.
   */
  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventId(String eventId) {
    this.eventId = eventId;
  }

  /**
   * The type of webhook.
   *
   * @param type The type of webhook.
   * @return the current {@code TokenizationDisabledDetailsNotificationRequest} instance, allowing
   *     for method chaining
   */
  public TokenizationDisabledDetailsNotificationRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of webhook.
   *
   * @return type The type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of webhook.
   *
   * @param type The type of webhook.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * The version of this entity.
   *
   * @param version The version of this entity.
   * @return the current {@code TokenizationDisabledDetailsNotificationRequest} instance, allowing
   *     for method chaining
   */
  public TokenizationDisabledDetailsNotificationRequest version(String version) {
    this.version = version;
    return this;
  }

  /**
   * The version of this entity.
   *
   * @return version The version of this entity.
   */
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getVersion() {
    return version;
  }

  /**
   * The version of this entity.
   *
   * @param version The version of this entity.
   */
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
    this.version = version;
  }

  /** Return true if this TokenizationDisabledDetailsNotificationRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TokenizationDisabledDetailsNotificationRequest tokenizationDisabledDetailsNotificationRequest =
        (TokenizationDisabledDetailsNotificationRequest) o;
    return Objects.equals(this.createdAt, tokenizationDisabledDetailsNotificationRequest.createdAt)
        && Objects.equals(this.data, tokenizationDisabledDetailsNotificationRequest.data)
        && Objects.equals(
            this.environment, tokenizationDisabledDetailsNotificationRequest.environment)
        && Objects.equals(this.eventId, tokenizationDisabledDetailsNotificationRequest.eventId)
        && Objects.equals(this.type, tokenizationDisabledDetailsNotificationRequest.type)
        && Objects.equals(this.version, tokenizationDisabledDetailsNotificationRequest.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, data, environment, eventId, type, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TokenizationDisabledDetailsNotificationRequest {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of TokenizationDisabledDetailsNotificationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TokenizationDisabledDetailsNotificationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     TokenizationDisabledDetailsNotificationRequest
   */
  public static TokenizationDisabledDetailsNotificationRequest fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper()
        .readValue(jsonString, TokenizationDisabledDetailsNotificationRequest.class);
  }

  /**
   * Convert an instance of TokenizationDisabledDetailsNotificationRequest to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
