/*
 * Tokenization webhooks
 *
 * The version of the OpenAPI document: 1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.tokenizationwebhooks;

import java.util.Optional;
import java.util.logging.Logger;

/**
 * Handler for processing TokenizationWebhooks.
 *
 * <p>This class provides functionality to deserialize the payload of TokenizationWebhooks events.
 */
public class TokenizationWebhooksHandler {

  private static final Logger LOG = Logger.getLogger(TokenizationWebhooksHandler.class.getName());

  private final String payload;

  /**
   * Constructs a new handler for the given webhook payload
   *
   * @param payload the raw JSON payload from the webhook
   */
  public TokenizationWebhooksHandler(String payload) {
    this.payload = payload;
  }

  /**
   * Attempts to deserialize the webhook payload into a
   * TokenizationAlreadyExistingDetailsNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TokenizationAlreadyExistingDetailsNotificationRequest>
      getTokenizationAlreadyExistingDetailsNotificationRequest() {

    var optionalTokenizationAlreadyExistingDetailsNotificationRequest =
        getOptionalField(TokenizationAlreadyExistingDetailsNotificationRequest.class);

    if (optionalTokenizationAlreadyExistingDetailsNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TokenizationAlreadyExistingDetailsNotificationRequest.TypeEnum.values()) {
        if (value.equals(
            optionalTokenizationAlreadyExistingDetailsNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTokenizationAlreadyExistingDetailsNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a
   * TokenizationCreatedDetailsNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TokenizationCreatedDetailsNotificationRequest>
      getTokenizationCreatedDetailsNotificationRequest() {

    var optionalTokenizationCreatedDetailsNotificationRequest =
        getOptionalField(TokenizationCreatedDetailsNotificationRequest.class);

    if (optionalTokenizationCreatedDetailsNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TokenizationCreatedDetailsNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalTokenizationCreatedDetailsNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTokenizationCreatedDetailsNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a
   * TokenizationDisabledDetailsNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TokenizationDisabledDetailsNotificationRequest>
      getTokenizationDisabledDetailsNotificationRequest() {

    var optionalTokenizationDisabledDetailsNotificationRequest =
        getOptionalField(TokenizationDisabledDetailsNotificationRequest.class);

    if (optionalTokenizationDisabledDetailsNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TokenizationDisabledDetailsNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalTokenizationDisabledDetailsNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTokenizationDisabledDetailsNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Attempts to deserialize the webhook payload into a
   * TokenizationUpdatedDetailsNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TokenizationUpdatedDetailsNotificationRequest>
      getTokenizationUpdatedDetailsNotificationRequest() {

    var optionalTokenizationUpdatedDetailsNotificationRequest =
        getOptionalField(TokenizationUpdatedDetailsNotificationRequest.class);

    if (optionalTokenizationUpdatedDetailsNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TokenizationUpdatedDetailsNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalTokenizationUpdatedDetailsNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTokenizationUpdatedDetailsNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Deserializes the payload into the specified class type.
   *
   * @param clazz the class to deserialize into
   * @param <T> the type of the class
   * @return an Optional containing the deserialized object, or empty if an error occurs
   */
  private <T> Optional<T> getOptionalField(Class<T> clazz) {
    try {
      T val = JSON.getMapper().readValue(payload, clazz);
      return Optional.ofNullable(val);
    } catch (Exception e) {
      // an error has occurred during deserialization (object not found, deserialization error)
      LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
      LOG.warning("Deserialization error: " + e.getMessage());
      return Optional.empty();
    }
  }
}
