/*
 * Transaction webhooks
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transactionwebhooks;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.*;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using = TransferViewCategoryData.TransferViewCategoryDataDeserializer.class)
@JsonSerialize(using = TransferViewCategoryData.TransferViewCategoryDataSerializer.class)
public class TransferViewCategoryData extends AbstractOpenApiSchema {
  private static final Logger log = Logger.getLogger(TransferViewCategoryData.class.getName());

  public static class TransferViewCategoryDataSerializer
      extends StdSerializer<TransferViewCategoryData> {
    public TransferViewCategoryDataSerializer(Class<TransferViewCategoryData> t) {
      super(t);
    }

    public TransferViewCategoryDataSerializer() {
      this(null);
    }

    @Override
    public void serialize(
        TransferViewCategoryData value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.getActualInstance());
    }
  }

  public static class TransferViewCategoryDataDeserializer
      extends StdDeserializer<TransferViewCategoryData> {
    public TransferViewCategoryDataDeserializer() {
      this(TransferViewCategoryData.class);
    }

    public TransferViewCategoryDataDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public TransferViewCategoryData deserialize(JsonParser jp, DeserializationContext ctxt)
        throws IOException, JsonProcessingException {
      JsonNode tree = jp.readValueAsTree();
      Object deserialized = null;
      boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
      int match = 0;
      JsonToken token = tree.traverse(jp.getCodec()).nextToken();
      // deserialize BankCategoryData
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(BankCategoryData.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized = tree.traverse(jp.getCodec()).readValueAs(BankCategoryData.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'BankCategoryData'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'BankCategoryData'", e);
      }

      // deserialize InternalCategoryData
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(InternalCategoryData.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized = tree.traverse(jp.getCodec()).readValueAs(InternalCategoryData.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'InternalCategoryData'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'InternalCategoryData'", e);
      }

      // deserialize IssuedCard
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(IssuedCard.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized = tree.traverse(jp.getCodec()).readValueAs(IssuedCard.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'IssuedCard'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'IssuedCard'", e);
      }

      // deserialize PlatformPayment
      try {
        boolean attemptParsing = true;
        if (attemptParsing) {
          // Checks if the unique type of the oneOf json matches any of the object TypeEnum values
          boolean typeMatch =
              Arrays.stream(PlatformPayment.TypeEnum.values())
                  .anyMatch((t) -> t.getValue().contains(tree.findValue("type").asText()));

          if (typeMatch) {
            deserialized = tree.traverse(jp.getCodec()).readValueAs(PlatformPayment.class);
            // TODO: there is no validation against JSON schema constraints
            // (min, max, enum, pattern...), this does not perform a strict JSON
            // validation, which means the 'match' count may be higher than it should be.
            match++;
            log.log(Level.FINER, "Input data matches schema 'PlatformPayment'");
          }
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(Level.FINER, "Input data does not match schema 'PlatformPayment'", e);
      }

      if (match == 1) {
        TransferViewCategoryData ret = new TransferViewCategoryData();
        ret.setActualInstance(deserialized);
        return ret;
      }
      throw new IOException(
          String.format(
              "Failed deserialization for TransferViewCategoryData: %d classes match result, expected 1",
              match));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public TransferViewCategoryData getNullValue(DeserializationContext ctxt)
        throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "TransferViewCategoryData cannot be null");
    }
  }

  // store a list of schema names defined in oneOf
  public static final Map<String, GenericType<?>> schemas = new HashMap<>();

  public TransferViewCategoryData() {
    super("oneOf", Boolean.FALSE);
  }

  public TransferViewCategoryData(BankCategoryData o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferViewCategoryData(InternalCategoryData o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferViewCategoryData(IssuedCard o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public TransferViewCategoryData(PlatformPayment o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  static {
    schemas.put("BankCategoryData", new GenericType<BankCategoryData>() {});
    schemas.put("InternalCategoryData", new GenericType<InternalCategoryData>() {});
    schemas.put("IssuedCard", new GenericType<IssuedCard>() {});
    schemas.put("PlatformPayment", new GenericType<PlatformPayment>() {});
    JSON.registerDescendants(TransferViewCategoryData.class, Collections.unmodifiableMap(schemas));
  }

  @Override
  public Map<String, GenericType<?>> getSchemas() {
    return TransferViewCategoryData.schemas;
  }

  /**
   * Set the instance that matches the oneOf child schema, check the instance parameter is valid
   * against the oneOf child schemas: BankCategoryData, InternalCategoryData, IssuedCard,
   * PlatformPayment
   *
   * <p>It could be an instance of the 'oneOf' schemas. The oneOf child schemas may themselves be a
   * composed schema (allOf, anyOf, oneOf).
   */
  @Override
  public void setActualInstance(Object instance) {
    if (JSON.isInstanceOf(BankCategoryData.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(InternalCategoryData.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(IssuedCard.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(PlatformPayment.class, instance, new HashSet<>())) {
      super.setActualInstance(instance);
      return;
    }

    throw new RuntimeException(
        "Invalid instance type. Must be BankCategoryData, InternalCategoryData, IssuedCard, PlatformPayment");
  }

  /**
   * Get the actual instance, which can be the following: BankCategoryData, InternalCategoryData,
   * IssuedCard, PlatformPayment
   *
   * @return The actual instance (BankCategoryData, InternalCategoryData, IssuedCard,
   *     PlatformPayment)
   */
  @Override
  public Object getActualInstance() {
    return super.getActualInstance();
  }

  /**
   * Get the actual instance of `BankCategoryData`. If the actual instance is not
   * `BankCategoryData`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `BankCategoryData`
   * @throws ClassCastException if the instance is not `BankCategoryData`
   */
  public BankCategoryData getBankCategoryData() throws ClassCastException {
    return (BankCategoryData) super.getActualInstance();
  }

  /**
   * Get the actual instance of `InternalCategoryData`. If the actual instance is not
   * `InternalCategoryData`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `InternalCategoryData`
   * @throws ClassCastException if the instance is not `InternalCategoryData`
   */
  public InternalCategoryData getInternalCategoryData() throws ClassCastException {
    return (InternalCategoryData) super.getActualInstance();
  }

  /**
   * Get the actual instance of `IssuedCard`. If the actual instance is not `IssuedCard`, the
   * ClassCastException will be thrown.
   *
   * @return The actual instance of `IssuedCard`
   * @throws ClassCastException if the instance is not `IssuedCard`
   */
  public IssuedCard getIssuedCard() throws ClassCastException {
    return (IssuedCard) super.getActualInstance();
  }

  /**
   * Get the actual instance of `PlatformPayment`. If the actual instance is not `PlatformPayment`,
   * the ClassCastException will be thrown.
   *
   * @return The actual instance of `PlatformPayment`
   * @throws ClassCastException if the instance is not `PlatformPayment`
   */
  public PlatformPayment getPlatformPayment() throws ClassCastException {
    return (PlatformPayment) super.getActualInstance();
  }

  /**
   * Create an instance of TransferViewCategoryData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TransferViewCategoryData
   * @throws IOException if the JSON string is invalid with respect to TransferViewCategoryData
   */
  public static TransferViewCategoryData fromJson(String jsonString) throws IOException {
    return JSON.getMapper().readValue(jsonString, TransferViewCategoryData.class);
  }

  /**
   * Convert an instance of TransferViewCategoryData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
