/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** RoutingDetails */
@JsonPropertyOrder({
  RoutingDetails.JSON_PROPERTY_DETAIL,
  RoutingDetails.JSON_PROPERTY_ERROR_CODE,
  RoutingDetails.JSON_PROPERTY_PRIORITY,
  RoutingDetails.JSON_PROPERTY_TITLE
})
public class RoutingDetails {
  public static final String JSON_PROPERTY_DETAIL = "detail";
  private String detail;

  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  private String errorCode;

  /**
   * The priority for the bank transfer. This sets the speed at which the transfer is sent and the
   * fees that you have to pay. Required for transfers with &#x60;category&#x60; **bank**. Possible
   * values: * **regular**: for normal, low-value transactions. * **fast**: a faster way to transfer
   * funds, but the fees are higher. Recommended for high-priority, low-value transactions. *
   * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for
   * high-priority, high-value transactions. * **instant**: for instant funds transfers within the
   * United States and in [SEPA
   * locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   * **crossBorder**: for high-value transfers to a recipient in a different country. *
   * **internal**: for transfers to an Adyen-issued business bank account (by bank account
   * number/IBAN).
   */
  public enum PriorityEnum {
    CROSSBORDER(String.valueOf("crossBorder")),

    FAST(String.valueOf("fast")),

    INSTANT(String.valueOf("instant")),

    INTERNAL(String.valueOf("internal")),

    REGULAR(String.valueOf("regular")),

    WIRE(String.valueOf("wire"));

    private static final Logger LOG = Logger.getLogger(PriorityEnum.class.getName());

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "PriorityEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(PriorityEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private PriorityEnum priority;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public RoutingDetails() {}

  /**
   * A human-readable explanation specific to this occurrence of the problem.
   *
   * @param detail A human-readable explanation specific to this occurrence of the problem.
   * @return the current {@code RoutingDetails} instance, allowing for method chaining
   */
  public RoutingDetails detail(String detail) {
    this.detail = detail;
    return this;
  }

  /**
   * A human-readable explanation specific to this occurrence of the problem.
   *
   * @return detail A human-readable explanation specific to this occurrence of the problem.
   */
  @JsonProperty(JSON_PROPERTY_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDetail() {
    return detail;
  }

  /**
   * A human-readable explanation specific to this occurrence of the problem.
   *
   * @param detail A human-readable explanation specific to this occurrence of the problem.
   */
  @JsonProperty(JSON_PROPERTY_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDetail(String detail) {
    this.detail = detail;
  }

  /**
   * A code that identifies the problem type.
   *
   * @param errorCode A code that identifies the problem type.
   * @return the current {@code RoutingDetails} instance, allowing for method chaining
   */
  public RoutingDetails errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * A code that identifies the problem type.
   *
   * @return errorCode A code that identifies the problem type.
   */
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getErrorCode() {
    return errorCode;
  }

  /**
   * A code that identifies the problem type.
   *
   * @param errorCode A code that identifies the problem type.
   */
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  /**
   * The priority for the bank transfer. This sets the speed at which the transfer is sent and the
   * fees that you have to pay. Required for transfers with &#x60;category&#x60; **bank**. Possible
   * values: * **regular**: for normal, low-value transactions. * **fast**: a faster way to transfer
   * funds, but the fees are higher. Recommended for high-priority, low-value transactions. *
   * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for
   * high-priority, high-value transactions. * **instant**: for instant funds transfers within the
   * United States and in [SEPA
   * locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   * **crossBorder**: for high-value transfers to a recipient in a different country. *
   * **internal**: for transfers to an Adyen-issued business bank account (by bank account
   * number/IBAN).
   *
   * @param priority The priority for the bank transfer. This sets the speed at which the transfer
   *     is sent and the fees that you have to pay. Required for transfers with &#x60;category&#x60;
   *     **bank**. Possible values: * **regular**: for normal, low-value transactions. * **fast**: a
   *     faster way to transfer funds, but the fees are higher. Recommended for high-priority,
   *     low-value transactions. * **wire**: the fastest way to transfer funds, but this has the
   *     highest fees. Recommended for high-priority, high-value transactions. * **instant**: for
   *     instant funds transfers within the United States and in [SEPA
   *     locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   *     **crossBorder**: for high-value transfers to a recipient in a different country. *
   *     **internal**: for transfers to an Adyen-issued business bank account (by bank account
   *     number/IBAN).
   * @return the current {@code RoutingDetails} instance, allowing for method chaining
   */
  public RoutingDetails priority(PriorityEnum priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority for the bank transfer. This sets the speed at which the transfer is sent and the
   * fees that you have to pay. Required for transfers with &#x60;category&#x60; **bank**. Possible
   * values: * **regular**: for normal, low-value transactions. * **fast**: a faster way to transfer
   * funds, but the fees are higher. Recommended for high-priority, low-value transactions. *
   * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for
   * high-priority, high-value transactions. * **instant**: for instant funds transfers within the
   * United States and in [SEPA
   * locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   * **crossBorder**: for high-value transfers to a recipient in a different country. *
   * **internal**: for transfers to an Adyen-issued business bank account (by bank account
   * number/IBAN).
   *
   * @return priority The priority for the bank transfer. This sets the speed at which the transfer
   *     is sent and the fees that you have to pay. Required for transfers with &#x60;category&#x60;
   *     **bank**. Possible values: * **regular**: for normal, low-value transactions. * **fast**: a
   *     faster way to transfer funds, but the fees are higher. Recommended for high-priority,
   *     low-value transactions. * **wire**: the fastest way to transfer funds, but this has the
   *     highest fees. Recommended for high-priority, high-value transactions. * **instant**: for
   *     instant funds transfers within the United States and in [SEPA
   *     locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   *     **crossBorder**: for high-value transfers to a recipient in a different country. *
   *     **internal**: for transfers to an Adyen-issued business bank account (by bank account
   *     number/IBAN).
   */
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PriorityEnum getPriority() {
    return priority;
  }

  /**
   * The priority for the bank transfer. This sets the speed at which the transfer is sent and the
   * fees that you have to pay. Required for transfers with &#x60;category&#x60; **bank**. Possible
   * values: * **regular**: for normal, low-value transactions. * **fast**: a faster way to transfer
   * funds, but the fees are higher. Recommended for high-priority, low-value transactions. *
   * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for
   * high-priority, high-value transactions. * **instant**: for instant funds transfers within the
   * United States and in [SEPA
   * locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   * **crossBorder**: for high-value transfers to a recipient in a different country. *
   * **internal**: for transfers to an Adyen-issued business bank account (by bank account
   * number/IBAN).
   *
   * @param priority The priority for the bank transfer. This sets the speed at which the transfer
   *     is sent and the fees that you have to pay. Required for transfers with &#x60;category&#x60;
   *     **bank**. Possible values: * **regular**: for normal, low-value transactions. * **fast**: a
   *     faster way to transfer funds, but the fees are higher. Recommended for high-priority,
   *     low-value transactions. * **wire**: the fastest way to transfer funds, but this has the
   *     highest fees. Recommended for high-priority, high-value transactions. * **instant**: for
   *     instant funds transfers within the United States and in [SEPA
   *     locations](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html). *
   *     **crossBorder**: for high-value transfers to a recipient in a different country. *
   *     **internal**: for transfers to an Adyen-issued business bank account (by bank account
   *     number/IBAN).
   */
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }

  /**
   * A short, human-readable summary of the problem type.
   *
   * @param title A short, human-readable summary of the problem type.
   * @return the current {@code RoutingDetails} instance, allowing for method chaining
   */
  public RoutingDetails title(String title) {
    this.title = title;
    return this;
  }

  /**
   * A short, human-readable summary of the problem type.
   *
   * @return title A short, human-readable summary of the problem type.
   */
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTitle() {
    return title;
  }

  /**
   * A short, human-readable summary of the problem type.
   *
   * @param title A short, human-readable summary of the problem type.
   */
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }

  /** Return true if this RoutingDetails object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoutingDetails routingDetails = (RoutingDetails) o;
    return Objects.equals(this.detail, routingDetails.detail)
        && Objects.equals(this.errorCode, routingDetails.errorCode)
        && Objects.equals(this.priority, routingDetails.priority)
        && Objects.equals(this.title, routingDetails.title);
  }

  @Override
  public int hashCode() {
    return Objects.hash(detail, errorCode, priority, title);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoutingDetails {\n");
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of RoutingDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RoutingDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to RoutingDetails
   */
  public static RoutingDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RoutingDetails.class);
  }

  /**
   * Convert an instance of RoutingDetails to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
