/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transfers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** SELocalAccountIdentification */
@JsonPropertyOrder({
  SELocalAccountIdentification.JSON_PROPERTY_ACCOUNT_NUMBER,
  SELocalAccountIdentification.JSON_PROPERTY_CLEARING_NUMBER,
  SELocalAccountIdentification.JSON_PROPERTY_TYPE
})
public class SELocalAccountIdentification {
  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  public static final String JSON_PROPERTY_CLEARING_NUMBER = "clearingNumber";
  private String clearingNumber;

  /** **seLocal** */
  public enum TypeEnum {
    SELOCAL(String.valueOf("seLocal"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public SELocalAccountIdentification() {}

  /**
   * The 7- to 10-digit bank account number
   * ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number,
   * separators, or whitespace.
   *
   * @param accountNumber The 7- to 10-digit bank account number
   *     ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number,
   *     separators, or whitespace.
   * @return the current {@code SELocalAccountIdentification} instance, allowing for method chaining
   */
  public SELocalAccountIdentification accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * The 7- to 10-digit bank account number
   * ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number,
   * separators, or whitespace.
   *
   * @return accountNumber The 7- to 10-digit bank account number
   *     ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number,
   *     separators, or whitespace.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountNumber() {
    return accountNumber;
  }

  /**
   * The 7- to 10-digit bank account number
   * ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number,
   * separators, or whitespace.
   *
   * @param accountNumber The 7- to 10-digit bank account number
   *     ([Bankkontonummer](https://sv.wikipedia.org/wiki/Bankkonto)), without the clearing number,
   *     separators, or whitespace.
   */
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }

  /**
   * The 4- to 5-digit clearing number
   * ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or
   * whitespace.
   *
   * @param clearingNumber The 4- to 5-digit clearing number
   *     ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or
   *     whitespace.
   * @return the current {@code SELocalAccountIdentification} instance, allowing for method chaining
   */
  public SELocalAccountIdentification clearingNumber(String clearingNumber) {
    this.clearingNumber = clearingNumber;
    return this;
  }

  /**
   * The 4- to 5-digit clearing number
   * ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or
   * whitespace.
   *
   * @return clearingNumber The 4- to 5-digit clearing number
   *     ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or
   *     whitespace.
   */
  @JsonProperty(JSON_PROPERTY_CLEARING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClearingNumber() {
    return clearingNumber;
  }

  /**
   * The 4- to 5-digit clearing number
   * ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or
   * whitespace.
   *
   * @param clearingNumber The 4- to 5-digit clearing number
   *     ([Clearingnummer](https://sv.wikipedia.org/wiki/Clearingnummer)), without separators or
   *     whitespace.
   */
  @JsonProperty(JSON_PROPERTY_CLEARING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClearingNumber(String clearingNumber) {
    this.clearingNumber = clearingNumber;
  }

  /**
   * **seLocal**
   *
   * @param type **seLocal**
   * @return the current {@code SELocalAccountIdentification} instance, allowing for method chaining
   */
  public SELocalAccountIdentification type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **seLocal**
   *
   * @return type **seLocal**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **seLocal**
   *
   * @param type **seLocal**
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this SELocalAccountIdentification object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SELocalAccountIdentification seLocalAccountIdentification = (SELocalAccountIdentification) o;
    return Objects.equals(this.accountNumber, seLocalAccountIdentification.accountNumber)
        && Objects.equals(this.clearingNumber, seLocalAccountIdentification.clearingNumber)
        && Objects.equals(this.type, seLocalAccountIdentification.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNumber, clearingNumber, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SELocalAccountIdentification {\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    clearingNumber: ").append(toIndentedString(clearingNumber)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of SELocalAccountIdentification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SELocalAccountIdentification
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     SELocalAccountIdentification
   */
  public static SELocalAccountIdentification fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SELocalAccountIdentification.class);
  }

  /**
   * Convert an instance of SELocalAccountIdentification to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
