/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transferwebhooks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.*;
import java.util.Arrays;
import java.util.logging.Logger;

/** ConfirmationTrackingData */
@JsonPropertyOrder({
  ConfirmationTrackingData.JSON_PROPERTY_STATUS,
  ConfirmationTrackingData.JSON_PROPERTY_TYPE
})
public class ConfirmationTrackingData {
  /**
   * The status of the transfer. Possible values: - **credited**: the funds are credited to your
   * user&#39;s transfer instrument or bank account.
   */
  public enum StatusEnum {
    CREDITED(String.valueOf("credited"));

    private static final Logger LOG = Logger.getLogger(StatusEnum.class.getName());

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "StatusEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(StatusEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * The type of the tracking event. Possible values: - **confirmation**: the transfer passed
   * Adyen&#39;s internal review.
   */
  public enum TypeEnum {
    CONFIRMATION(String.valueOf("confirmation"));

    private static final Logger LOG = Logger.getLogger(TypeEnum.class.getName());

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      // handling unexpected value
      LOG.warning(
          "TypeEnum: unexpected enum value '"
              + value
              + "' - Supported values are "
              + Arrays.toString(TypeEnum.values()));
      return null;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public ConfirmationTrackingData() {}

  /**
   * The status of the transfer. Possible values: - **credited**: the funds are credited to your
   * user&#39;s transfer instrument or bank account.
   *
   * @param status The status of the transfer. Possible values: - **credited**: the funds are
   *     credited to your user&#39;s transfer instrument or bank account.
   * @return the current {@code ConfirmationTrackingData} instance, allowing for method chaining
   */
  public ConfirmationTrackingData status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the transfer. Possible values: - **credited**: the funds are credited to your
   * user&#39;s transfer instrument or bank account.
   *
   * @return status The status of the transfer. Possible values: - **credited**: the funds are
   *     credited to your user&#39;s transfer instrument or bank account.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the transfer. Possible values: - **credited**: the funds are credited to your
   * user&#39;s transfer instrument or bank account.
   *
   * @param status The status of the transfer. Possible values: - **credited**: the funds are
   *     credited to your user&#39;s transfer instrument or bank account.
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The type of the tracking event. Possible values: - **confirmation**: the transfer passed
   * Adyen&#39;s internal review.
   *
   * @param type The type of the tracking event. Possible values: - **confirmation**: the transfer
   *     passed Adyen&#39;s internal review.
   * @return the current {@code ConfirmationTrackingData} instance, allowing for method chaining
   */
  public ConfirmationTrackingData type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the tracking event. Possible values: - **confirmation**: the transfer passed
   * Adyen&#39;s internal review.
   *
   * @return type The type of the tracking event. Possible values: - **confirmation**: the transfer
   *     passed Adyen&#39;s internal review.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the tracking event. Possible values: - **confirmation**: the transfer passed
   * Adyen&#39;s internal review.
   *
   * @param type The type of the tracking event. Possible values: - **confirmation**: the transfer
   *     passed Adyen&#39;s internal review.
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /** Return true if this ConfirmationTrackingData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConfirmationTrackingData confirmationTrackingData = (ConfirmationTrackingData) o;
    return Objects.equals(this.status, confirmationTrackingData.status)
        && Objects.equals(this.type, confirmationTrackingData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConfirmationTrackingData {\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create an instance of ConfirmationTrackingData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ConfirmationTrackingData
   * @throws JsonProcessingException if the JSON string is invalid with respect to
   *     ConfirmationTrackingData
   */
  public static ConfirmationTrackingData fromJson(String jsonString)
      throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ConfirmationTrackingData.class);
  }

  /**
   * Convert an instance of ConfirmationTrackingData to an JSON string
   *
   * @return JSON string
   */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
