/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 4
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.model.transferwebhooks;

import java.util.Optional;
import java.util.logging.Logger;

/**
 * Handler for processing TransferWebhooks.
 *
 * <p>This class provides functionality to deserialize the payload of TransferWebhooks events.
 */
public class TransferWebhooksHandler {

  private static final Logger LOG = Logger.getLogger(TransferWebhooksHandler.class.getName());

  private final String payload;

  /**
   * Constructs a new handler for the given webhook payload
   *
   * @param payload the raw JSON payload from the webhook
   */
  public TransferWebhooksHandler(String payload) {
    this.payload = payload;
  }

  /**
   * Attempts to deserialize the webhook payload into a TransferNotificationRequest
   *
   * @return an Optional containing the deserialized object, or empty if deserialization fails
   */
  public Optional<TransferNotificationRequest> getTransferNotificationRequest() {

    var optionalTransferNotificationRequest = getOptionalField(TransferNotificationRequest.class);

    if (optionalTransferNotificationRequest.isPresent()) {
      // verify event type
      for (var value : TransferNotificationRequest.TypeEnum.values()) {
        if (value.equals(optionalTransferNotificationRequest.get().getType())) {
          // found matching event type
          return optionalTransferNotificationRequest;
        }
      }
    }

    return Optional.empty();
  }

  /**
   * Deserializes the payload into the specified class type.
   *
   * @param clazz the class to deserialize into
   * @param <T> the type of the class
   * @return an Optional containing the deserialized object, or empty if an error occurs
   */
  private <T> Optional<T> getOptionalField(Class<T> clazz) {
    try {
      T val = JSON.getMapper().readValue(payload, clazz);
      return Optional.ofNullable(val);
    } catch (Exception e) {
      // an error has occurred during deserialization (object not found, deserialization error)
      LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
      LOG.warning("Deserialization error: " + e.getMessage());
      return Optional.empty();
    }
  }
}
