/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.AuthorisedCardUsers;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizedCardUsersApi extends Service {

  public static final String API_VERSION = "2";

  protected String baseURL;

  /**
   * Authorized card users constructor in {@link com.adyen.service.balanceplatform package}.
   *
   * @param client {@link Client } (required)
   */
  public AuthorizedCardUsersApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
  }

  /**
   * Authorized card users constructor in {@link com.adyen.service.balanceplatform package}. Please
   * use this constructor only if you would like to pass along your own url for routing or testing
   * purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public AuthorizedCardUsersApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Create authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @param authorisedCardUsers {@link AuthorisedCardUsers } (required)
   * @param authorisedCardUsers {@link AuthorisedCardUsers } (required)
   * @throws ApiException if fails to make API call
   */
  public void createAuthorisedCardUsers(
      String paymentInstrumentId, AuthorisedCardUsers authorisedCardUsers)
      throws ApiException, IOException {
    createAuthorisedCardUsers(paymentInstrumentId, authorisedCardUsers, null);
  }

  /**
   * Create authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @param authorisedCardUsers {@link AuthorisedCardUsers } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @throws ApiException if fails to make API call
   */
  public void createAuthorisedCardUsers(
      String paymentInstrumentId,
      AuthorisedCardUsers authorisedCardUsers,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (paymentInstrumentId == null) {
      throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
    }
    pathParams.put("paymentInstrumentId", paymentInstrumentId);

    String requestBody = authorisedCardUsers.toJson();
    Resource resource =
        new Resource(
            this,
            this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers",
            null);
    resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
  }

  /**
   * Delete the authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteAuthorisedCardUsers(String paymentInstrumentId)
      throws ApiException, IOException {
    deleteAuthorisedCardUsers(paymentInstrumentId, null);
  }

  /**
   * Delete the authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteAuthorisedCardUsers(String paymentInstrumentId, RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (paymentInstrumentId == null) {
      throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
    }
    pathParams.put("paymentInstrumentId", paymentInstrumentId);

    String requestBody = null;
    Resource resource =
        new Resource(
            this,
            this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers",
            null);
    resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
  }

  /**
   * Get authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @return {@link AuthorisedCardUsers }
   * @throws ApiException if fails to make API call
   */
  public AuthorisedCardUsers getAllAuthorisedCardUsers(String paymentInstrumentId)
      throws ApiException, IOException {
    return getAllAuthorisedCardUsers(paymentInstrumentId, null);
  }

  /**
   * Get authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link AuthorisedCardUsers }
   * @throws ApiException if fails to make API call
   */
  public AuthorisedCardUsers getAllAuthorisedCardUsers(
      String paymentInstrumentId, RequestOptions requestOptions) throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (paymentInstrumentId == null) {
      throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
    }
    pathParams.put("paymentInstrumentId", paymentInstrumentId);

    String requestBody = null;
    Resource resource =
        new Resource(
            this,
            this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers",
            null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return AuthorisedCardUsers.fromJson(jsonResult);
  }

  /**
   * Update the authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @param authorisedCardUsers {@link AuthorisedCardUsers } (required)
   * @param authorisedCardUsers {@link AuthorisedCardUsers } (required)
   * @throws ApiException if fails to make API call
   */
  public void updateAuthorisedCardUsers(
      String paymentInstrumentId, AuthorisedCardUsers authorisedCardUsers)
      throws ApiException, IOException {
    updateAuthorisedCardUsers(paymentInstrumentId, authorisedCardUsers, null);
  }

  /**
   * Update the authorized users for a card.
   *
   * @param paymentInstrumentId {@link String } (required)
   * @param authorisedCardUsers {@link AuthorisedCardUsers } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateAuthorisedCardUsers(
      String paymentInstrumentId,
      AuthorisedCardUsers authorisedCardUsers,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (paymentInstrumentId == null) {
      throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
    }
    pathParams.put("paymentInstrumentId", paymentInstrumentId);

    String requestBody = authorisedCardUsers.toJson();
    Resource resource =
        new Resource(
            this,
            this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers",
            null);
    resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
  }
}
