/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.GetNetworkTokenResponse;
import com.adyen.model.balanceplatform.UpdateNetworkTokenRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NetworkTokensApi extends Service {

  public static final String API_VERSION = "2";

  protected String baseURL;

  /**
   * Network tokens constructor in {@link com.adyen.service.balanceplatform package}.
   *
   * @param client {@link Client } (required)
   */
  public NetworkTokensApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
  }

  /**
   * Network tokens constructor in {@link com.adyen.service.balanceplatform package}. Please use
   * this constructor only if you would like to pass along your own url for routing or testing
   * purposes. The latest API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public NetworkTokensApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Get a network token
   *
   * @param networkTokenId {@link String } The unique identifier of the network token. (required)
   * @return {@link GetNetworkTokenResponse }
   * @throws ApiException if fails to make API call
   */
  public GetNetworkTokenResponse getNetworkToken(String networkTokenId)
      throws ApiException, IOException {
    return getNetworkToken(networkTokenId, null);
  }

  /**
   * Get a network token
   *
   * @param networkTokenId {@link String } The unique identifier of the network token. (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link GetNetworkTokenResponse }
   * @throws ApiException if fails to make API call
   */
  public GetNetworkTokenResponse getNetworkToken(
      String networkTokenId, RequestOptions requestOptions) throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (networkTokenId == null) {
      throw new IllegalArgumentException("Please provide the networkTokenId path parameter");
    }
    pathParams.put("networkTokenId", networkTokenId);

    String requestBody = null;
    Resource resource = new Resource(this, this.baseURL + "/networkTokens/{networkTokenId}", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
    return GetNetworkTokenResponse.fromJson(jsonResult);
  }

  /**
   * Update a network token
   *
   * @param networkTokenId {@link String } The unique identifier of the network token. (required)
   * @param updateNetworkTokenRequest {@link UpdateNetworkTokenRequest } (required)
   * @throws ApiException if fails to make API call
   */
  public void updateNetworkToken(
      String networkTokenId, UpdateNetworkTokenRequest updateNetworkTokenRequest)
      throws ApiException, IOException {
    updateNetworkToken(networkTokenId, updateNetworkTokenRequest, null);
  }

  /**
   * Update a network token
   *
   * @param networkTokenId {@link String } The unique identifier of the network token. (required)
   * @param updateNetworkTokenRequest {@link UpdateNetworkTokenRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateNetworkToken(
      String networkTokenId,
      UpdateNetworkTokenRequest updateNetworkTokenRequest,
      RequestOptions requestOptions)
      throws ApiException, IOException {
    // Add path params
    Map<String, String> pathParams = new HashMap<>();
    if (networkTokenId == null) {
      throw new IllegalArgumentException("Please provide the networkTokenId path parameter");
    }
    pathParams.put("networkTokenId", networkTokenId);

    String requestBody = updateNetworkTokenRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/networkTokens/{networkTokenId}", null);
    resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
  }
}
