/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.checkout.BalanceCheckRequest;
import com.adyen.model.checkout.BalanceCheckResponse;
import com.adyen.model.checkout.CancelOrderRequest;
import com.adyen.model.checkout.CancelOrderResponse;
import com.adyen.model.checkout.CreateOrderRequest;
import com.adyen.model.checkout.CreateOrderResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class OrdersApi extends Service {

  public static final String API_VERSION = "71";

  protected String baseURL;

  /**
   * Orders constructor in {@link com.adyen.service.checkout package}.
   *
   * @param client {@link Client } (required)
   */
  public OrdersApi(Client client) {
    super(client);
    this.baseURL = createBaseURL("https://checkout-test.adyen.com/v71");
  }

  /**
   * Orders constructor in {@link com.adyen.service.checkout package}. Please use this constructor
   * only if you would like to pass along your own url for routing or testing purposes. The latest
   * API version is defined in this class as a constant.
   *
   * @param client {@link Client } (required)
   * @param baseURL {@link String } (required)
   */
  public OrdersApi(Client client, String baseURL) {
    super(client);
    this.baseURL = baseURL;
  }

  /**
   * Cancel an order
   *
   * @param cancelOrderRequest {@link CancelOrderRequest } (required)
   * @return {@link CancelOrderResponse }
   * @throws ApiException if fails to make API call
   */
  public CancelOrderResponse cancelOrder(CancelOrderRequest cancelOrderRequest)
      throws ApiException, IOException {
    return cancelOrder(cancelOrderRequest, null);
  }

  /**
   * Cancel an order
   *
   * @param cancelOrderRequest {@link CancelOrderRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link CancelOrderResponse }
   * @throws ApiException if fails to make API call
   */
  public CancelOrderResponse cancelOrder(
      CancelOrderRequest cancelOrderRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = cancelOrderRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/orders/cancel", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return CancelOrderResponse.fromJson(jsonResult);
  }

  /**
   * Get the balance of a gift card
   *
   * @param balanceCheckRequest {@link BalanceCheckRequest } (required)
   * @return {@link BalanceCheckResponse }
   * @throws ApiException if fails to make API call
   */
  public BalanceCheckResponse getBalanceOfGiftCard(BalanceCheckRequest balanceCheckRequest)
      throws ApiException, IOException {
    return getBalanceOfGiftCard(balanceCheckRequest, null);
  }

  /**
   * Get the balance of a gift card
   *
   * @param balanceCheckRequest {@link BalanceCheckRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link BalanceCheckResponse }
   * @throws ApiException if fails to make API call
   */
  public BalanceCheckResponse getBalanceOfGiftCard(
      BalanceCheckRequest balanceCheckRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = balanceCheckRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/paymentMethods/balance", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return BalanceCheckResponse.fromJson(jsonResult);
  }

  /**
   * Create an order
   *
   * @param createOrderRequest {@link CreateOrderRequest } (required)
   * @return {@link CreateOrderResponse }
   * @throws ApiException if fails to make API call
   */
  public CreateOrderResponse orders(CreateOrderRequest createOrderRequest)
      throws ApiException, IOException {
    return orders(createOrderRequest, null);
  }

  /**
   * Create an order
   *
   * @param createOrderRequest {@link CreateOrderRequest } (required)
   * @param requestOptions {@link RequestOptions } Object to store additional data such as
   *     idempotency-keys (optional)
   * @return {@link CreateOrderResponse }
   * @throws ApiException if fails to make API call
   */
  public CreateOrderResponse orders(
      CreateOrderRequest createOrderRequest, RequestOptions requestOptions)
      throws ApiException, IOException {
    String requestBody = createOrderRequest.toJson();
    Resource resource = new Resource(this, this.baseURL + "/orders", null);
    String jsonResult =
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
    return CreateOrderResponse.fromJson(jsonResult);
  }
}
