/**
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Java API Library
 *
 * Copyright (c) 2017 Adyen B.V.
 * This file is open source and available under the MIT license.
 * See the LICENSE file for more info.
 */
package com.adyen.model;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * FraudResult
 */
public class FraudResult {
    @SerializedName("accountScore")
    private Integer accountScore = null;

    @SerializedName("results")
    private List<FraudCheckResultContainer> results = new ArrayList<>();

    public FraudResult accountScore(Integer accountScore) {
        this.accountScore = accountScore;
        return this;
    }

    /**
     * the total fraud score generated by the risk checks
     *
     * @return accountScore
     **/
    public Integer getAccountScore() {
        return accountScore;
    }

    public void setAccountScore(Integer accountScore) {
        this.accountScore = accountScore;
    }

    public FraudResult results(List<FraudCheckResultContainer> results) {
        this.results = results;
        return this;
    }

    public List<FraudCheckResultContainer> getResults() {
        return results;
    }

    public void setResults(List<FraudCheckResultContainer> results) {
        this.results = results;
    }

    /**
     * the result of the individual risk checks
     *
     * @return results
     **/
    public List<FraudCheckResult> getFraudCheckResults() {
        return results.stream().map(s -> s.getFraudCheckResult()).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FraudResult fraudResult = (FraudResult) o;
        return Objects.equals(this.accountScore, fraudResult.accountScore) &&
                Objects.equals(this.results, fraudResult.results);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountScore, results);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FraudResult {\n");

        sb.append("    accountScore: ").append(toIndentedString(accountScore)).append("\n");
        sb.append("    results: ").append(toIndentedString(results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
