/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.analytics;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.webkit.URLUtil;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.util.LocaleUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class AnalyticEvent
implements Parcelable {
    private static final String DROPIN_FLAVOR = "dropin";
    private static final String COMPONENT_FLAVOR = "components";
    private static final String CURRENT_PAYLOAD_VERSION = "1";
    private static final String ANDROID_PLATFORM = "android";
    private static final String PAYLOAD_VERSION_KEY = "payload_version";
    private static final String VERSION_KEY = "version";
    private static final String FLAVOR_KEY = "flavor";
    private static final String COMPONENT_KEY = "component";
    private static final String LOCALE_KEY = "locale";
    private static final String PLATFORM_KEY = "platform";
    private static final String REFERER_KEY = "referer";
    private static final String DEVICE_BRAND_KEY = "device_brand";
    private static final String DEVICE_MODEL_KEY = "device_model";
    private static final String SYSTEM_VERSION_KEY = "system_version";
    private final String mPayloadVersion = "1";
    private final String mVersion = "3.8.0";
    private final String mFlavor;
    private final String mComponent;
    private final String mLocale;
    private final String mPlatform = "android";
    private final String mReferer;
    private final String mDeviceBrand = Build.BRAND;
    private final String mDeviceModel = Build.MODEL;
    private final String mSystemVersion = String.valueOf(Build.VERSION.SDK_INT);
    public static final Parcelable.Creator<AnalyticEvent> CREATOR = new Parcelable.Creator<AnalyticEvent>(){

        public AnalyticEvent createFromParcel(Parcel in) {
            return new AnalyticEvent(in);
        }

        public AnalyticEvent[] newArray(int size) {
            return new AnalyticEvent[size];
        }
    };

    @NonNull
    public static AnalyticEvent create(@NonNull Context context, @NonNull Flavor flavor, @NonNull String components, @NonNull Locale locale) {
        String flavorName;
        switch (flavor) {
            case DROPIN: {
                flavorName = DROPIN_FLAVOR;
                break;
            }
            case COMPONENT: {
                flavorName = COMPONENT_FLAVOR;
                break;
            }
            default: {
                throw new CheckoutException("Unexpected flavor - " + flavor.name());
            }
        }
        return new AnalyticEvent(context.getPackageName(), flavorName, components, LocaleUtil.toLanguageTag((Locale)locale));
    }

    AnalyticEvent(@NonNull Parcel in) {
        this.mFlavor = in.readString();
        this.mComponent = in.readString();
        this.mLocale = in.readString();
        this.mReferer = in.readString();
    }

    private AnalyticEvent(@NonNull String packageName, @NonNull String flavor, @NonNull String components, @NonNull String locale) {
        this.mReferer = packageName;
        this.mLocale = locale;
        this.mFlavor = flavor;
        this.mComponent = components;
    }

    @NonNull
    URL toUrl(@NonNull String baseUrl) throws MalformedURLException {
        if (!URLUtil.isValidUrl((String)baseUrl)) {
            throw new MalformedURLException("Invalid URL format - " + baseUrl);
        }
        Uri baseUri = Uri.parse((String)baseUrl);
        Uri finalUri = new Uri.Builder().scheme(baseUri.getScheme()).authority(baseUri.getAuthority()).path(baseUri.getPath()).appendQueryParameter(PAYLOAD_VERSION_KEY, CURRENT_PAYLOAD_VERSION).appendQueryParameter(VERSION_KEY, "3.8.0").appendQueryParameter(FLAVOR_KEY, this.mFlavor).appendQueryParameter(COMPONENT_KEY, this.mComponent).appendQueryParameter(LOCALE_KEY, this.mLocale).appendQueryParameter(PLATFORM_KEY, ANDROID_PLATFORM).appendQueryParameter(REFERER_KEY, this.mReferer).appendQueryParameter(DEVICE_BRAND_KEY, this.mDeviceBrand).appendQueryParameter(DEVICE_MODEL_KEY, this.mDeviceModel).appendQueryParameter(SYSTEM_VERSION_KEY, this.mSystemVersion).build();
        return new URL(finalUri.toString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mFlavor);
        dest.writeString(this.mComponent);
        dest.writeString(this.mLocale);
        dest.writeString(this.mReferer);
    }

    public static enum Flavor {
        DROPIN,
        COMPONENT;

    }
}

