/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.analytics;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import com.adyen.checkout.base.analytics.AnalyticEvent;
import com.adyen.checkout.core.api.Environment;
import com.adyen.checkout.core.api.SSLSocketUtil;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class AnalyticsDispatcher
extends JobIntentService {
    private static final String TAG = LogUtil.getTag();
    private static final String EVENT_KEY = "analytic_event";
    private static final String ENV_URL_KEY = "env_url_key";
    private static final String ANALYTICS_ENDPOINT = "images/analytics.png";
    private static final int ANALYTICS_JOB_ID = 4747;

    public static void dispatchEvent(@NonNull Context context, @NonNull Environment environment, @NonNull AnalyticEvent event) {
        Intent workIntent = new Intent();
        workIntent.putExtra(EVENT_KEY, (Parcelable)event);
        workIntent.putExtra(ENV_URL_KEY, environment.getBaseUrl());
        AnalyticsDispatcher.enqueueWork((Context)context, AnalyticsDispatcher.class, (int)4747, (Intent)workIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleWork(@NonNull Intent intent) {
        AnalyticEvent event = (AnalyticEvent)intent.getParcelableExtra(EVENT_KEY);
        String envUrl = intent.getStringExtra(ENV_URL_KEY);
        if (event == null) {
            Logger.e((String)TAG, (String)"Analytics event is null.");
            return;
        }
        if (envUrl == null) {
            Logger.e((String)TAG, (String)"env url is null.");
            return;
        }
        Logger.v((String)TAG, (String)"Sending analytic event.");
        HttpURLConnection urlConnection = null;
        try {
            URL finalUrl = event.toUrl(envUrl + ANALYTICS_ENDPOINT);
            urlConnection = (HttpsURLConnection)finalUrl.openConnection();
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(SSLSocketUtil.TLS_SOCKET_FACTORY);
            urlConnection.connect();
            InputStream inputStream = urlConnection.getInputStream();
            inputStream.read();
            inputStream.close();
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)"Failed to send analytics event.", (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }
}

