/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.api;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.adyen.checkout.base.api.LogoApi;
import com.adyen.checkout.base.api.LogoConnectionTask;
import com.adyen.checkout.core.api.Environment;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ImageLoader {
    private static final String TAG = LogUtil.getTag();
    private final LogoApi mLogoApi;
    private final Map<String, LogoConnectionTask.LogoCallback> mCallbacks = new HashMap<String, LogoConnectionTask.LogoCallback>();
    private final Map<String, WeakReference<ImageView>> mImageViews = new HashMap<String, WeakReference<ImageView>>();

    @NonNull
    public static ImageLoader getInstance(@NonNull Context context, @NonNull Environment environment) {
        return new ImageLoader(LogoApi.getInstance(environment, context.getResources().getDisplayMetrics()));
    }

    public ImageLoader(@NonNull LogoApi logoApi) {
        this.mLogoApi = logoApi;
    }

    public void load(@NonNull String txVariant, @NonNull ImageView view) {
        this.load(txVariant, view, 0, 0);
    }

    public void load(@NonNull String txVariant, @Nullable String txSubVariant, @NonNull ImageView view) {
        this.load(txVariant, txSubVariant, view, 0, 0);
    }

    public void load(@NonNull String txVariant, @NonNull ImageView view, @Nullable @DrawableRes int placeholder, @Nullable @DrawableRes int errorFallback) {
        this.load(txVariant, "", view, placeholder, errorFallback);
    }

    public void load(@NonNull String txVariant, @NonNull String txSubVariant, @NonNull ImageView view, @Nullable @DrawableRes int placeholder, final @Nullable @DrawableRes int errorFallback) {
        String id;
        if (placeholder != 0) {
            view.setImageResource(placeholder);
        }
        if (this.mCallbacks.containsKey(id = txVariant + txSubVariant + view.getId())) {
            this.mCallbacks.remove(id);
            this.mImageViews.remove(id);
        }
        LogoConnectionTask.LogoCallback callback = new LogoConnectionTask.LogoCallback(){

            @Override
            public void onLogoReceived(@NonNull BitmapDrawable drawable) {
                if (ImageLoader.this.mImageViews.containsKey(id)) {
                    ImageView imageView = (ImageView)((WeakReference)ImageLoader.this.mImageViews.get(id)).get();
                    if (imageView != null) {
                        imageView.setImageDrawable((Drawable)drawable);
                    } else {
                        Logger.e((String)TAG, (String)("ImageView is null for received Logo - " + id));
                    }
                    ImageLoader.this.mCallbacks.remove(id);
                    ImageLoader.this.mImageViews.remove(id);
                }
            }

            @Override
            public void onReceiveFailed() {
                ImageView imageView = (ImageView)((WeakReference)ImageLoader.this.mImageViews.get(id)).get();
                if (imageView != null) {
                    imageView.setImageResource(errorFallback);
                }
                ImageLoader.this.mCallbacks.remove(id);
                ImageLoader.this.mImageViews.remove(id);
            }
        };
        this.mImageViews.put(id, new WeakReference<ImageView>(view));
        this.mCallbacks.put(id, callback);
        this.mLogoApi.getLogo(txVariant, txSubVariant, null, callback);
    }
}

