/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.api;

import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.LruCache;
import com.adyen.checkout.base.api.LogoConnectionTask;
import com.adyen.checkout.core.api.Environment;
import com.adyen.checkout.core.api.ThreadManager;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LogoApi {
    private static final String TAG = LogUtil.getTag();
    private static final String LOGO_PATH = "images/logos/%1$s/%2$s.png";
    private static final Size DEFAULT_SIZE = Size.SMALL;
    static final int KILO_BYTE_SIZE = 1024;
    private static final int LRU_CACHE_MAX_SIZE;
    private static LogoApi sInstance;
    private final String mLogoUrlFormat;
    private final String mDensityExtension;
    private final LruCache<String, BitmapDrawable> mCache;
    private final Map<String, LogoConnectionTask> mConnectionsMap = new HashMap<String, LogoConnectionTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static LogoApi getInstance(@NonNull Environment environment, @NonNull DisplayMetrics displayMetrics) {
        String hostUrl = environment.getBaseUrl();
        Class<LogoApi> clazz = LogoApi.class;
        synchronized (LogoApi.class) {
            if (sInstance == null || LogoApi.isDifferentHost(sInstance, hostUrl)) {
                LogoApi.clearCache(sInstance);
                sInstance = new LogoApi(hostUrl, displayMetrics);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void clearCache(@Nullable LogoApi instance) {
        if (instance != null) {
            instance.mCache.evictAll();
        }
    }

    private static boolean isDifferentHost(@NonNull LogoApi logoApi, @NonNull String hostUrl) {
        return !logoApi.mLogoUrlFormat.startsWith(hostUrl);
    }

    private LogoApi(@NonNull String host, @NonNull DisplayMetrics displayMetrics) {
        Logger.v((String)TAG, (String)("Environment URL - " + host));
        this.mLogoUrlFormat = host + LOGO_PATH;
        this.mDensityExtension = this.getDensityExtension(displayMetrics.densityDpi);
        this.mCache = new LruCache<String, BitmapDrawable>(LRU_CACHE_MAX_SIZE){

            protected int sizeOf(String key, BitmapDrawable drawable) {
                return drawable.getBitmap().getByteCount() / 1024;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLogo(@NonNull String txVariant, @Nullable String txSubVariant, @Nullable Size size, @NonNull LogoConnectionTask.LogoCallback callback) {
        Logger.v((String)TAG, (String)("getLogo - " + txVariant + ", " + txSubVariant + ", " + (Object)((Object)size)));
        String logoUrl = this.buildUrl(txVariant, txSubVariant, size);
        LogoApi logoApi = this;
        synchronized (logoApi) {
            BitmapDrawable cachedLogo = (BitmapDrawable)this.mCache.get((Object)logoUrl);
            if (cachedLogo != null) {
                Logger.v((String)TAG, (String)"returning cached logo");
                callback.onLogoReceived(cachedLogo);
            } else if (!this.mConnectionsMap.containsKey(logoUrl)) {
                LogoConnectionTask logoConnectionTask = new LogoConnectionTask(this, logoUrl, callback);
                this.mConnectionsMap.put(logoUrl, logoConnectionTask);
                ThreadManager.EXECUTOR.submit((Runnable)((Object)logoConnectionTask));
            } else {
                Logger.d((String)TAG, (String)("Execution for " + txVariant + (TextUtils.isEmpty((CharSequence)txSubVariant) ? "" : "/" + txSubVariant) + " is already running."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLogoRequest(@NonNull String txVariant, @Nullable String txSubVariant, @Nullable Size size) {
        Logger.d((String)TAG, (String)"cancelLogoRequest");
        String logoUrl = this.buildUrl(txVariant, txSubVariant, size);
        LogoApi logoApi = this;
        synchronized (logoApi) {
            LogoConnectionTask taskToCancel = this.mConnectionsMap.remove(logoUrl);
            if (taskToCancel != null) {
                taskToCancel.cancel(true);
                Logger.d((String)TAG, (String)"canceled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancellAll() {
        LogoApi logoApi = this;
        synchronized (logoApi) {
            for (LogoConnectionTask task : this.mConnectionsMap.values()) {
                task.cancel(true);
            }
            this.mConnectionsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskFinished(@NonNull String logoUrl, @Nullable BitmapDrawable logo) {
        LogoApi logoApi = this;
        synchronized (logoApi) {
            this.mConnectionsMap.remove(logoUrl);
            if (logo != null) {
                this.mCache.put((Object)logoUrl, (Object)logo);
            }
        }
    }

    @NonNull
    private String getDensityExtension(int densityDpi) {
        if (densityDpi <= 120) {
            return "-ldpi";
        }
        if (densityDpi <= 160) {
            return "";
        }
        if (densityDpi <= 240) {
            return "-hdpi";
        }
        if (densityDpi <= 320) {
            return "-xhdpi";
        }
        if (densityDpi <= 480) {
            return "-xxhdpi";
        }
        return "-xxxhdpi";
    }

    @NonNull
    private String buildUrl(@NonNull String txVariant, @Nullable String txSubVariant, @Nullable Size size) {
        if (txSubVariant != null && !txSubVariant.isEmpty()) {
            return String.format(this.mLogoUrlFormat, this.getSizeVariant(size), txVariant + "/" + txSubVariant + this.mDensityExtension);
        }
        return String.format(this.mLogoUrlFormat, this.getSizeVariant(size), txVariant + this.mDensityExtension);
    }

    @NonNull
    private String getSizeVariant(@Nullable Size size) {
        if (size == null) {
            return DEFAULT_SIZE.toString();
        }
        return size.toString();
    }

    static {
        int availableMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheFractionSize = 8;
        LRU_CACHE_MAX_SIZE = availableMemory / 8;
    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

