/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.api;

import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.NonNull;
import com.adyen.checkout.base.api.LogoApi;
import com.adyen.checkout.base.api.LogoConnection;
import com.adyen.checkout.core.api.Connection;
import com.adyen.checkout.core.api.ConnectionTask;
import com.adyen.checkout.core.api.ThreadManager;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class LogoConnectionTask
extends ConnectionTask<BitmapDrawable> {
    private static final String TAG = LogUtil.getTag();
    private static final int SAFETY_TIMEOUT = 100;
    LogoCallback mCallback;
    private final String mLogoUrl;
    private final LogoApi mLogoApi;

    LogoConnectionTask(@NonNull LogoApi logoApi, @NonNull String logoUrl, @NonNull LogoCallback callback) {
        super((Connection)new LogoConnection(logoUrl));
        this.mLogoApi = logoApi;
        this.mLogoUrl = logoUrl;
        this.mCallback = callback;
    }

    protected void done() {
        Logger.v((String)TAG, (String)"done");
        if (this.isCancelled()) {
            Logger.d((String)TAG, (String)"canceled");
            this.notifyFailed();
        } else {
            try {
                BitmapDrawable result = (BitmapDrawable)this.get(100L, TimeUnit.MILLISECONDS);
                this.notifyLogo(result);
            }
            catch (ExecutionException e) {
                Logger.e((String)TAG, (String)("Execution failed for logo  - " + this.getLogoUrl()));
                this.notifyFailed();
            }
            catch (InterruptedException e) {
                Logger.e((String)TAG, (String)"Execution interrupted.", (Throwable)e);
                this.notifyFailed();
            }
            catch (TimeoutException e) {
                Logger.e((String)TAG, (String)"Execution timed out.", (Throwable)e);
                this.notifyFailed();
            }
        }
    }

    String getLogoUrl() {
        return this.mLogoUrl;
    }

    LogoApi getLogoApi() {
        return this.mLogoApi;
    }

    private void notifyLogo(final @NonNull BitmapDrawable drawable) {
        ThreadManager.MAIN_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                LogoConnectionTask.this.getLogoApi().taskFinished(LogoConnectionTask.this.getLogoUrl(), drawable);
                LogoConnectionTask.this.mCallback.onLogoReceived(drawable);
                LogoConnectionTask.this.mCallback = null;
            }
        });
    }

    private void notifyFailed() {
        ThreadManager.MAIN_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                LogoConnectionTask.this.getLogoApi().taskFinished(LogoConnectionTask.this.getLogoUrl(), null);
                LogoConnectionTask.this.mCallback.onReceiveFailed();
                LogoConnectionTask.this.mCallback = null;
            }
        });
    }

    public static interface LogoCallback {
        public void onLogoReceived(@NonNull BitmapDrawable var1);

        public void onReceiveFailed();
    }
}

