/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.component;

import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.adyen.checkout.base.ActionComponentProvider;
import com.adyen.checkout.base.component.Configuration;
import com.adyen.checkout.base.component.lifecycle.ActionComponentViewModel;
import com.adyen.checkout.base.component.lifecycle.ActionComponentViewModelFactory;
import com.adyen.checkout.core.exception.ComponentException;

public class ActionComponentProviderImpl<ConfigurationT extends Configuration, ComponentT extends ActionComponentViewModel<ConfigurationT>>
implements ActionComponentProvider<ComponentT> {
    private final Class<ComponentT> mComponentClass;
    private final Class<ConfigurationT> mConfigurationClass;
    private final boolean mRequiresConfiguration;

    public ActionComponentProviderImpl(@NonNull Class<ComponentT> componentClass, @NonNull Class<ConfigurationT> configurationClass) {
        this(componentClass, configurationClass, false);
    }

    public ActionComponentProviderImpl(@NonNull Class<ComponentT> componentClass, @NonNull Class<ConfigurationT> configurationClass, boolean requiresConfiguration) {
        this.mComponentClass = componentClass;
        this.mConfigurationClass = configurationClass;
        this.mRequiresConfiguration = requiresConfiguration;
    }

    @Override
    @NonNull
    public ComponentT get(@NonNull FragmentActivity activity) {
        if (this.requiresConfiguration()) {
            throw new ComponentException("This Component requires a Configuration object to be initialized.");
        }
        return (ComponentT)this.get(activity, null);
    }

    @Override
    @NonNull
    public ComponentT get(@NonNull Fragment fragment) {
        if (this.requiresConfiguration()) {
            throw new ComponentException("This Component requires a Configuration object to be initialized.");
        }
        return (ComponentT)this.get(fragment, null);
    }

    @Override
    @NonNull
    public ComponentT get(@NonNull FragmentActivity activity, @Nullable Configuration configuration) {
        ActionComponentViewModelFactory factory = new ActionComponentViewModelFactory(ActionComponentProviderImpl.checkApplication((Activity)activity), this.mConfigurationClass, configuration);
        return (ComponentT)((ActionComponentViewModel)ViewModelProviders.of((FragmentActivity)activity, (ViewModelProvider.Factory)factory).get(this.mComponentClass));
    }

    @Override
    @NonNull
    public ComponentT get(@NonNull Fragment fragment, @Nullable Configuration configuration) {
        ActionComponentViewModelFactory factory = new ActionComponentViewModelFactory(ActionComponentProviderImpl.checkApplication((Activity)fragment.getActivity()), this.mConfigurationClass, configuration);
        return (ComponentT)((ActionComponentViewModel)ViewModelProviders.of((Fragment)fragment, (ViewModelProvider.Factory)factory).get(this.mComponentClass));
    }

    @Override
    public boolean requiresConfiguration() {
        return this.mRequiresConfiguration;
    }

    @NonNull
    private static Application checkApplication(@Nullable Activity activity) {
        Application application;
        if (activity != null && (application = activity.getApplication()) != null) {
            return application;
        }
        throw new IllegalStateException("Your activity/fragment is not yet attached to Application. You can't request ViewModel before onCreate call.");
    }
}

