/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.component;

import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.adyen.checkout.base.ActionComponentData;
import com.adyen.checkout.base.ComponentError;
import com.adyen.checkout.base.component.Configuration;
import com.adyen.checkout.base.component.lifecycle.ActionComponentViewModel;
import com.adyen.checkout.base.model.payments.response.Action;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import java.util.List;
import org.json.JSONObject;

public abstract class BaseActionComponent<ConfigurationT extends Configuration>
extends ActionComponentViewModel<ConfigurationT> {
    private static final String TAG = LogUtil.getTag();
    private static final String PAYMENT_DATA_KEY = "payment_data";
    private final MutableLiveData<ActionComponentData> mResultLiveData = new MutableLiveData();
    private final MutableLiveData<ComponentError> mErrorMutableLiveData = new MutableLiveData();
    private String mPaymentData;

    public BaseActionComponent(@NonNull Application application, @Nullable ConfigurationT configuration) {
        super(application, configuration);
    }

    @Override
    public boolean canHandleAction(@NonNull Action action) {
        return this.getSupportedActionTypes().contains(action.getType());
    }

    @NonNull
    protected abstract List<String> getSupportedActionTypes();

    @Override
    public void handleAction(@NonNull Activity activity, @NonNull Action action) {
        if (!this.canHandleAction(action)) {
            this.notifyException((CheckoutException)new ComponentException("Action type not supported by this component - " + action.getType()));
            return;
        }
        this.mPaymentData = action.getPaymentData();
        try {
            this.handleActionInternal(activity, action);
        }
        catch (ComponentException e) {
            this.notifyException((CheckoutException)e);
        }
    }

    @Override
    public void observe(@NonNull LifecycleOwner lifecycleOwner, @NonNull Observer<ActionComponentData> observer) {
        this.mResultLiveData.observe(lifecycleOwner, observer);
    }

    @Override
    public void observeErrors(@NonNull LifecycleOwner lifecycleOwner, @NonNull Observer<ComponentError> observer) {
        this.mErrorMutableLiveData.observe(lifecycleOwner, observer);
    }

    public void saveState(@Nullable Bundle bundle) {
        if (bundle != null && !TextUtils.isEmpty((CharSequence)this.mPaymentData)) {
            if (bundle.containsKey(PAYMENT_DATA_KEY)) {
                Logger.d((String)TAG, (String)"bundle already has paymentData, overriding");
            }
            bundle.putString(PAYMENT_DATA_KEY, this.mPaymentData);
        }
    }

    public void restoreState(@Nullable Bundle bundle) {
        if (bundle != null && bundle.containsKey(PAYMENT_DATA_KEY) && TextUtils.isEmpty((CharSequence)this.mPaymentData)) {
            this.mPaymentData = bundle.getString(PAYMENT_DATA_KEY);
        }
    }

    protected abstract void handleActionInternal(@NonNull Activity var1, @NonNull Action var2) throws ComponentException;

    protected void notifyDetails(@NonNull JSONObject details) throws ComponentException {
        ActionComponentData actionComponentData = new ActionComponentData();
        actionComponentData.setDetails(details);
        actionComponentData.setPaymentData(this.mPaymentData);
        this.mResultLiveData.setValue((Object)actionComponentData);
    }

    protected void notifyException(@NonNull CheckoutException e) {
        this.mErrorMutableLiveData.postValue((Object)new ComponentError(e));
    }

    @Nullable
    protected String getPaymentData() {
        return this.mPaymentData;
    }
}

