/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.component;

import android.content.Context;
import android.support.annotation.NonNull;
import com.adyen.checkout.base.component.Configuration;
import com.adyen.checkout.base.util.ValidationUtils;
import com.adyen.checkout.core.api.Environment;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.util.LocaleUtil;
import java.util.Locale;

public abstract class BaseConfigurationBuilder<ConfigurationT extends Configuration> {
    @NonNull
    protected Locale mBuilderShopperLocale;
    @NonNull
    protected Environment mBuilderEnvironment;
    @NonNull
    protected String mBuilderClientKey = "";

    public BaseConfigurationBuilder(@NonNull Context context) {
        this(LocaleUtil.getLocale((Context)context), Environment.TEST);
    }

    public BaseConfigurationBuilder(@NonNull Locale shopperLocale, @NonNull Environment environment) {
        this.mBuilderShopperLocale = shopperLocale;
        this.mBuilderEnvironment = environment;
    }

    @NonNull
    public BaseConfigurationBuilder<ConfigurationT> setShopperLocale(@NonNull Locale builderShopperLocale) {
        this.mBuilderShopperLocale = builderShopperLocale;
        return this;
    }

    @NonNull
    public BaseConfigurationBuilder<ConfigurationT> setEnvironment(@NonNull Environment builderEnvironment) {
        this.mBuilderEnvironment = builderEnvironment;
        return this;
    }

    @NonNull
    public BaseConfigurationBuilder<ConfigurationT> setClientKey(@NonNull String builderClientKey) {
        if (!ValidationUtils.isClientKeyValid(builderClientKey)) {
            throw new CheckoutException("Client key is not valid.");
        }
        this.mBuilderClientKey = builderClientKey;
        return this;
    }

    @NonNull
    public abstract ConfigurationT build();
}

