/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.component;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.adyen.checkout.base.ComponentError;
import com.adyen.checkout.base.PaymentComponentState;
import com.adyen.checkout.base.ViewableComponent;
import com.adyen.checkout.base.analytics.AnalyticEvent;
import com.adyen.checkout.base.analytics.AnalyticsDispatcher;
import com.adyen.checkout.base.component.Configuration;
import com.adyen.checkout.base.component.InputData;
import com.adyen.checkout.base.component.OutputData;
import com.adyen.checkout.base.component.lifecycle.PaymentComponentViewModel;
import com.adyen.checkout.base.model.paymentmethods.PaymentMethod;
import com.adyen.checkout.core.api.ThreadManager;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;

public abstract class BasePaymentComponent<ConfigurationT extends Configuration, InputDataT extends InputData, OutputDataT extends OutputData, ComponentStateT extends PaymentComponentState>
extends PaymentComponentViewModel<ConfigurationT, ComponentStateT>
implements ViewableComponent<OutputDataT, ConfigurationT, ComponentStateT> {
    private static final String TAG = LogUtil.getTag();
    final MutableLiveData<ComponentStateT> mPaymentComponentStateLiveData = new MutableLiveData();
    private final MutableLiveData<ComponentError> mComponentErrorLiveData = new MutableLiveData();
    @Nullable
    private OutputDataT mOutputData;
    private final MutableLiveData<OutputDataT> mOutputLiveData = new MutableLiveData();
    private boolean mIsCreatedForDropIn = false;
    private boolean mIsAnalyticsEnabled = true;

    public BasePaymentComponent(@NonNull PaymentMethod paymentMethod, @NonNull ConfigurationT configuration) {
        super(paymentMethod, configuration);
        this.assertSupported(paymentMethod);
    }

    @Override
    @Deprecated
    @NonNull
    public String getPaymentMethodType() {
        if (this.getSupportedPaymentMethodTypes().length > 0) {
            return this.getSupportedPaymentMethodTypes()[0];
        }
        throw new CheckoutException("Component supported types is empty");
    }

    @Override
    public void observe(@NonNull LifecycleOwner lifecycleOwner, @NonNull Observer<ComponentStateT> observer) {
        this.mPaymentComponentStateLiveData.observe(lifecycleOwner, observer);
    }

    @Override
    public void observeErrors(@NonNull LifecycleOwner lifecycleOwner, @NonNull Observer<ComponentError> observer) {
        this.mComponentErrorLiveData.observe(lifecycleOwner, observer);
    }

    @Override
    @Nullable
    public PaymentComponentState getState() {
        return (PaymentComponentState)this.mPaymentComponentStateLiveData.getValue();
    }

    public final void inputDataChanged(@NonNull InputDataT inputData) {
        Logger.v((String)TAG, (String)"inputDataChanged");
        OutputDataT newOutputData = this.onInputDataChanged(inputData);
        if (!newOutputData.equals(this.mOutputData)) {
            this.mOutputData = newOutputData;
            this.mOutputLiveData.setValue(this.mOutputData);
            this.notifyStateChanged();
        }
    }

    public void setAnalyticsEnabled(boolean isEnabled) {
        this.mIsAnalyticsEnabled = isEnabled;
    }

    @Override
    public void sendAnalyticsEvent(@NonNull Context context) {
        if (this.mIsAnalyticsEnabled) {
            AnalyticEvent.Flavor flavor = this.mIsCreatedForDropIn ? AnalyticEvent.Flavor.DROPIN : AnalyticEvent.Flavor.COMPONENT;
            String type = this.getPaymentMethod().getType();
            if (TextUtils.isEmpty((CharSequence)type)) {
                throw new CheckoutException("Payment method has empty or null type");
            }
            AnalyticEvent analyticEvent = AnalyticEvent.create(context, flavor, type, ((Configuration)this.getConfiguration()).getShopperLocale());
            AnalyticsDispatcher.dispatchEvent(context, ((Configuration)this.getConfiguration()).getEnvironment(), analyticEvent);
        }
    }

    @Override
    public void observeOutputData(@NonNull LifecycleOwner lifecycleOwner, @NonNull Observer<OutputDataT> observer) {
        this.mOutputLiveData.observe(lifecycleOwner, observer);
    }

    @Override
    @Nullable
    public OutputDataT getOutputData() {
        return this.mOutputData;
    }

    @NonNull
    protected abstract OutputDataT onInputDataChanged(@NonNull InputDataT var1);

    @NonNull
    @WorkerThread
    protected abstract ComponentStateT createComponentState();

    protected void notifyException(@NonNull CheckoutException e) {
        Logger.e((String)TAG, (String)("notifyException - " + e.getMessage()));
        this.mComponentErrorLiveData.postValue((Object)new ComponentError(e));
    }

    private void notifyStateChanged() {
        ThreadManager.EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                BasePaymentComponent.this.mPaymentComponentStateLiveData.postValue(BasePaymentComponent.this.createComponentState());
            }
        });
    }

    private void assertSupported(@NonNull PaymentMethod paymentMethod) {
        if (!this.isSupported(paymentMethod)) {
            throw new IllegalArgumentException("Unsupported payment method type " + (Object)((Object)paymentMethod));
        }
    }

    private boolean isSupported(@NonNull PaymentMethod paymentMethod) {
        for (String paymentMethodType : this.getSupportedPaymentMethodTypes()) {
            if (!paymentMethodType.equals(paymentMethod.getType())) continue;
            return true;
        }
        return false;
    }

    public void setCreatedForDropIn() {
        this.mIsCreatedForDropIn = true;
    }
}

