/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.component;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.adyen.checkout.core.api.Environment;
import java.io.Serializable;
import java.util.Locale;

public abstract class Configuration
implements Parcelable {
    private final Locale mShopperLocale;
    private final Environment mEnvironment;
    private final String mClientKey;

    protected Configuration(@NonNull Locale shopperLocale, @NonNull Environment environment, @Nullable String clientKey) {
        this.mShopperLocale = shopperLocale;
        this.mEnvironment = environment;
        this.mClientKey = clientKey;
    }

    protected Configuration(@NonNull Parcel in) {
        this.mShopperLocale = (Locale)in.readSerializable();
        this.mEnvironment = (Environment)in.readParcelable(Environment.class.getClassLoader());
        this.mClientKey = in.readString();
    }

    @NonNull
    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    @NonNull
    public Locale getShopperLocale() {
        return this.mShopperLocale;
    }

    @NonNull
    public String getClientKey() {
        return this.mClientKey;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.mShopperLocale);
        dest.writeParcelable((Parcelable)this.mEnvironment, flags);
        dest.writeString(this.mClientKey);
    }
}

