/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.base.component;

import android.app.Application;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.adyen.checkout.base.ComponentAvailableCallback;
import com.adyen.checkout.base.PaymentComponentProvider;
import com.adyen.checkout.base.component.BasePaymentComponent;
import com.adyen.checkout.base.component.Configuration;
import com.adyen.checkout.base.component.lifecycle.PaymentComponentViewModelFactory;
import com.adyen.checkout.base.model.paymentmethods.PaymentMethod;
import com.adyen.checkout.core.exception.CheckoutException;

public final class PaymentComponentProviderImpl<BaseComponentT extends BasePaymentComponent, ConfigurationT extends Configuration>
implements PaymentComponentProvider<BaseComponentT, ConfigurationT> {
    private final Class<BaseComponentT> mComponentClass;

    public PaymentComponentProviderImpl(@NonNull Class<BaseComponentT> modelClass) {
        this.mComponentClass = modelClass;
    }

    @Override
    @NonNull
    public BaseComponentT get(@NonNull FragmentActivity activity, @NonNull PaymentMethod paymentMethod, @NonNull ConfigurationT configuration) throws CheckoutException {
        PaymentComponentViewModelFactory factory = new PaymentComponentViewModelFactory(paymentMethod, (Configuration)configuration);
        return (BaseComponentT)((BasePaymentComponent)ViewModelProviders.of((FragmentActivity)activity, (ViewModelProvider.Factory)factory).get(this.mComponentClass));
    }

    @Override
    @NonNull
    public BaseComponentT get(@NonNull Fragment fragment, @NonNull PaymentMethod paymentMethod, @NonNull ConfigurationT configuration) throws CheckoutException {
        PaymentComponentViewModelFactory factory = new PaymentComponentViewModelFactory(paymentMethod, (Configuration)configuration);
        return (BaseComponentT)((BasePaymentComponent)ViewModelProviders.of((Fragment)fragment, (ViewModelProvider.Factory)factory).get(this.mComponentClass));
    }

    @Override
    public void isAvailable(@NonNull Application applicationContext, @NonNull PaymentMethod paymentMethod, @NonNull ConfigurationT config, @NonNull ComponentAvailableCallback<ConfigurationT> callback) {
        callback.onAvailabilityResult(true, paymentMethod, config);
    }
}

